/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.drops;

import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.entities.npcs.registry.DropItemRegistry;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity8HoldsItems;
import com.pixelmonmod.pixelmon.entities.pixelmon.drops.DropItemQueryList;
import com.pixelmonmod.pixelmon.entities.pixelmon.drops.DroppedItem;
import java.util.ArrayList;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class DropItemHelper {
    Entity8HoldsItems pixelmon;

    public DropItemHelper(Entity8HoldsItems entity8HoldsItems) {
        this.pixelmon = entity8HoldsItems;
    }

    public Item getDropItem() {
        return null;
    }

    public static boolean giveItemStackToPlayer(EntityPlayer player, ItemStack itemstack) {
        return DropItemHelper.giveItemStackToPlayer(player, (Integer)1, itemstack);
    }

    public static boolean giveItemStackToPlayer(EntityPlayer player, Integer count, ItemStack itemstack) {
        if (player.field_70170_p.field_72995_K) {
            boolean boolAddedToInventory = true;
            for (int i = 0; i < count; ++i) {
                boolAddedToInventory = player.field_71071_by.func_70441_a(itemstack);
                if (boolAddedToInventory || itemstack.func_77952_i() != 0) continue;
                player.func_145779_a(itemstack.func_77973_b(), 1);
                ChatHandler.sendFormattedChat((ICommandSender)player, TextFormatting.RED, "pixelmon.drops.fullinventory", itemstack.func_77973_b().func_77653_i(itemstack));
            }
            return boolAddedToInventory;
        }
        return DropItemHelper.giveItemStackToPlayer((EntityPlayerMP)player, count, itemstack);
    }

    public static boolean giveItemStackToPlayer(EntityPlayerMP player, ItemStack itemstack) {
        return DropItemHelper.giveItemStackToPlayer(player, (Integer)itemstack.func_190916_E(), itemstack);
    }

    public static boolean giveItemStackToPlayer(EntityPlayerMP player, Integer count, ItemStack itemstack) {
        return DropItemHelper.giveItemStackToPlayer(player, count, itemstack, false);
    }

    public static boolean giveItemStackToPlayer(EntityPlayerMP player, ItemStack itemstack, boolean itemsOwnedByPlayer) {
        return DropItemHelper.giveItemStackToPlayer(player, 1, itemstack, itemsOwnedByPlayer);
    }

    public static boolean giveItemStackToPlayer(EntityPlayerMP player, Integer count, ItemStack itemstack, boolean itemsOwnedByPlayer) {
        boolean boolAddedToInventory = true;
        for (int i = 0; i < count; ++i) {
            itemstack.func_190920_e(1);
            boolAddedToInventory = player.field_71071_by.func_70441_a(itemstack);
            if (!boolAddedToInventory && itemstack.func_77952_i() == 0) {
                DropItemHelper.dropItemOnGround(player, itemstack, itemsOwnedByPlayer, true);
                continue;
            }
            player.func_71120_a(player.field_71069_bz);
        }
        return boolAddedToInventory;
    }

    public static void dropItemOnGround(EntityPlayerMP player, ItemStack itemstack, boolean itemsOwnedByPlayer, boolean announce) {
        EntityItem entityitem = player.func_145779_a(itemstack.func_77973_b(), 1);
        if (itemsOwnedByPlayer && entityitem != null) {
            entityitem.func_145797_a(player.func_70005_c_());
        }
        if (announce) {
            ChatHandler.sendFormattedChat((ICommandSender)player, TextFormatting.RED, "pixelmon.drops.fullinventory", itemstack.func_77973_b().func_77653_i(itemstack));
        }
    }

    public static void dropItemOnGround(Vec3d position, EntityPlayerMP player, ItemStack itemstack, boolean itemsOwnedByPlayer, boolean announce) {
        EntityItem entityitem = DropItemHelper.createItemEntity(position, itemstack, player.field_70170_p);
        if (itemsOwnedByPlayer && entityitem != null) {
            entityitem.func_145797_a(player.func_70005_c_());
        }
        if (announce) {
            ChatHandler.sendFormattedChat((ICommandSender)player, TextFormatting.RED, "pixelmon.drops.fullinventory", itemstack.func_77973_b().func_77653_i(itemstack));
        }
    }

    public static EntityItem createItemEntity(Vec3d position, ItemStack stack, World world) {
        if (stack.func_190916_E() != 0 && stack.func_77973_b() != null) {
            EntityItem entityitem = new EntityItem(world, position.field_72450_a, position.field_72448_b + 0.5, position.field_72449_c, stack);
            entityitem.func_174869_p();
            world.func_72838_d((Entity)entityitem);
            return entityitem;
        }
        return null;
    }

    public void dropNormalItems(EntityPlayerMP player) {
        if (!PixelmonConfig.pokemonDropsEnabled || this.pixelmon.hasOwner() || this.pixelmon.getTrainer() != null) {
            return;
        }
        if (this.pixelmon.isBossPokemon()) {
            return;
        }
        ArrayList<ItemStack> items = DropItemRegistry.getDropsForPokemon(this.pixelmon);
        int id = 0;
        ArrayList<DroppedItem> givenDrops = new ArrayList<DroppedItem>();
        for (ItemStack item : items) {
            if (item == null) continue;
            givenDrops.add(new DroppedItem(item, id++));
        }
        if (givenDrops.size() > 0) {
            DropItemQueryList.register(this.pixelmon, givenDrops, player);
        }
    }

    public void dropBossItems(EntityPlayerMP player) {
        ArrayList<ItemStack> items = DropItemRegistry.getDropsForPokemon(this.pixelmon);
        int id = 0;
        ArrayList<DroppedItem> givenDrops = new ArrayList<DroppedItem>();
        for (ItemStack item : items) {
            if (item == null) continue;
            givenDrops.add(new DroppedItem(item, id++));
        }
        ArrayList<ItemStack> bossDrops = DropItemRegistry.getBossDrops(this.pixelmon, player);
        for (ItemStack item : bossDrops) {
            givenDrops.add(new DroppedItem(item, id++));
        }
        if (givenDrops.size() > 0) {
            DropItemQueryList.register(this.pixelmon, givenDrops, player);
        }
    }
}

