/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.externalMoves;

import com.pixelmonmod.pixelmon.comm.PixelmonData;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.externalMoves.ExternalMoveBase;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class Dig
extends ExternalMoveBase {
    private List<Block> allowedBlocks = Arrays.asList(Blocks.field_150349_c, Blocks.field_150354_m, Blocks.field_150322_A, Blocks.field_150348_b, Blocks.field_150351_n, Blocks.field_150391_bh, Blocks.field_150346_d);

    public Dig() {
        super("dig", "Dig");
    }

    @Override
    public boolean execute(EntityPixelmon user, RayTraceResult target, int moveIndex) {
        BlockPos pos;
        int depth = 74 - (int)(((float)user.stats.Attack - 20.0f) / 180.0f * 74.0f);
        if (depth < 2) {
            depth = 2;
        }
        int maxOff = 1;
        if (user.stats.Attack > 150) {
            maxOff = 2;
        }
        if (user.stats.Attack > 300) {
            maxOff = 3;
        }
        if ((pos = target.func_178782_a()).func_177956_o() < depth) {
            user.field_70170_p.func_184133_a(null, pos, SoundEvents.field_187689_f, SoundCategory.NEUTRAL, 1.0f, 0.1f);
            return true;
        }
        if (target.field_178784_b == EnumFacing.UP) {
            for (int xOff = -1 * maxOff; xOff <= maxOff; ++xOff) {
                for (int zOff = -1 * maxOff; zOff <= maxOff; ++zOff) {
                    this.doHarvest(user, pos.func_177982_a(xOff, 0, zOff));
                }
            }
        } else if (target.field_178784_b == EnumFacing.DOWN) {
            for (int xOff = -1 * maxOff; xOff <= maxOff; ++xOff) {
                for (int zOff = -1 * maxOff; zOff <= maxOff; ++zOff) {
                    this.doHarvest(user, pos.func_177982_a(xOff, 0, zOff));
                }
            }
        } else if (target.field_178784_b == EnumFacing.SOUTH) {
            for (int xOff = -1 * maxOff; xOff <= maxOff; ++xOff) {
                for (int yOff = -1 * maxOff; yOff <= maxOff; ++yOff) {
                    this.doHarvest(user, pos.func_177982_a(xOff, yOff, 0));
                }
            }
        } else if (target.field_178784_b == EnumFacing.NORTH) {
            for (int xOff = -1 * maxOff; xOff <= maxOff; ++xOff) {
                for (int yOff = -1 * maxOff; yOff <= maxOff; ++yOff) {
                    this.doHarvest(user, pos.func_177982_a(xOff, yOff, 0));
                }
            }
        } else if (target.field_178784_b == EnumFacing.EAST) {
            for (int yOff = -1 * maxOff; yOff <= maxOff; ++yOff) {
                for (int zOff = -1 * maxOff; zOff <= maxOff; ++zOff) {
                    this.doHarvest(user, pos.func_177982_a(0, yOff, zOff));
                }
            }
        } else if (target.field_178784_b == EnumFacing.WEST) {
            for (int yOff = -1 * maxOff; yOff <= maxOff; ++yOff) {
                for (int zOff = -1 * maxOff; zOff <= maxOff; ++zOff) {
                    this.doHarvest(user, pos.func_177982_a(0, yOff, zOff));
                }
            }
        }
        user.field_70170_p.func_184133_a(null, pos, SoundEvents.field_187571_bR, SoundCategory.NEUTRAL, 1.0f, 0.1f);
        return true;
    }

    private void doHarvest(EntityPixelmon user, BlockPos pos) {
        IBlockState state = user.field_70170_p.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (this.allowedBlocks.contains(block)) {
            EntityPlayerMP player = (EntityPlayerMP)user.func_70902_q();
            boolean flag = block.canHarvestBlock((IBlockAccess)user.field_70170_p, pos, (EntityPlayer)player);
            boolean flag1 = this.removeBlock(pos, user.field_70170_p, player, flag);
            if (flag && flag1) {
                block.func_176226_b(user.field_70170_p, pos, state, 0);
            }
        }
    }

    private boolean removeBlock(BlockPos pos, World theWorld, EntityPlayerMP playerMP, boolean canHarvest) {
        IBlockState iblockstate = theWorld.func_180495_p(pos);
        boolean flag = false;
        Block block = iblockstate.func_177230_c();
        block.func_176208_a(theWorld, pos, iblockstate, (EntityPlayer)playerMP);
        flag = block.removedByPlayer(iblockstate, theWorld, pos, (EntityPlayer)playerMP, canHarvest);
        if (flag) {
            block.func_176206_d(theWorld, pos, iblockstate);
        }
        return flag;
    }

    @Override
    public int getCooldown(EntityPixelmon user) {
        return (int)Math.max(0.0f, (200.0f - (float)user.stats.Speed) / 30.0f * 20.0f);
    }

    @Override
    public int getCooldown(PixelmonData user) {
        return (int)Math.max(0.0f, (200.0f - (float)user.Speed) / 30.0f * 20.0f);
    }

    @Override
    public boolean isDestructive() {
        return true;
    }
}

