/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.helpers;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.PixelmonMethods;
import com.pixelmonmod.pixelmon.api.enums.ReceiveType;
import com.pixelmonmod.pixelmon.api.events.EvolveEvent;
import com.pixelmonmod.pixelmon.api.events.PixelmonReceivedEvent;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonSpec;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.status.StatusPersist;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenReplaceMoveScreen;
import com.pixelmonmod.pixelmon.comm.packetHandlers.evolution.EvolutionStage;
import com.pixelmonmod.pixelmon.comm.packetHandlers.evolution.EvolvePokemon;
import com.pixelmonmod.pixelmon.comm.packetHandlers.evolution.OpenEvolutionGUI;
import com.pixelmonmod.pixelmon.config.PixelmonEntityList;
import com.pixelmonmod.pixelmon.config.PixelmonItemsPokeballs;
import com.pixelmonmod.pixelmon.database.DatabaseMoves;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity3HasStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.EvolutionQueryList;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.BaseStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Level;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Moveset;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.Evolution;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.types.LevelingEvolution;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import com.pixelmonmod.pixelmon.util.AirSaver;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EvolutionQuery {
    EntityPixelmon pixelmon;
    Evolution evolution = null;
    PokemonSpec newPokemon;
    public int[] pokemonID;
    boolean fromLevelUp;
    int level;
    int newForm;
    EntityPlayerMP player;
    boolean normalEvolution = true;
    EvolutionStage stage;
    private AirSaver airSaver;
    int ticks = 0;

    public EvolutionQuery(EntityPixelmon pixelmon, Evolution evolution) {
        this.pixelmon = pixelmon;
        this.newPokemon = evolution.to;
        this.pokemonID = pixelmon.getPokemonId();
        this.evolution = evolution;
        this.fromLevelUp = evolution instanceof LevelingEvolution;
        if (pixelmon.func_70902_q() != null) {
            this.player = (EntityPlayerMP)pixelmon.func_70902_q();
            this.airSaver = new AirSaver(this.player);
        }
        this.sendQuery();
        this.level = pixelmon.getLvl().getLevel();
        pixelmon.field_70714_bg.field_75782_a.clear();
        this.setStage(EvolutionStage.PreChoice);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EvolutionQuery(EntityPixelmon pixelmon, int form) {
        this.normalEvolution = false;
        this.pixelmon = pixelmon;
        this.pokemonID = pixelmon.getPokemonId();
        this.fromLevelUp = false;
        this.newForm = form;
        if (pixelmon.func_70902_q() != null) {
            this.player = (EntityPlayerMP)pixelmon.func_70902_q();
            this.airSaver = new AirSaver(this.player);
        }
        this.level = pixelmon.getLvl().getLevel();
        pixelmon.field_70714_bg.field_75782_a.clear();
        this.setStage(EvolutionStage.PreAnimation);
        this.updateAllAround(this.stage);
        List<EvolutionQuery> list = EvolutionQueryList.queryList;
        synchronized (list) {
            EvolutionQueryList.queryList.add(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void tick(World world) {
        if (this.pixelmon.field_70170_p != world) {
            return;
        }
        if (this.airSaver != null) {
            this.airSaver.tick();
        }
        if (this.stage == EvolutionStage.Choice) {
            return;
        }
        ++this.ticks;
        if (this.stage == EvolutionStage.PreChoice) {
            if (this.ticks >= this.stage.ticks) {
                this.ticks = 0;
                this.setStage(EvolutionStage.Choice);
            }
        } else if (this.stage == EvolutionStage.PreAnimation) {
            if (this.ticks >= this.stage.ticks) {
                this.ticks = 0;
                this.setStage(EvolutionStage.PostAnimation);
                this.updateAllAround(this.stage);
                this.doEvoSwitch();
            }
        } else if (this.stage == EvolutionStage.PostAnimation && this.ticks >= this.stage.ticks) {
            this.ticks = 0;
            this.setStage(EvolutionStage.End);
            if (this.evolution != null) {
                this.evolution.finishedEvolving(this.pixelmon);
            }
            this.updateAllAround(this.stage);
            List<EvolutionQuery> list = EvolutionQueryList.queryList;
            synchronized (list) {
                EvolutionQueryList.queryList.remove(this);
            }
        }
    }

    private void setStage(EvolutionStage stage) {
        this.stage = stage;
        this.pixelmon.evoStage = stage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendQuery() {
        if (this.pixelmon.hasOwner()) {
            Pixelmon.network.sendTo((IMessage)new OpenEvolutionGUI(this.pokemonID, this.newPokemon.name), this.player);
            this.updateAllAround(EvolutionStage.Choice);
            this.removeExisting();
            List<EvolutionQuery> list = EvolutionQueryList.queryList;
            synchronized (list) {
                EvolutionQueryList.queryList.add(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeExisting() {
        List<EvolutionQuery> list = EvolutionQueryList.queryList;
        synchronized (list) {
            for (int i = 0; i < EvolutionQueryList.queryList.size(); ++i) {
                EvolutionQuery query = EvolutionQueryList.queryList.get(i);
                if (!PixelmonMethods.isIDSame(query.pokemonID, this.pokemonID)) continue;
                EvolutionQueryList.queryList.remove(i);
                break;
            }
        }
    }

    void accept() {
        this.setStage(EvolutionStage.PreAnimation);
        this.ticks = 0;
        this.updateAllAround(this.stage);
    }

    void doEvoSwitch() {
        if (this.normalEvolution) {
            EntityPixelmon pre = (EntityPixelmon)PixelmonEntityList.createEntityByName(this.pixelmon.getPokemonName(), this.pixelmon.field_70170_p);
            this.pixelmon.evolve(this.newPokemon);
            this.checkShedinja();
            this.checkForLearnMoves();
            this.evolution.finishedEvolving(this.pixelmon);
            Pixelmon.EVENT_BUS.post((Event)new EvolveEvent.PostEvolve(this.player, pre, this.evolution, this.pixelmon));
            if (!this.pixelmon.getPokemonName().equals(EnumPokemon.Shedinja.name)) {
                Pixelmon.EVENT_BUS.post((Event)new PixelmonReceivedEvent(this.player, ReceiveType.Evolution, this.pixelmon));
            }
        } else {
            this.pixelmon.setForm(this.newForm);
            this.pixelmon.func_184185_a(SoundEvents.field_187539_bB, 1.0f, 1.0f);
            if (this.pixelmon.battleController == null) {
                this.pixelmon.resetAI();
                this.pixelmon.setBlockTarget((int)this.pixelmon.field_70165_t, (int)this.pixelmon.field_70163_u, (int)this.pixelmon.field_70161_v, EnumFacing.SOUTH, -1);
            }
        }
    }

    private void removeEntity() {
        this.pixelmon.unloadEntity();
    }

    void decline() {
        this.removeEntity();
    }

    private void checkShedinja() {
        EntityPlayerMP player;
        PlayerStorage storage;
        Optional<PlayerStorage> optstorage;
        if (this.pixelmon.baseStats.pokemon == EnumPokemon.Ninjask && (optstorage = this.pixelmon.getStorage()).isPresent() && (storage = optstorage.get()).hasSpace() && (player = storage.getPlayer()) != null && player.field_71071_by.func_174925_a(PixelmonItemsPokeballs.pokeBall, 0, 1, null) == 1) {
            EntityPixelmon shedinja = new EntityPixelmon(player.field_70170_p);
            shedinja.init(EnumPokemon.Shedinja.name);
            Level shedinjaLevel = shedinja.getLvl();
            Level ninjaskLevel = this.pixelmon.getLvl();
            shedinjaLevel.setLevel(ninjaskLevel.getLevel());
            shedinjaLevel.setExp(ninjaskLevel.getExp());
            Moveset moveset = shedinja.getMoveset();
            moveset.clear();
            moveset.addAll(this.pixelmon.getMoveset());
            shedinja.status = (StatusPersist)this.pixelmon.status.copy();
            shedinja.setIsShiny(this.pixelmon.getIsShiny());
            shedinja.setGrowth(this.pixelmon.getGrowth());
            shedinja.friendship.setFriendship(this.pixelmon.friendship.getFriendship());
            shedinja.setNature(this.pixelmon.getNature());
            shedinja.stats.EVs = this.pixelmon.stats.EVs.cloneEVs();
            shedinja.stats.IVs.CopyIVs(this.pixelmon.stats.IVs);
            shedinja.originalTrainer = this.pixelmon.originalTrainer;
            Pixelmon.EVENT_BUS.post((Event)new PixelmonReceivedEvent(this.player, ReceiveType.Evolution, shedinja));
            storage.addToParty(shedinja);
        }
    }

    private void checkForLearnMoves() {
        String name = this.pixelmon.getPokemonName();
        Optional<BaseStats> optional = Entity3HasStats.getBaseStats(name, this.pixelmon.getForm());
        if (!optional.isPresent()) {
            return;
        }
        BaseStats baseStats = optional.get();
        this.pixelmon.baseStats.id = baseStats.id;
        this.pixelmon.baseStats.baseFormID = baseStats.baseFormID;
        int level = this.pixelmon.getLvl().getLevel();
        if (level == 1) {
            level = 0;
        }
        if (DatabaseMoves.learnsAttackAtLevel(this.pixelmon, level)) {
            ArrayList<Attack> newAttacks = DatabaseMoves.getAttacksAtLevel(this.pixelmon, level);
            Moveset moveset = this.pixelmon.getMoveset();
            newAttacks.stream().filter(a -> !moveset.hasAttack((Attack)a)).forEach(a -> {
                if (moveset.size() >= 4) {
                    Pixelmon.network.sendTo((IMessage)new OpenReplaceMoveScreen(this.pixelmon.getPokemonId(), a.baseAttack.attackIndex, 0, this.pixelmon.getLvl().getLevel()), (EntityPlayerMP)this.pixelmon.func_70902_q());
                } else {
                    moveset.add((Attack)a);
                    this.pixelmon.update(EnumUpdateType.Moveset);
                    if (BattleRegistry.getBattle((EntityPlayer)this.pixelmon.func_70902_q()) != null) {
                        ChatHandler.sendBattleMessage((Entity)this.pixelmon.func_70902_q(), "pixelmon.stats.learnedmove", this.pixelmon.getNickname(), a.baseAttack.getLocalizedName());
                    } else {
                        ChatHandler.sendChat((Entity)this.pixelmon.func_70902_q(), "pixelmon.stats.learnedmove", this.pixelmon.getNickname(), a.baseAttack.getLocalizedName());
                    }
                }
            });
        }
    }

    public boolean isEnded() {
        return this.stage == EvolutionStage.End;
    }

    private void updateAllAround(EvolutionStage currentStage) {
        Object owner = this.pixelmon.func_70902_q();
        if (owner == null) {
            owner = this.pixelmon;
        }
        NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(owner.field_71093_bK, owner.field_70165_t, owner.field_70163_u, owner.field_70161_v, 60.0);
        Pixelmon.network.sendToAllAround((IMessage)new EvolvePokemon(this.pokemonID, currentStage), point);
    }
}

