/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.stats;

import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.StatsType;
import java.util.HashMap;
import net.minecraft.nbt.NBTTagCompound;

public class EVsStore {
    public int HP = 0;
    public int Attack = 0;
    public int Defence = 0;
    public int SpecialAttack = 0;
    public int SpecialDefence = 0;
    public int Speed = 0;
    public static int MAX_EVS = 252;
    public static int MAX_TOTAL_EVS = 510;

    public EVsStore() {
    }

    public EVsStore(int[] evs) {
        this.HP = evs[0];
        this.Attack = evs[1];
        this.Defence = evs[2];
        this.SpecialAttack = evs[3];
        this.SpecialDefence = evs[4];
        this.Speed = evs[5];
    }

    public void gainEV(EVsStore evGain) {
        int remainingEVs = this.getRemainingEVs();
        this.HP = Math.min(MAX_EVS, this.HP + Math.min(remainingEVs, evGain.HP));
        remainingEVs = this.getRemainingEVs();
        this.Attack = Math.min(MAX_EVS, this.Attack + Math.min(remainingEVs, evGain.Attack));
        remainingEVs = this.getRemainingEVs();
        this.Defence = Math.min(MAX_EVS, this.Defence + Math.min(remainingEVs, evGain.Defence));
        remainingEVs = this.getRemainingEVs();
        this.SpecialAttack = Math.min(MAX_EVS, this.SpecialAttack + Math.min(remainingEVs, evGain.SpecialAttack));
        remainingEVs = this.getRemainingEVs();
        this.SpecialDefence = Math.min(MAX_EVS, this.SpecialDefence + Math.min(remainingEVs, evGain.SpecialDefence));
        remainingEVs = this.getRemainingEVs();
        this.Speed = Math.min(MAX_EVS, this.Speed + Math.min(remainingEVs, evGain.Speed));
    }

    private int getRemainingEVs() {
        return Math.max(0, MAX_TOTAL_EVS - this.HP - this.Attack - this.Defence - this.SpecialAttack - this.SpecialDefence - this.Speed);
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("EVHP", this.HP);
        nbt.func_74768_a("EVAttack", this.Attack);
        nbt.func_74768_a("EVDefence", this.Defence);
        nbt.func_74768_a("EVSpecialAttack", this.SpecialAttack);
        nbt.func_74768_a("EVSpecialDefence", this.SpecialDefence);
        nbt.func_74768_a("EVSpeed", this.Speed);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.HP = nbt.func_74762_e("EVHP");
        this.Attack = nbt.func_74762_e("EVAttack");
        this.Defence = nbt.func_74762_e("EVDefence");
        this.SpecialAttack = nbt.func_74762_e("EVSpecialAttack");
        this.SpecialDefence = nbt.func_74762_e("EVSpecialDefence");
        this.Speed = nbt.func_74762_e("EVSpeed");
    }

    public int get(StatsType stat) {
        switch (stat) {
            case Attack: {
                return this.Attack;
            }
            case Defence: {
                return this.Defence;
            }
            case HP: {
                return this.HP;
            }
            case SpecialAttack: {
                return this.SpecialAttack;
            }
            case SpecialDefence: {
                return this.SpecialDefence;
            }
            case Speed: {
                return this.Speed;
            }
        }
        return -1;
    }

    public EVsStore cloneEVs() {
        EVsStore s = new EVsStore();
        s.HP = this.HP;
        s.Attack = this.Attack;
        s.Defence = this.Defence;
        s.SpecialAttack = this.SpecialAttack;
        s.SpecialDefence = this.SpecialDefence;
        s.Speed = this.Speed;
        return s;
    }

    public void doubleValues() {
        this.Attack *= 2;
        this.Defence *= 2;
        this.HP *= 2;
        this.SpecialAttack *= 2;
        this.SpecialDefence *= 2;
        this.Speed *= 2;
    }

    public void addEVs(int i, StatsType stat) {
        switch (stat) {
            case Attack: {
                this.Attack += i;
                break;
            }
            case Defence: {
                this.Defence += i;
                break;
            }
            case HP: {
                this.HP += i;
                break;
            }
            case SpecialAttack: {
                this.SpecialAttack += i;
                break;
            }
            case SpecialDefence: {
                this.SpecialDefence += i;
                break;
            }
            case Speed: {
                this.Speed += i;
                break;
            }
        }
    }

    public boolean berryEVs(StatsType stat) {
        if (stat == StatsType.Attack) {
            if (this.Attack > 0) {
                this.Attack = Math.max(this.Attack - 10, 0);
                return true;
            }
        } else if (stat == StatsType.Defence) {
            if (this.Defence > 0) {
                this.Defence = Math.max(this.Defence - 10, 0);
                return true;
            }
        } else if (stat == StatsType.HP) {
            if (this.HP > 0) {
                this.HP = Math.max(this.HP - 10, 0);
                return true;
            }
        } else if (stat == StatsType.SpecialAttack) {
            if (this.SpecialAttack > 0) {
                this.SpecialAttack = Math.max(this.SpecialAttack - 10, 0);
                return true;
            }
        } else if (stat == StatsType.SpecialDefence) {
            if (this.SpecialDefence > 0) {
                this.SpecialDefence = Math.max(this.SpecialDefence - 10, 0);
                return true;
            }
        } else if (stat == StatsType.Speed && this.Speed > 0) {
            this.Speed = Math.max(this.Speed - 10, 0);
            return true;
        }
        return false;
    }

    public boolean vitaminEVs(StatsType stat) {
        int remainingEVs = this.getRemainingEVs();
        if (remainingEVs > 0) {
            int evIncrease = Math.min(10, remainingEVs);
            if (stat == StatsType.Attack) {
                if (this.Attack < 100) {
                    this.Attack = Math.min(this.Attack + evIncrease, 100);
                    return true;
                }
            } else if (stat == StatsType.Defence) {
                if (this.Defence < 100) {
                    this.Defence = Math.min(this.Defence + evIncrease, 100);
                    return true;
                }
            } else if (stat == StatsType.HP) {
                if (this.HP < 100) {
                    this.HP = Math.min(this.HP + evIncrease, 100);
                    return true;
                }
            } else if (stat == StatsType.SpecialAttack) {
                if (this.SpecialAttack < 100) {
                    this.SpecialAttack = Math.min(this.SpecialAttack + evIncrease, 100);
                    return true;
                }
            } else if (stat == StatsType.SpecialDefence) {
                if (this.SpecialDefence < 100) {
                    this.SpecialDefence = Math.min(this.SpecialDefence + evIncrease, 100);
                    return true;
                }
            } else if (stat == StatsType.Speed && this.Speed < 100) {
                this.Speed = Math.min(this.Speed + evIncrease, 100);
                return true;
            }
        }
        return false;
    }

    public static void getNBTTags(HashMap<String, Class> tags) {
        tags.put("EVHP", Integer.class);
        tags.put("EVAttack", Integer.class);
        tags.put("EVDefence", Integer.class);
        tags.put("EVSpecialAttack", Integer.class);
        tags.put("EVSpecialDefence", Integer.class);
        tags.put("EVSpeed", Integer.class);
    }

    public void randomizeMaxEVs() {
        int remainingEVs = MAX_TOTAL_EVS;
        int[] evs = new int[6];
        while (remainingEVs > 0) {
            int index = RandomHelper.getRandomNumberBetween(0, evs.length - 1);
            if (evs[index] >= MAX_EVS) continue;
            int n = index;
            evs[n] = evs[n] + 1;
            --remainingEVs;
        }
        this.HP = evs[0];
        this.Attack = evs[1];
        this.Defence = evs[2];
        this.SpecialAttack = evs[3];
        this.SpecialDefence = evs[4];
        this.Speed = evs[5];
    }
}

