/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.stats;

import com.google.gson.JsonObject;
import net.minecraft.block.material.Material;

public class FlyingParameters {
    public int flyHeightMin = 0;
    public int flyHeightMax = 10;
    public float flySpeedModifier = 1.0f;
    public int flyRefreshRateY = 100;
    public int flyRefreshRateXZ = 100;
    public int flyRefreshRateSpeed = 100;
    public int flightTimeMin = 0;
    public int flightTimeMax = 20;
    public int flapRate = 20;
    public Material[] landingMaterial = null;

    public FlyingParameters(int heightMin, int heightMax, float speedMod, int rateY, int rateXZ, int rateSpeed, int flightTimeMin, int flightTimeMax, int flapRate, String landingMaterial) {
        this.flyHeightMin = heightMin;
        this.flyHeightMax = heightMax;
        this.flySpeedModifier = speedMod;
        this.flyRefreshRateY = rateY;
        this.flyRefreshRateXZ = rateXZ;
        this.flyRefreshRateSpeed = rateSpeed;
        this.flightTimeMin = flightTimeMin;
        this.flightTimeMax = flightTimeMax;
        this.flapRate = flapRate / 4;
        this.landingMaterial = landingMaterial.equalsIgnoreCase("grassandleaves") ? new Material[]{Material.field_151584_j, Material.field_151577_b} : (landingMaterial.equalsIgnoreCase("leaves") ? new Material[]{Material.field_151584_j} : null);
    }

    public FlyingParameters(JsonObject jsonObject) {
        if (jsonObject.has("heightmin")) {
            this.flyHeightMin = jsonObject.get("heightmin").getAsInt();
        }
        if (jsonObject.has("heightmax")) {
            this.flyHeightMax = jsonObject.get("heightmax").getAsInt();
        }
        if (jsonObject.has("speed")) {
            this.flySpeedModifier = jsonObject.get("speed").getAsFloat();
        }
        if (jsonObject.has("refreshratey")) {
            this.flyRefreshRateY = jsonObject.get("refreshratey").getAsInt();
        }
        if (jsonObject.has("refreshratexz")) {
            this.flyRefreshRateXZ = jsonObject.get("refreshratexz").getAsInt();
        }
        if (jsonObject.has("refreshratespeed")) {
            this.flyRefreshRateSpeed = jsonObject.get("refreshratespeed").getAsInt();
        }
        if (jsonObject.has("flaprate")) {
            this.flapRate = jsonObject.get("flaprate").getAsInt() / 4;
        }
    }

    public boolean willLandInMaterial(Material m) {
        if (this.landingMaterial == null) {
            return false;
        }
        for (Material mat : this.landingMaterial) {
            if (m != mat) continue;
            return true;
        }
        return false;
    }
}

