/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.stats;

import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.StatsType;
import java.util.Arrays;
import java.util.HashMap;
import net.minecraft.nbt.NBTTagCompound;

public class IVStore {
    public int HP;
    public int Attack;
    public int Defence;
    public int SpAtt;
    public int SpDef;
    public int Speed;
    public static final int MAX_IVS = 31;

    public IVStore() {
    }

    public IVStore(int[] ivs) {
        this.HP = ivs[0];
        this.Attack = ivs[1];
        this.Defence = ivs[2];
        this.SpAtt = ivs[3];
        this.SpDef = ivs[4];
        this.Speed = ivs[5];
    }

    public static IVStore CreateNewIVs() {
        IVStore iv = new IVStore();
        iv.SpDef = RandomHelper.getRandomNumberBetween(0, 31);
        iv.SpAtt = RandomHelper.getRandomNumberBetween(0, 31);
        iv.Speed = RandomHelper.getRandomNumberBetween(0, 31);
        iv.Defence = RandomHelper.getRandomNumberBetween(0, 31);
        iv.Attack = RandomHelper.getRandomNumberBetween(0, 31);
        iv.HP = RandomHelper.getRandomNumberBetween(0, 31);
        return iv;
    }

    public static IVStore CreateNewIVs3Perfect() {
        int[] ivs = new int[6];
        int[] maxIVs = RandomHelper.getRandomDistinctNumbersBetween(0, 5, 3);
        Arrays.sort(maxIVs);
        int maxIVCounter = 0;
        for (int i = 0; i < 6; ++i) {
            if (maxIVs[maxIVCounter] == i) {
                ivs[i] = 31;
                if (maxIVCounter >= maxIVs.length - 1) continue;
                ++maxIVCounter;
                continue;
            }
            ivs[i] = RandomHelper.getRandomNumberBetween(0, 31);
        }
        return new IVStore(ivs);
    }

    public void writeToNBT(NBTTagCompound var1) {
        var1.func_74768_a("IVHP", this.HP);
        var1.func_74768_a("IVAttack", this.Attack);
        var1.func_74768_a("IVDefence", this.Defence);
        var1.func_74768_a("IVSpAtt", this.SpAtt);
        var1.func_74768_a("IVSpDef", this.SpDef);
        var1.func_74768_a("IVSpeed", this.Speed);
    }

    public void readFromNBT(NBTTagCompound var1) {
        this.HP = var1.func_74762_e("IVHP");
        this.Attack = var1.func_74762_e("IVAttack");
        this.Defence = var1.func_74762_e("IVDefence");
        this.SpAtt = var1.func_74762_e("IVSpAtt");
        this.SpDef = var1.func_74762_e("IVSpDef");
        this.Speed = var1.func_74762_e("IVSpeed");
    }

    public void CopyIVs(IVStore ivs) {
        this.HP = ivs.HP;
        this.Attack = ivs.Attack;
        this.Defence = ivs.Defence;
        this.SpAtt = ivs.SpAtt;
        this.SpDef = ivs.SpDef;
        this.Speed = ivs.Speed;
    }

    public int get(StatsType stat) {
        switch (stat) {
            case Attack: {
                return this.Attack;
            }
            case Defence: {
                return this.Defence;
            }
            case HP: {
                return this.HP;
            }
            case SpecialAttack: {
                return this.SpAtt;
            }
            case SpecialDefence: {
                return this.SpDef;
            }
            case Speed: {
                return this.Speed;
            }
        }
        return -1;
    }

    public static void getNBTTags(HashMap<String, Class> tags) {
        tags.put("IVHP", Integer.class);
        tags.put("IVAttack", Integer.class);
        tags.put("IVDefence", Integer.class);
        tags.put("IVSpAtt", Integer.class);
        tags.put("IVSpDef", Integer.class);
        tags.put("IVSpeed", Integer.class);
    }

    public int[] getArray() {
        return new int[]{this.HP, this.Attack, this.Defence, this.SpAtt, this.SpDef, this.Speed};
    }

    public void maximizeIVs() {
        this.Speed = 31;
        this.SpDef = 31;
        this.SpAtt = 31;
        this.Defence = 31;
        this.Attack = 31;
        this.HP = 31;
    }
}

