/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.stats;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.PixelmonMethods;
import com.pixelmonmod.pixelmon.api.events.ExperienceGainEvent;
import com.pixelmonmod.pixelmon.api.events.LevelUpEvent;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.BattleControllerBase;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.PixelmonStatsData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenReplaceMoveScreen;
import com.pixelmonmod.pixelmon.config.PixelmonServerConfig;
import com.pixelmonmod.pixelmon.database.DatabaseMoves;
import com.pixelmonmod.pixelmon.database.ExperienceGroup;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.EvolutionQuery;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.EvolutionQueryList;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Moveset;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Stats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.links.EntityLink;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.links.PokemonLink;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.links.WrapperLink;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class Level {
    private PokemonLink pixelmon;
    public int expToNextLevel = 0;
    int oldLevel = -1;

    public Level(EntityPixelmon p) {
        this(new EntityLink(p));
        EntityDataManager dataManager = p.func_184212_Q();
        dataManager.func_187214_a(EntityPixelmon.dwLevel, (Object)-1);
        dataManager.func_187214_a(EntityPixelmon.dwExp, (Object)0);
        this.setScale();
    }

    public Level(PixelmonWrapper p) {
        this(new WrapperLink(p));
    }

    public Level(PokemonLink p) {
        this.pixelmon = p;
    }

    protected void updateStats() {
        this.pixelmon.updateStats();
    }

    public void writeToNBT(NBTTagCompound var1) {
        var1.func_74768_a("Level", this.getLevel());
        var1.func_74768_a("EXP", this.getExp());
        var1.func_74768_a("EXPToNextLevel", this.canLevelUp() ? this.getExpForLevel(this.getLevel() + 1) - this.getExpForLevel(this.getLevel()) : 0);
    }

    public void readFromNBT(NBTTagCompound var1) {
        this.setExp(var1.func_74762_e("EXP"));
        this.setLevel(var1.func_74762_e("Level"));
    }

    public int getLevel() {
        return this.pixelmon.getLevel();
    }

    public void setLevel(int i) {
        this.pixelmon.setLevel(i);
        this.setScale();
        this.updateExpToNextLevel();
        Stats stats = this.pixelmon.getStats();
        if (this.pixelmon.getHealth() == stats.HP) {
            this.updateStats();
            this.pixelmon.setHealthDirect(stats.HP);
        } else {
            float oldHP = stats.HP;
            float oldHealth = this.pixelmon.getHealth();
            this.updateStats();
            float newHealth = stats.HP;
            if (oldHP != 0.0f) {
                newHealth = oldHealth / oldHP * (float)stats.HP;
            }
            this.pixelmon.setHealthDirect((int)Math.ceil(newHealth));
        }
    }

    public void updateExpToNextLevel() {
        this.expToNextLevel = this.getLevel() == 1 ? this.getExpForLevel(this.getLevel() + 1) : (this.canLevelUp() ? this.getExpForLevel(this.getLevel() + 1) - this.getExpForLevel(this.getLevel()) : 0);
    }

    private int getExpForLevel(int l) {
        ExperienceGroup ex = this.pixelmon.getBaseStats().experienceGroup;
        if (ex == ExperienceGroup.Erratic) {
            if (l <= 50) {
                return (100 - l) * (l * l * l) / 50;
            }
            if (l <= 68) {
                return (150 - l) * (l * l * l) / 100;
            }
            if (l <= 98) {
                return (191 - l) * (l * l * l) / 150;
            }
            if (l <= 100) {
                return (160 - l) * (l * l * l) / 100;
            }
            return 60 * (l * l * l) / 100;
        }
        if (ex == ExperienceGroup.Fast) {
            return (int)(0.8 * (double)l * (double)l * (double)l);
        }
        if (ex == ExperienceGroup.MediumFast) {
            return l * l * l;
        }
        if (ex == ExperienceGroup.MediumSlow) {
            return l == 2 ? 9 : (int)(1.2 * (double)l * (double)l * (double)l - (double)(15 * l * l) + (double)(100 * l) - 140.0);
        }
        if (ex == ExperienceGroup.Slow) {
            return (int)(1.25 * (double)l * (double)l * (double)l);
        }
        if (ex == ExperienceGroup.Fluctuating) {
            if (l <= 15) {
                return (l + 73) * (l * l * l) / 150;
            }
            if (l <= 36) {
                return (l + 14) * (l * l * l) / 50;
            }
            return (l + 64) * (l * l * l) / 100;
        }
        return -1;
    }

    public int getExp() {
        return this.pixelmon.getExp();
    }

    public void setExp(int i) {
        this.pixelmon.setExp(i);
    }

    public boolean canLevelUp() {
        return this.getLevel() < PixelmonServerConfig.maxLevel;
    }

    protected void onLevelUp(PixelmonStatsData stats) {
        this.updateStats();
        this.pixelmon.updateLevelUp(stats);
        this.pixelmon.getFriendship().onLevelUp();
        this.setScale();
    }

    public void awardEXP(int i) {
        if (!this.pixelmon.doesLevel()) {
            return;
        }
        ExperienceGainEvent expGainEvent = new ExperienceGainEvent(this.pixelmon, i);
        Pixelmon.EVENT_BUS.post((Event)expGainEvent);
        i = expGainEvent.getExperience();
        this.setExp(this.getExp() + i);
        EntityPlayerMP owner = this.pixelmon.getPlayerOwner();
        BattleControllerBase bc = this.pixelmon.getBattleController();
        if (owner != null && this.canLevelUp() && i > 0) {
            TextComponentTranslation message = ChatHandler.getMessage("pixelmon.stats.gainexp", this.pixelmon.getRealNickname(), i);
            if (bc == null) {
                ChatHandler.sendChat((ICommandSender)owner, message);
            } else {
                bc.sendToPlayer((EntityPlayer)owner, message);
            }
        }
        if (!this.canLevelUp() || this.expToNextLevel == -1) {
            this.setExp(0);
            return;
        }
        if (owner == null) {
            return;
        }
        boolean isReplacingMove = false;
        boolean didLevel = false;
        while (this.getExp() >= this.expToNextLevel) {
            int xp = this.getExp();
            this.pixelmon.update(EnumUpdateType.Name);
            int newExp = this.getExp() - this.expToNextLevel;
            if (!this.canLevelUp() || Pixelmon.EVENT_BUS.post((Event)new LevelUpEvent(owner, this.pixelmon, this.getLevel() + 1))) break;
            didLevel = true;
            PixelmonStatsData stats = PixelmonStatsData.createPacket(this.pixelmon);
            this.setLevel(this.getLevel() + 1);
            this.onLevelUp(stats);
            this.setExp(newExp);
            int newLevel = this.getLevel();
            ArrayList<Attack> newAttacks = DatabaseMoves.getAttacksAtLevel(this.pixelmon.getEntity(), newLevel);
            for (Attack a : newAttacks) {
                Moveset moveset = this.pixelmon.getMoveset();
                if (moveset.hasAttack(a)) continue;
                if (moveset.size() >= 4) {
                    isReplacingMove = true;
                    Pixelmon.network.sendTo((IMessage)new OpenReplaceMoveScreen(this.pixelmon.getPokemonID(), a.baseAttack.attackIndex, 0, newLevel, true), owner);
                    continue;
                }
                moveset.add(a);
                this.pixelmon.update(EnumUpdateType.Moveset);
                TextComponentTranslation message = ChatHandler.getMessage("pixelmon.stats.learnedmove", this.pixelmon.getRealNickname(), a.baseAttack.getLocalizedName());
                if (bc != null) {
                    ChatHandler.sendBattleMessage((Entity)owner, message);
                    continue;
                }
                ChatHandler.sendChat((ICommandSender)owner, message);
            }
            if (bc == null || bc.rules.levelCap >= PixelmonServerConfig.maxLevel || bc.rules.levelCap < newLevel) continue;
            this.setExp(0);
            break;
        }
        this.pixelmon.update(EnumUpdateType.Stats);
        if (didLevel && !isReplacingMove) {
            this.tryEvolution();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkForExistingEvolutionQuery() {
        List<EvolutionQuery> list = EvolutionQueryList.queryList;
        synchronized (list) {
            for (int i = 0; i < EvolutionQueryList.queryList.size(); ++i) {
                if (!PixelmonMethods.isIDSame(EvolutionQueryList.queryList.get((int)i).pokemonID, this.pixelmon)) continue;
                return true;
            }
        }
        return false;
    }

    public void tryEvolution() {
        boolean hasEvolved = this.checkForExistingEvolutionQuery();
        if (this.pixelmon.getHeldItem().getHeldItemType() != EnumHeldItems.everStone && !hasEvolved) {
            BattleControllerBase bc = this.pixelmon.getBattleController();
            if (bc != null && !bc.battleEnded) {
                bc.addCheckEvolve(this.pixelmon);
            } else {
                this.pixelmon.getEntity().testLevelEvolution(this.pixelmon.getLevel());
            }
        }
    }

    private void setScale() {
        float percent = 1.0f;
        percent = 0.8f + 0.4f * (float)this.getLevel() / (float)PixelmonServerConfig.maxLevel;
        this.pixelmon.setScale(percent);
    }

    public void recalculateXP() {
        this.setExp(0);
        this.expToNextLevel = this.getExpForLevel(this.getLevel() + 1) - this.getExpForLevel(this.getLevel());
    }

    public int getExpForNextLevelClient() {
        if (this.oldLevel != this.getLevel()) {
            this.expToNextLevel = this.getExpForLevel(this.getLevel() + 1) - this.getExpForLevel(this.getLevel());
            this.oldLevel = this.getLevel();
        }
        return this.expToNextLevel;
    }

    public float getExpFraction() {
        return Level.getExpFraction(this.getExp(), this.expToNextLevel);
    }

    public static float getExpFraction(int exp, int expToNextLevel) {
        if (expToNextLevel == 0) {
            return 0.0f;
        }
        return (float)exp / (float)expToNextLevel;
    }

    public void getNBTTags(HashMap<String, Class> tags) {
        tags.put("Level", Integer.class);
        tags.put("EXP", Integer.class);
        tags.put("EXPToNextLevel", Integer.class);
    }
}

