/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.stats;

import com.pixelmonmod.pixelmon.comm.PixelmonData;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity3HasStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.BaseStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.EVsStore;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.IVStore;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.StatsType;
import com.pixelmonmod.pixelmon.enums.EnumNature;
import java.util.HashMap;
import java.util.NoSuchElementException;
import net.minecraft.nbt.NBTTagCompound;

public class Stats {
    public int HP;
    public int Attack;
    public int Defence;
    public int SpecialAttack;
    public int SpecialDefence;
    public int Speed;
    public IVStore IVs = new IVStore();
    public EVsStore EVs = new EVsStore();

    public Stats setLevelStats(EnumNature nature, BaseStats baseStats, int level) {
        this.HP = this.calculateHP(baseStats, level);
        this.Attack = this.calculateStat(StatsType.Attack, nature, baseStats, level);
        this.Defence = this.calculateStat(StatsType.Defence, nature, baseStats, level);
        this.SpecialAttack = this.calculateStat(StatsType.SpecialAttack, nature, baseStats, level);
        this.SpecialDefence = this.calculateStat(StatsType.SpecialDefence, nature, baseStats, level);
        this.Speed = this.calculateStat(StatsType.Speed, nature, baseStats, level);
        return this;
    }

    public int calculateHP(BaseStats baseStats, int level) {
        if (baseStats.hp == 1) {
            return 1;
        }
        return (int)(((float)this.IVs.HP + 2.0f * (float)baseStats.hp + (float)this.EVs.HP / 4.0f + 100.0f) * (float)level / 100.0f + 10.0f);
    }

    public int calculateStat(StatsType stat, EnumNature nature, BaseStats baseStats, int level) {
        float val = ((float)this.IVs.get(stat) + 2.0f * (float)baseStats.get(stat) + (float)this.EVs.get(stat) / 4.0f) * (float)level;
        val /= 100.0f;
        val += 5.0f;
        val = (float)Math.floor(val);
        if (stat == nature.increasedStat) {
            val *= 1.1f;
        } else if (stat == nature.decreasedStat) {
            val *= 0.9f;
        }
        return (int)val;
    }

    public void writeToNBT(NBTTagCompound var1) {
        var1.func_74768_a("StatsHP", this.HP);
        var1.func_74768_a("StatsAttack", this.Attack);
        var1.func_74768_a("StatsDefence", this.Defence);
        var1.func_74768_a("StatsSpecialAttack", this.SpecialAttack);
        var1.func_74768_a("StatsSpecialDefence", this.SpecialDefence);
        var1.func_74768_a("StatsSpeed", this.Speed);
        this.IVs.writeToNBT(var1);
        this.EVs.writeToNBT(var1);
    }

    public void readFromNBT(NBTTagCompound var1) {
        this.HP = var1.func_74762_e("StatsHP");
        this.Attack = var1.func_74762_e("StatsAttack");
        this.Defence = var1.func_74762_e("StatsDefence");
        this.SpecialAttack = var1.func_74762_e("StatsSpecialAttack");
        this.SpecialDefence = var1.func_74762_e("StatsSpecialDefence");
        this.Speed = var1.func_74762_e("StatsSpeed");
        this.IVs.readFromNBT(var1);
        this.EVs.readFromNBT(var1);
    }

    public void getNBTTags(HashMap<String, Class> tags) {
        tags.put("StatsHP", Integer.class);
        tags.put("StatsAttack", Integer.class);
        tags.put("StatsDefence", Integer.class);
        tags.put("StatsSpecialAttack", Integer.class);
        tags.put("StatsSpecialDefence", Integer.class);
        tags.put("StatsSpeed", Integer.class);
        IVStore.getNBTTags(tags);
        EVsStore.getNBTTags(tags);
    }

    public static void calculateStatsForData(PixelmonData data) {
        BaseStats baseStats;
        Stats stats = new Stats();
        stats.EVs = new EVsStore(data.evs);
        stats.IVs = new IVStore(data.ivs);
        try {
            baseStats = Entity3HasStats.getBaseStats(data.name, (int)data.form).get();
        }
        catch (NoSuchElementException e) {
            return;
        }
        stats.setLevelStats(data.nature, baseStats, data.lvl);
        data.health = stats.HP;
        data.hp = stats.HP;
        data.HP = stats.HP;
        data.Attack = stats.Attack;
        data.Defence = stats.Defence;
        data.SpecialAttack = stats.SpecialAttack;
        data.SpecialDefence = stats.SpecialDefence;
        data.Speed = stats.Speed;
    }

    public int get(StatsType stat) {
        switch (stat) {
            case HP: {
                return this.HP;
            }
            case Attack: {
                return this.Attack;
            }
            case Defence: {
                return this.Defence;
            }
            case SpecialAttack: {
                return this.SpecialAttack;
            }
            case SpecialDefence: {
                return this.SpecialDefence;
            }
            case Speed: {
                return this.Speed;
            }
        }
        return -1;
    }
}

