/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.stats.links;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.battles.controller.BattleControllerBase;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusPersist;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.PixelmonStatsData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.LevelUp;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity1Base;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.AbilityBase;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.BaseStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.FriendShip;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Gender;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Level;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Moveset;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Stats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.links.PokemonLink;
import com.pixelmonmod.pixelmon.enums.EnumBossMode;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import com.pixelmonmod.pixelmon.enums.EnumNature;
import com.pixelmonmod.pixelmon.enums.EnumType;
import com.pixelmonmod.pixelmon.enums.items.EnumPokeballs;
import com.pixelmonmod.pixelmon.items.ItemHeld;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EntityLink
extends PokemonLink {
    private EntityPixelmon pixelmon;

    public EntityLink(EntityPixelmon pixelmon) {
        this.pixelmon = pixelmon;
    }

    public EntityLink(Entity1Base pixelmon) {
        try {
            this.pixelmon = (EntityPixelmon)pixelmon;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Cannot initialize link to a non-Pixelmon entity!");
        }
    }

    @Override
    public BaseStats getBaseStats() {
        return this.pixelmon.baseStats;
    }

    @Override
    public Stats getStats() {
        return this.pixelmon.stats;
    }

    @Override
    public ItemHeld getHeldItem() {
        return this.pixelmon.getItemHeld();
    }

    @Override
    public void setHeldItem(ItemStack item) {
        this.pixelmon.setHeldItem(item);
    }

    @Override
    public int getHealth() {
        return (int)this.pixelmon.func_110143_aJ();
    }

    @Override
    public int getMaxHealth() {
        return (int)this.pixelmon.func_110138_aP();
    }

    @Override
    public void setHealth(int health) {
        this.pixelmon.func_70606_j(health);
    }

    @Override
    public int getLevel() {
        return (Integer)this.pixelmon.func_184212_Q().func_187225_a(EntityPixelmon.dwLevel);
    }

    @Override
    public void setLevel(int level) {
        this.pixelmon.func_184212_Q().func_187227_b(EntityPixelmon.dwLevel, (Object)level);
    }

    @Override
    public int getExp() {
        return (Integer)this.pixelmon.func_184212_Q().func_187225_a(EntityPixelmon.dwExp);
    }

    @Override
    public void setExp(int experience) {
        this.pixelmon.func_184212_Q().func_187227_b(EntityPixelmon.dwExp, (Object)experience);
    }

    @Override
    public FriendShip getFriendship() {
        return this.pixelmon.friendship;
    }

    @Override
    public boolean doesLevel() {
        return this.pixelmon.doesLevel;
    }

    @Override
    public EntityPlayerMP getPlayerOwner() {
        EntityLivingBase owner = this.pixelmon.func_70902_q();
        if (owner instanceof EntityPlayerMP) {
            return (EntityPlayerMP)owner;
        }
        return null;
    }

    @Override
    public String getRealNickname() {
        return this.pixelmon.getNickname();
    }

    @Override
    public BattleControllerBase getBattleController() {
        return this.pixelmon.battleController;
    }

    @Override
    public Moveset getMoveset() {
        Moveset moveset = this.pixelmon.getMoveset();
        if (moveset.isEmpty()) {
            this.pixelmon.loadMoveset();
            moveset = this.pixelmon.getMoveset();
        }
        return moveset;
    }

    @Override
    public int[] getPokemonID() {
        return this.pixelmon.getPokemonId();
    }

    @Override
    public EntityPixelmon getEntity() {
        return this.pixelmon;
    }

    @Override
    public void setScale(float scale) {
        if (scale > this.pixelmon.maxScale) {
            scale = this.pixelmon.maxScale;
        }
        this.pixelmon.setPixelmonScale(scale);
    }

    @Override
    public World getWorld() {
        return this.pixelmon.field_70170_p;
    }

    @Override
    public Gender getGender() {
        return this.pixelmon.getGender();
    }

    @Override
    public BlockPos getPos() {
        return this.pixelmon.func_180425_c();
    }

    @Override
    public Optional<PlayerStorage> getStorage() {
        return this.pixelmon.getStorage();
    }

    @Override
    public void update(EnumUpdateType ... updateTypes) {
        if (this.pixelmon.func_70902_q() != null) {
            this.pixelmon.update(updateTypes);
        }
    }

    @Override
    public void updateStats() {
        this.pixelmon.updateStats();
    }

    @Override
    public void updateLevelUp(PixelmonStatsData stats) {
        EntityLivingBase owner = this.pixelmon.func_70902_q();
        if (owner != null && owner instanceof EntityPlayerMP) {
            PixelmonStatsData stats2 = PixelmonStatsData.createPacket(this);
            Pixelmon.network.sendTo((IMessage)new LevelUp(this.pixelmon, this.getLevel(), stats, stats2), (EntityPlayerMP)owner);
            this.pixelmon.update(EnumUpdateType.Stats);
        }
    }

    @Override
    public void sendMessage(String langKey, Object ... data) {
        EntityLivingBase owner = this.pixelmon.func_70902_q();
        if (owner instanceof EntityPlayer) {
            ChatHandler.sendChat((Entity)((EntityPlayer)owner), langKey, data);
        }
    }

    @Override
    public String getOriginalTrainer() {
        return this.pixelmon.originalTrainer;
    }

    @Override
    public String getRealTextureNoCheck(PixelmonWrapper pw) {
        return this.pixelmon.getRealTextureNoCheck();
    }

    @Override
    public String getNickname() {
        return this.pixelmon.getNickname();
    }

    @Override
    public boolean removeStatuses(StatusType ... statuses) {
        return this.pixelmon.removeStatuses(statuses);
    }

    @Override
    public EnumNature getNature() {
        return this.pixelmon.getNature();
    }

    @Override
    public int getExpToNextLevel() {
        return this.pixelmon.getLvl().expToNextLevel;
    }

    @Override
    public StatusPersist getPrimaryStatus() {
        return this.pixelmon.status;
    }

    @Override
    public AbilityBase getAbility() {
        return this.pixelmon.getAbility();
    }

    @Override
    public List<EnumType> getType() {
        return this.pixelmon.type;
    }

    @Override
    public int getForm() {
        return this.pixelmon.getForm();
    }

    @Override
    public boolean isShiny() {
        return this.pixelmon.getIsShiny();
    }

    @Override
    public boolean isEgg() {
        return this.pixelmon.isEgg;
    }

    @Override
    public int getEggCycles() {
        return this.pixelmon.eggCycles;
    }

    @Override
    public EnumGrowth getGrowth() {
        return this.pixelmon.getGrowth();
    }

    @Override
    public EnumPokeballs getCaughtBall() {
        return this.pixelmon.caughtBall;
    }

    @Override
    public int getPartyPosition() {
        return this.pixelmon.getPartyPosition();
    }

    @Override
    public ItemStack getHeldItemStack() {
        return this.pixelmon.func_184614_ca();
    }

    @Override
    public boolean hasOwner() {
        return this.pixelmon.hasOwner() || this.pixelmon.hasNPCTrainer;
    }

    @Override
    public EnumBossMode getBossMode() {
        return this.pixelmon.getBossMode();
    }

    @Override
    public int getSpecialTexture() {
        return this.pixelmon.getSpecialTextureIndex();
    }

    @Override
    public boolean isInRanch() {
        return this.pixelmon.isInRanchBlock;
    }

    @Override
    public int[] getEggMoves() {
        return this.pixelmon.eggMoves;
    }

    @Override
    public Level getLevelContainer() {
        return this.pixelmon.getLvl();
    }

    @Override
    public NBTTagCompound getNBT() {
        return this.pixelmon.getEntityData();
    }
}

