/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.stats.links;

import com.pixelmonmod.pixelmon.PixelmonMethods;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.controller.BattleControllerBase;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.NoStatus;
import com.pixelmonmod.pixelmon.battles.status.StatusPersist;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.PixelmonStatsData;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity1Base;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity3HasStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity4Textures;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.EnumSpecialTexture;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.AbilityBase;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.ComingSoon;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.BaseStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.FriendShip;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Gender;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Level;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Moveset;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Stats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.links.PokemonLink;
import com.pixelmonmod.pixelmon.enums.EnumBossMode;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import com.pixelmonmod.pixelmon.enums.EnumNature;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.pixelmonmod.pixelmon.enums.EnumType;
import com.pixelmonmod.pixelmon.enums.items.EnumPokeballs;
import com.pixelmonmod.pixelmon.items.ItemHeld;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class NBTLink
extends PokemonLink {
    private NBTTagCompound nbt;
    private PlayerStorage storage = null;

    public NBTLink(NBTTagCompound nbt) {
        this.nbt = nbt;
    }

    public NBTLink(NBTTagCompound nbt, PlayerStorage storage) {
        this(nbt);
        this.storage = storage;
    }

    @Override
    public BaseStats getBaseStats() {
        return Entity3HasStats.getBaseStats(this.nbt.func_74779_i("Name"), this.nbt.func_74762_e("Variant")).get();
    }

    @Override
    public Stats getStats() {
        Stats stats = new Stats();
        stats.readFromNBT(this.nbt);
        return stats;
    }

    @Override
    public ItemHeld getHeldItem() {
        ItemStack stack = ItemHeld.readHeldItemFromNBT(this.nbt);
        return ItemHeld.getItemHeld(stack);
    }

    @Override
    public void setHeldItem(ItemStack item) {
        ItemHeld.writeHeldItemToNBT(this.nbt, item);
    }

    @Override
    public int getHealth() {
        return (int)this.nbt.func_74760_g("Health");
    }

    @Override
    public int getMaxHealth() {
        return this.getStats().HP;
    }

    @Override
    public void setHealth(int health) {
        this.nbt.func_74776_a("Health", (float)health);
        this.nbt.func_74757_a("IsFainted", health <= 0);
    }

    @Override
    public int getLevel() {
        return this.nbt.func_74762_e("Level");
    }

    @Override
    public void setLevel(int level) {
        this.nbt.func_74768_a("Level", level);
    }

    @Override
    public int getExp() {
        return this.nbt.func_74762_e("EXP");
    }

    @Override
    public void setExp(int experience) {
        this.nbt.func_74768_a("EXP", experience);
    }

    @Override
    public FriendShip getFriendship() {
        FriendShip friendship = new FriendShip(this);
        friendship.readFromNBT(this.nbt);
        return friendship;
    }

    @Override
    public boolean doesLevel() {
        return this.nbt.func_74767_n("DoesLevel");
    }

    @Override
    public String getRealNickname() {
        String nickname = this.nbt.func_74779_i("Nickname");
        if (nickname != null && !nickname.isEmpty()) {
            return nickname;
        }
        return super.getRealNickname();
    }

    @Override
    public EntityPlayerMP getPlayerOwner() {
        if (this.storage == null) {
            return null;
        }
        return this.storage.getPlayer();
    }

    @Override
    public BattleControllerBase getBattleController() {
        EntityPlayerMP player = this.storage.getPlayer();
        if (player != null) {
            return BattleRegistry.getBattle((EntityPlayer)player);
        }
        return null;
    }

    @Override
    public Moveset getMoveset() {
        Moveset moveset = new Moveset(this);
        moveset.readFromNBT(this.nbt);
        return moveset;
    }

    @Override
    public int[] getPokemonID() {
        return PixelmonMethods.getID(this.nbt);
    }

    @Override
    public EntityPixelmon getEntity() {
        EntityPlayerMP owner = this.getPlayerOwner();
        if (owner == null) {
            return null;
        }
        return this.storage.getPokemon(this.getPokemonID(), owner.field_70170_p);
    }

    @Override
    public void setScale(float scale) {
    }

    @Override
    public World getWorld() {
        return null;
    }

    @Override
    public Gender getGender() {
        return Gender.getGender(this.nbt.func_74765_d("Gender"));
    }

    @Override
    public BlockPos getPos() {
        return new BlockPos(0, 0, 0);
    }

    @Override
    public Optional<PlayerStorage> getStorage() {
        return Optional.empty();
    }

    @Override
    public void update(EnumUpdateType ... updateTypes) {
        if (this.storage != null) {
            this.storage.updateClient(this.nbt, updateTypes);
        }
    }

    @Override
    public void updateStats() {
        if (this.storage != null) {
            this.storage.updateClient(this.nbt, EnumUpdateType.HP, EnumUpdateType.Stats);
        }
    }

    @Override
    public void updateLevelUp(PixelmonStatsData stats) {
        this.updateStats();
    }

    @Override
    public void sendMessage(String langKey, Object ... data) {
        EntityPlayerMP player;
        if (this.storage != null && (player = this.storage.getPlayer()) != null) {
            ChatHandler.sendChat((Entity)player, langKey, data);
        }
    }

    @Override
    public String getNickname() {
        String nickname = this.nbt.func_74779_i("Nickname");
        if (!PixelmonConfig.allowNicknames || nickname.isEmpty()) {
            return Entity1Base.getLocalizedName(this.nbt.func_74779_i("Name"));
        }
        return nickname;
    }

    @Override
    public String getOriginalTrainer() {
        return this.nbt.func_74779_i("originalTrainer");
    }

    @Override
    public String getRealTextureNoCheck(PixelmonWrapper pw) {
        EnumPokemon pokemon = pw.getSpecies();
        EnumSpecialTexture enumm = EnumSpecialTexture.fromIndex(this.nbt.func_74765_d("specialTexture"));
        String special = enumm == EnumSpecialTexture.None ? this.nbt.func_74779_i("CustomTexture") : enumm.toString();
        return Entity4Textures.getTextureFor(pokemon, pokemon.getFormEnum(pw.getForm()), this.getGender(), special, this.nbt.func_74767_n("IsShiny")).toString();
    }

    @Override
    public boolean removeStatuses(StatusType ... statuses) {
        StatusPersist status = StatusPersist.readStatusFromNBT(this.nbt);
        if (status == NoStatus.noStatus) {
            return false;
        }
        for (StatusType type : statuses) {
            if (status.type != type) continue;
            this.nbt.func_82580_o("Status");
            return true;
        }
        return false;
    }

    @Override
    public EnumNature getNature() {
        return EnumNature.getNatureFromIndex(this.nbt.func_74765_d("Nature"));
    }

    @Override
    public int getExpToNextLevel() {
        return this.nbt.func_74762_e("EXPToNextLevel");
    }

    @Override
    public StatusPersist getPrimaryStatus() {
        return StatusPersist.readStatusFromNBT(this.nbt);
    }

    @Override
    public AbilityBase getAbility() {
        String abilityName = this.nbt.func_74779_i("Ability");
        return AbilityBase.getAbility(abilityName).orElse(ComingSoon.noAbility);
    }

    @Override
    public List<EnumType> getType() {
        EnumType type1;
        ArrayList<EnumType> type = new ArrayList<EnumType>();
        if (this.nbt.func_74764_b("primaryType") && (type1 = EnumType.parseOrNull(this.nbt.func_74765_d("primaryType"))) != null) {
            type.add(type1);
            if (this.nbt.func_74764_b("secondaryType")) {
                EnumType type2;
                short secondType = this.nbt.func_74765_d("secondaryType");
                EnumType enumType = type2 = secondType == -1 ? null : EnumType.parseOrNull(secondType);
                if (type2 != null) {
                    type.add(type2);
                }
            }
            return type;
        }
        BaseStats baseStats = this.getBaseStats();
        type.add(baseStats.type1);
        if (baseStats.type2 != null) {
            type.add(baseStats.type2);
        }
        return type;
    }

    @Override
    public int getForm() {
        return this.nbt.func_74762_e("Variant");
    }

    @Override
    public boolean isShiny() {
        return this.nbt.func_74767_n("IsShiny");
    }

    @Override
    public boolean isEgg() {
        return this.nbt.func_74767_n("isEgg");
    }

    @Override
    public int getEggCycles() {
        return this.nbt.func_74762_e("eggCycles");
    }

    @Override
    public EnumGrowth getGrowth() {
        return EnumGrowth.getGrowthFromIndex(this.nbt.func_74765_d("Growth"));
    }

    @Override
    public EnumPokeballs getCaughtBall() {
        return EnumPokeballs.getFromIndex(this.nbt.func_74762_e("CaughtBall"));
    }

    @Override
    public int getPartyPosition() {
        return this.nbt.func_74762_e("PixelmonOrder");
    }

    @Override
    public ItemStack getHeldItemStack() {
        return ItemHeld.readHeldItemFromNBT(this.nbt);
    }

    @Override
    public boolean hasOwner() {
        return true;
    }

    @Override
    public EnumBossMode getBossMode() {
        return EnumBossMode.getMode(this.nbt.func_74765_d("BossMode"));
    }

    @Override
    public int getSpecialTexture() {
        return this.nbt.func_74765_d("specialTexture");
    }

    @Override
    public boolean isInRanch() {
        return this.nbt.func_74767_n("isInRanch");
    }

    @Override
    public int[] getEggMoves() {
        return this.nbt.func_74759_k("EggMoves");
    }

    @Override
    public Level getLevelContainer() {
        return new Level(this);
    }

    @Override
    public NBTTagCompound getNBT() {
        return this.nbt;
    }
}

