/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pokeballs;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.achievement.PixelmonAchievements;
import com.pixelmonmod.pixelmon.achievement.PixelmonAdvancements;
import com.pixelmonmod.pixelmon.api.enums.ReceiveType;
import com.pixelmonmod.pixelmon.api.events.CaptureEvent;
import com.pixelmonmod.pixelmon.api.events.PixelmonReceivedEvent;
import com.pixelmonmod.pixelmon.api.events.PokeballImpactEvent;
import com.pixelmonmod.pixelmon.battles.controller.BattleControllerBase;
import com.pixelmonmod.pixelmon.battles.controller.Experience;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.config.PixelmonItemsPokeballs;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pokeballs.EntityPokeBall;
import com.pixelmonmod.pixelmon.entities.pokeballs.EnumPokeBallMode;
import com.pixelmonmod.pixelmon.entities.pokeballs.PokeballTypeHelper;
import com.pixelmonmod.pixelmon.enums.EnumBossMode;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.pixelmonmod.pixelmon.enums.battle.EnumBattleEndCause;
import com.pixelmonmod.pixelmon.enums.forms.EnumValentine;
import com.pixelmonmod.pixelmon.enums.forms.IEnumForm;
import com.pixelmonmod.pixelmon.enums.items.EnumPokeballs;
import com.pixelmonmod.pixelmon.items.ItemHeld;
import com.pixelmonmod.pixelmon.items.heldItems.NoItem;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import java.util.Calendar;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.Event;

public class EntityEmptyPokeball
extends EntityPokeBall {
    private int breakChance;
    private int waitTime;
    private BattleControllerBase battleController;
    private boolean isBattleThrown;
    private int totalTime;
    private boolean captureFinished;
    private double pokemonPosX;
    private double pokemonPosY;
    private double pokemonPosZ;
    boolean capturedPokemon;

    public EntityEmptyPokeball(World world) {
        super(world);
        this.breakChance = this.field_70146_Z.nextInt(30);
        this.isBattleThrown = false;
        this.capturedPokemon = false;
    }

    public EntityEmptyPokeball(World world, EntityLivingBase entityliving, EnumPokeballs type, boolean dropItem) {
        super(type, world, entityliving, EnumPokeBallMode.empty);
        this.breakChance = this.field_70146_Z.nextInt(30);
        this.isBattleThrown = false;
        this.capturedPokemon = false;
        this.field_70192_c = entityliving;
        this.dropItem = dropItem;
        this.func_184538_a((Entity)entityliving, entityliving.field_70125_A, entityliving.field_70177_z, 0.0f, 1.0f, 0.5f);
    }

    public EntityEmptyPokeball(World world, EntityLivingBase thrower, EntityPixelmon target, EnumPokeballs type, BattleControllerBase battleController) {
        super(type, world, thrower, EnumPokeBallMode.battle);
        this.breakChance = this.field_70146_Z.nextInt(30);
        this.isBattleThrown = false;
        this.capturedPokemon = false;
        this.field_70192_c = thrower;
        this.dropItem = false;
        this.endRotationYaw = thrower.field_70759_as;
        this.pixelmon = target;
        this.isBattleThrown = true;
        this.battleController = battleController;
        this.field_70170_p = thrower.field_70170_p;
        battleController.pauseBattle();
        this.func_70012_b(thrower.field_70165_t, thrower.field_70163_u + (double)thrower.func_70047_e(), thrower.field_70161_v, thrower.field_70177_z, thrower.field_70125_A);
        this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.field_70163_u -= (double)0.1f;
        this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70159_w = (double)(-MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI))) * 0.8;
        this.field_70179_y = (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI))) * 0.8;
        this.field_70181_x = (double)(-MathHelper.func_76126_a((float)0.0f)) * 0.8;
    }

    @Override
    protected void func_70184_a(RayTraceResult movingobjectposition) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (Pixelmon.EVENT_BUS.post((Event)new PokeballImpactEvent(this, movingobjectposition)) && !this.isBattleThrown) {
            return;
        }
        if (this.dropItem && this.breakChance == 1 && this.getType() != EnumPokeballs.MasterBall) {
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187635_cQ, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            this.func_70099_a(new ItemStack(Blocks.field_150430_aB), 0.0f);
            this.func_70099_a(new ItemStack(PixelmonItemsPokeballs.ironBase), 0.0f);
            this.func_70099_a(new ItemStack(this.breakBall()), 0.0f);
            this.func_70106_y();
            return;
        }
        if (this.isBattleThrown && !this.field_70170_p.field_72995_K) {
            if (!this.getIsWaiting()) {
                this.startBattleCapture();
            } else {
                this.startShake();
            }
        } else {
            if (movingobjectposition.field_72313_a == RayTraceResult.Type.BLOCK) {
                IBlockState state = this.field_70170_p.func_180495_p(movingobjectposition.func_178782_a());
                Block hitBlock = state.func_177230_c();
                Material mat = state.func_185904_a();
                if (hitBlock == Blocks.field_150329_H || mat == Material.field_151585_k) {
                    return;
                }
                if (!this.getIsWaiting() && mat != null && mat.func_76220_a()) {
                    if (this.dropItem) {
                        this.func_70099_a(new ItemStack((Item)this.getType().getItem()), 0.0f);
                    }
                    this.func_70106_y();
                    return;
                }
            }
            if (movingobjectposition.field_72308_g != null && movingobjectposition.field_72308_g instanceof EntityPixelmon) {
                this.pixelmon = (EntityPixelmon)movingobjectposition.field_72308_g;
                this.pokemonPosX = this.pixelmon.field_70165_t;
                this.pokemonPosY = this.pixelmon.field_70163_u;
                this.pokemonPosZ = this.pixelmon.field_70161_v;
                if (this.pixelmon.battleController != null) {
                    boolean inBattle = false;
                    if (this.pixelmon.battleController.checkValid()) {
                        ChatHandler.sendChat((Entity)this.field_70192_c, "pixelmon.pokeballs.inbattle", new Object[0]);
                        inBattle = true;
                    } else if (this.pixelmon.hasNPCTrainer) {
                        this.pixelmon.func_70106_y();
                        inBattle = true;
                    }
                    if (inBattle) {
                        ChatHandler.sendChat((Entity)this.field_70192_c, "pixelmon.pokeballs.pokeinbattle", new Object[0]);
                        if (this.dropItem) {
                            this.func_70099_a(new ItemStack((Item)this.getType().getItem()), 0.0f);
                        }
                        this.func_70106_y();
                        return;
                    }
                }
                if (this.pixelmon.getBossMode() != EnumBossMode.NotBoss) {
                    ChatHandler.sendChat((Entity)this.field_70192_c, "pixelmon.pokeballs.boss", new Object[0]);
                    this.func_70106_y();
                    return;
                }
                if (this.pixelmon.hasOwner() || this.pixelmon.getTrainer() != null) {
                    if (this.pixelmon.func_70902_q() == this.field_70192_c) {
                        ChatHandler.sendChat((Entity)this.field_70192_c, "pixelmon.pokeballs.alreadyown", new Object[0]);
                    } else {
                        ChatHandler.sendChat((Entity)this.field_70192_c, "pixelmon.pokeballs.otherspokemon", new Object[0]);
                    }
                    if (this.dropItem) {
                        this.func_70099_a(new ItemStack((Item)this.getType().getItem()), 0.0f);
                    }
                    this.func_70106_y();
                    return;
                }
                if (this.pixelmon.hitByPokeball != null) {
                    return;
                }
                this.pixelmon.hitByPokeball = this;
                if (!this.getIsWaiting()) {
                    this.startCapture();
                }
            } else if (this.getIsWaiting()) {
                this.startShake();
            } else {
                if (this.dropItem) {
                    this.func_70099_a(new ItemStack((Item)this.getType().getItem()), 0.0f);
                }
                this.func_70106_y();
                return;
            }
        }
        super.func_70184_a(movingobjectposition);
    }

    private void startCapture() {
        this.doCaptureCalc(this.pixelmon);
        this.pixelmon.field_70179_y = 0.0;
        this.pixelmon.field_70181_x = 0.0;
        this.pixelmon.field_70159_w = 0.0;
        this.initialScale = this.pixelmon.getPixelmonScale();
        this.setAnimation("bounceOpen");
        this.setIsWaiting(true);
        this.setId(this.canCatch ? this.numShakes : -1 * this.numShakes);
        this.field_70181_x = 0.0;
        this.field_70159_w = 0.0;
        this.field_70179_y = 0.0;
        this.field_70125_A = 0.0f;
        int i = -2;
        while (!this.field_70170_p.func_175623_d(new BlockPos((int)this.field_70165_t, (int)Math.ceil(this.field_70163_u) + i, (int)this.field_70161_v))) {
            ++i;
        }
        this.field_70163_u = Math.ceil(this.field_70163_u) + (double)i + (double)0.1f;
    }

    private void startBattleCapture() {
        this.pokemonPosX = this.pixelmon.field_70165_t;
        this.pokemonPosY = this.pixelmon.field_70163_u;
        this.pokemonPosZ = this.pixelmon.field_70161_v;
        this.pixelmon.hitByPokeball = this;
        this.startCapture();
        this.field_70165_t = (int)this.field_70165_t;
        this.field_70161_v = (int)this.field_70161_v;
    }

    private void forceBattleCapture() {
        this.startBattleCapture();
        this.pixelmon.unloadEntity();
        this.setIsOnGround(true);
    }

    private void startShake() {
        this.field_70181_x = 0.0;
        this.field_70159_w = 0.0;
        this.field_70179_y = 0.0;
        this.setIsOnGround(true);
    }

    @Override
    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K) {
            super.func_70071_h_();
            return;
        }
        ++this.totalTime;
        if (this.getIsOnGround()) {
            ++this.waitTime;
        }
        if (this.capturedPokemon) {
            if (this.waitTime > 20) {
                this.storeCapture();
                this.func_70106_y();
            }
        } else {
            ((Object)((Object)this)).getClass();
            if (this.waitTime > this.numShakes * 25) {
                this.catchPokemon();
                this.waitTime = 0;
            } else if (this.totalTime > 100 && this.isBattleThrown && !this.getIsWaiting() && !this.captureFinished) {
                this.forceBattleCapture();
            }
        }
        super.func_70071_h_();
    }

    private void storeCapture() {
        Optional<PlayerStorage> optstorage = PixelmonStorage.pokeBallManager.getPlayerStorage((EntityPlayerMP)this.field_70192_c);
        if (optstorage.isPresent()) {
            this.pixelmon.func_70903_f(true);
            this.pixelmon.func_184754_b(this.field_70192_c.func_110124_au());
            this.pixelmon.caughtBall = this.getType();
            this.pixelmon.clearAttackTarget();
            this.pixelmon.friendship.initFromCapture();
            PokeballTypeHelper.doAfterEffect(this.getType(), this.pixelmon);
            Pixelmon.EVENT_BUS.post((Event)new PixelmonReceivedEvent((EntityPlayerMP)this.field_70192_c, ReceiveType.PokeBall, this.pixelmon));
            optstorage.get().addToParty(this.pixelmon);
            this.pixelmon.catchInPokeball();
            if (this.getMode() == EnumPokeBallMode.battle) {
                PlayerParticipant p = (PlayerParticipant)this.battleController.getParticipantForEntity(this.field_70192_c);
                Experience.awardExp(this.battleController.participants, p, this.pixelmon.getPixelmonWrapper());
                this.battleController.endBattle(EnumBattleEndCause.FORCE);
            }
        }
        this.setIsWaiting(false);
    }

    protected void catchPokemon() {
        this.captureFinished = true;
        if (this.canCatch) {
            CaptureEvent.SuccessfulCapture capEvent;
            if (this.getType() == EnumPokeballs.LoveBall) {
                Calendar currentCalendar = Calendar.getInstance();
                int month = currentCalendar.get(2);
                int day = currentCalendar.get(5);
                if (month == 1 && day >= 14 && day <= 20 && this.pixelmon.hasForms()) {
                    for (IEnumForm form : EnumPokemon.formList.get((Object)this.pixelmon.getSpecies())) {
                        if (form != EnumValentine.LOVED) continue;
                        this.pixelmon.setForm(form.getForm(), true);
                        break;
                    }
                }
            }
            if (Pixelmon.EVENT_BUS.post((Event)(capEvent = new CaptureEvent.SuccessfulCapture((EntityPlayerMP)this.field_70192_c, this.pixelmon, this)))) {
                this.failCapture();
                return;
            }
            this.pixelmon = capEvent.getPokemon();
            this.pixelmon.originalTrainer = this.field_70192_c.func_70005_c_();
            TextComponentTranslation message = ChatHandler.getMessage("pixelmon.pokeballs.capture", this.pixelmon.getLocalizedName());
            if (this.pixelmon.battleController == null) {
                ChatHandler.sendChat((Entity)this.field_70192_c, "pixelmon.pokeballs.capture", this.pixelmon.getLocalizedName());
            } else {
                PixelmonWrapper pw = this.pixelmon.getPixelmonWrapper();
                if (pw != null) {
                    pw.resetOnSwitch();
                    ItemHeld currentHeldItem = pw.getHeldItem();
                    if (currentHeldItem != NoItem.noItem && currentHeldItem != pw.getInitialHeldItem()) {
                        pw.enableReturnHeldItem();
                    }
                }
                this.pixelmon.battleController.sendToAll(message);
                Experience.awardExp(this.pixelmon.battleController.participants, this.pixelmon.getParticipant(), pw);
            }
            this.capturedPokemon = true;
            this.waitTime = 0;
            PixelmonAdvancements.throwCaptureTriggers((EntityPlayerMP)this.field_70192_c, this.getType(), this.pixelmon);
            PixelmonAchievements.captureChieves((EntityPlayerMP)this.field_70192_c, this.pixelmon);
        } else {
            this.failCapture();
        }
    }

    private void failCapture() {
        Pixelmon.EVENT_BUS.post((Event)new CaptureEvent.FailedCapture((EntityPlayerMP)this.field_70192_c, this.pixelmon, this));
        this.openAngle = -1.5707964f;
        this.waitTime = 0;
        this.setIsWaiting(false);
        this.pixelmon.func_70107_b(this.pokemonPosX, this.pokemonPosY, this.pokemonPosZ);
        this.pixelmon.hitByPokeball = null;
        if (this.field_70170_p.func_73045_a(this.pixelmon.func_145782_y()) != null) {
            this.pixelmon.unloadEntity();
        }
        this.pixelmon.field_70128_L = false;
        try {
            this.field_70170_p.func_72838_d((Entity)this.pixelmon);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.pixelmon.func_70107_b(this.pokemonPosX, this.pokemonPosY, this.pokemonPosZ);
        this.pixelmon.setPixelmonScale(this.initialScale);
        this.pixelmon.field_70128_L = false;
        TextComponentTranslation message = ChatHandler.getMessage("pixelmon.pokeballs.brokefree", this.pixelmon.getLocalizedName());
        if (this.getMode() == EnumPokeBallMode.battle && !this.battleController.battleEnded) {
            this.pixelmon.battleController = this.battleController;
            if (this.pixelmon.transformed) {
                this.pixelmon.updateTransformed();
            }
            this.battleController.sendToAll(message);
            this.battleController.endPause();
        } else {
            ChatHandler.sendChat((ICommandSender)this.field_70192_c, message);
        }
        this.func_70106_y();
    }

    public void func_70106_y() {
        if (this.isBattleThrown && !this.captureFinished) {
            if (!this.getIsWaiting()) {
                this.forceBattleCapture();
            }
            this.catchPokemon();
            return;
        }
        if (this.capturedPokemon && this.getIsWaiting()) {
            this.storeCapture();
        }
        if (this.pixelmon != null && this.pixelmon.hitByPokeball == this) {
            this.pixelmon.hitByPokeball = null;
        }
        super.func_70106_y();
    }
}

