/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pokeballs;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.PokeballImpactEvent;
import com.pixelmonmod.pixelmon.battles.BattleQuery;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.controller.BattleControllerBase;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.TrainerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.WildPixelmonParticipant;
import com.pixelmonmod.pixelmon.battles.rules.teamselection.TeamSelectionList;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pokeballs.EntityPokeBall;
import com.pixelmonmod.pixelmon.entities.pokeballs.EnumPokeBallMode;
import com.pixelmonmod.pixelmon.enums.battle.EnumBattleType;
import com.pixelmonmod.pixelmon.enums.items.EnumPokeballs;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import java.util.Optional;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.Event;

public class EntityOccupiedPokeball
extends EntityPokeBall {
    private static final int MAX_LIFETIME = 400;
    String pokeName = null;

    public EntityOccupiedPokeball(World world) {
        super(world);
        this.field_70180_af.func_187227_b(dwMode, (Object)EnumPokeBallMode.full.ordinal());
    }

    public EntityOccupiedPokeball(World world, EntityLivingBase entityliving, int[] pokemonId, EnumPokeballs type) {
        super(type, world, entityliving, EnumPokeBallMode.full);
        this.field_70192_c = entityliving;
        this.setOwnerId(this.field_70192_c.func_110124_au());
        this.endRotationYaw = entityliving.field_70759_as;
        this.setPokeId(pokemonId);
        this.func_70012_b(entityliving.field_70165_t, entityliving.field_70163_u + (double)entityliving.func_70047_e(), entityliving.field_70161_v, entityliving.field_70177_z, entityliving.field_70125_A);
        this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.field_70163_u -= (double)0.1f;
        this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70159_w = (double)(-MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI))) * 0.8;
        this.field_70179_y = (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI))) * 0.8;
        this.field_70181_x = (double)(-MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI))) * 0.8;
        this.setInitialYaw(this.field_70192_c.field_70177_z);
        this.setInitialPitch(this.field_70192_c.field_70125_A);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && (this.field_70173_aa > 400 || this.field_70163_u < 0.0)) {
            this.func_70106_y();
        }
    }

    @Override
    public String func_70005_c_() {
        Optional<PlayerStorage> optstorage;
        if (this.pokeName == null && this.field_70192_c instanceof EntityPlayerMP && (optstorage = PixelmonStorage.pokeBallManager.getPlayerStorage((EntityPlayerMP)this.field_70192_c)).isPresent()) {
            PlayerStorage store = optstorage.get();
            String tmp = store.getNBT(this.getPokeId()).func_74779_i("Name");
            this.pokeName = I18n.func_74838_a((String)("pixelmon." + tmp.toLowerCase() + ".name"));
        }
        return this.pokeName + " " + super.func_70005_c_();
    }

    @Override
    protected void func_70184_a(RayTraceResult traceResult) {
        if (!this.field_70170_p.field_72995_K) {
            AxisAlignedBB bounds;
            BlockPos pos;
            IBlockState state;
            if (traceResult.field_72313_a == RayTraceResult.Type.BLOCK && !(state = this.field_70170_p.func_180495_p(pos = traceResult.func_178782_a())).isSideSolid((IBlockAccess)this.field_70170_p, pos, traceResult.field_178784_b) && (bounds = state.func_185890_d((IBlockAccess)this.field_70170_p, pos)) == null) {
                return;
            }
            if (Pixelmon.EVENT_BUS.post((Event)new PokeballImpactEvent(this, traceResult))) {
                return;
            }
            if (traceResult.field_72313_a != RayTraceResult.Type.BLOCK) {
                PlayerStorage storage;
                EntityPixelmon pokemonHit = null;
                if (traceResult.field_72308_g != null && traceResult.field_72308_g instanceof EntityPixelmon) {
                    pokemonHit = (EntityPixelmon)traceResult.field_72308_g;
                }
                if (pokemonHit != null && pokemonHit.func_70902_q() == this.field_70192_c && pokemonHit.func_184207_aI()) {
                    return;
                }
                if (traceResult.field_72308_g == this.field_70192_c) {
                    return;
                }
                EntityPixelmon pokemon = null;
                Optional<PlayerStorage> optstorage = PixelmonStorage.pokeBallManager.getPlayerStorage((EntityPlayerMP)this.field_70192_c);
                if (optstorage.isPresent() && (pokemon = (storage = optstorage.get()).sendOut(this.getPokeId(), this.field_70192_c.field_70170_p)) != null) {
                    pokemon.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
                    if (pokemonHit != null && !storage.isIn(pokemonHit)) {
                        EntityPixelmon target = pokemonHit;
                        if (target.battleController != null) {
                            if (target.battleController.checkValid()) {
                                ChatHandler.sendChat((Entity)this.field_70192_c, "pixelmon.pokeballs.inbattle", new Object[0]);
                                this.func_70106_y();
                                return;
                            }
                            if (target.hasNPCTrainer) {
                                target.func_70106_y();
                                this.func_70106_y();
                                return;
                            }
                        }
                        if (target.hitByPokeball != null) {
                            this.func_70106_y();
                            return;
                        }
                        if (target.hasOwner()) {
                            Optional<PlayerStorage> opttargetstorage = target.getStorage();
                            if (optstorage.isPresent()) {
                                PlayerStorage targetStorage = opttargetstorage.get();
                                if (target.func_70902_q() == null) {
                                    this.func_70106_y();
                                    return;
                                }
                                if (!targetStorage.battleEnabled) {
                                    this.func_70106_y();
                                    return;
                                }
                                if (target.blockOwner != null) {
                                    this.func_70106_y();
                                    return;
                                }
                                if (targetStorage.guiOpened) {
                                    ChatHandler.sendChat((Entity)this.field_70192_c, "pixelmon.general.playerbusy", new Object[0]);
                                    this.func_70106_y();
                                    return;
                                }
                                new BattleQuery((EntityPlayerMP)this.field_70192_c, pokemon, (EntityPlayerMP)target.func_70902_q(), target);
                            }
                        } else {
                            if (target.isInRanchBlock) {
                                this.func_70106_y();
                                return;
                            }
                            if (BattleRegistry.getBattle((EntityPlayer)this.field_70192_c) != null) {
                                this.func_70106_y();
                                return;
                            }
                            WildPixelmonParticipant part = new WildPixelmonParticipant(target);
                            pokemon.StartBattle(new PlayerParticipant((EntityPlayerMP)this.field_70192_c, pokemon), part);
                            this.func_70106_y();
                        }
                    } else {
                        if (traceResult.field_72308_g != null && traceResult.field_72308_g instanceof NPCTrainer) {
                            EntityPlayerMP throwerPlayer;
                            NPCTrainer trainerEntity = (NPCTrainer)traceResult.field_72308_g;
                            BattleControllerBase bc = trainerEntity.getBattleController();
                            if (bc != null) {
                                if (bc.battleEnded) {
                                    bc.endBattleWithoutXP();
                                } else {
                                    this.func_70106_y();
                                    return;
                                }
                            }
                            if (!trainerEntity.canStartBattle((EntityPlayer)(throwerPlayer = (EntityPlayerMP)this.field_70192_c), true)) {
                                return;
                            }
                            EnumBattleType battleType = EnumBattleType.Single;
                            if (traceResult.field_72308_g instanceof NPCTrainer) {
                                battleType = trainerEntity.getBattleType();
                            }
                            if (trainerEntity.battleRules.isDefault()) {
                                TrainerParticipant trainer = new TrainerParticipant(trainerEntity, (EntityPlayer)this.field_70192_c, battleType.numPokemon);
                                PlayerParticipant playerPart = battleType == EnumBattleType.Single ? new PlayerParticipant(throwerPlayer, pokemon) : new PlayerParticipant(throwerPlayer, storage.getAmountAblePokemon(throwerPlayer.field_70170_p, battleType.numPokemon));
                                pokemon.StartBattle((BattleParticipant)playerPart, (BattleParticipant)trainer, trainerEntity.battleRules);
                            } else {
                                TeamSelectionList.addTeamSelection(trainerEntity.battleRules, true, trainerEntity.getPokemonStorage(), PixelmonStorage.pokeBallManager.getPlayerStorage(throwerPlayer).get());
                            }
                            this.func_70106_y();
                            return;
                        }
                        if (PixelmonConfig.pokeBallPlayerEngage && traceResult.field_72308_g != null && traceResult.field_72308_g instanceof EntityPlayerMP) {
                            if (traceResult.field_72308_g != this.field_70192_c) {
                                EntityPlayerMP thrower = (EntityPlayerMP)this.func_85052_h();
                                EntityPlayerMP enemy = (EntityPlayerMP)traceResult.field_72308_g;
                                EntityPixelmon player1FirstPokemon = storage.getFirstAblePokemon(thrower.field_70170_p);
                                Optional<PlayerStorage> optEnemyStorage = PixelmonStorage.pokeBallManager.getPlayerStorage(enemy);
                                if (optEnemyStorage.isPresent()) {
                                    PlayerStorage enemyStorage = optEnemyStorage.get();
                                    EntityPixelmon player2FirstPokemon = enemyStorage.getFirstAblePokemon(enemy.field_70170_p);
                                    if (enemyStorage.guiOpened) {
                                        ChatHandler.sendChat((Entity)thrower, "pixelmon.general.playerbusy", new Object[0]);
                                        return;
                                    }
                                    if (player2FirstPokemon == null) {
                                        ChatHandler.sendChat((Entity)thrower, "pixelmon.command.battle.nopokemon", enemy.getDisplayNameString());
                                    } else {
                                        new BattleQuery(thrower, player1FirstPokemon, enemy, player2FirstPokemon);
                                    }
                                }
                            }
                        } else {
                            pokemon.clearAttackTarget();
                        }
                    }
                }
            }
            if (this.getIsWaiting()) {
                this.field_70181_x = 0.0;
                this.field_70159_w = 0.0;
                this.field_70179_y = 0.0;
                this.func_70106_y();
                this.setIsOnGround(true);
            } else {
                this.setAnimation("bounceOpen");
                this.setIsWaiting(true);
                this.field_70181_x = 0.0;
                this.field_70159_w = 0.0;
                this.field_70179_y = 0.0;
                this.field_70125_A = 0.0f;
            }
        }
    }
}

