/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.enums;

import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.init.Biomes;
import net.minecraft.world.biome.Biome;

public enum EnumBiomes {
    Beach("Beach", Biomes.field_76787_r),
    Desert("Desert", Biomes.field_76769_d),
    DesertHills("DesertHills", Biomes.field_76786_s),
    Forest("Forest", Biomes.field_76767_f),
    ForestHills("ForestHills", Biomes.field_76785_t),
    IcePlains("IcePlains", Biomes.field_76774_n),
    IceMountain("IceMountains", Biomes.field_76775_o),
    Jungle("Jungle", Biomes.field_76782_w),
    JungleHills("JungleHills", Biomes.field_76792_x),
    Mountain("ExtremeHills", Biomes.field_76770_e),
    MountainEdge("ExtremeHillsEdge", Biomes.field_76783_v),
    Mushroom("MushroomIsland", Biomes.field_76789_p),
    MushroomShore("MushroomIslandShore", Biomes.field_76788_q),
    Plains("Plains", Biomes.field_76772_c),
    Swamp("SwampLand", Biomes.field_76780_h),
    Taiga("Taiga", Biomes.field_76768_g),
    TaigaHills("TaigaHills", Biomes.field_76784_u),
    FrozenOcean("FrozenOcean", Biomes.field_76776_l),
    FrozenRiver("FrozenRiver", Biomes.field_76777_m),
    Ocean("Ocean", Biomes.field_76771_b),
    River("River", Biomes.field_76781_i),
    Nether("Hell", Biomes.field_76778_j),
    Sky("Sky", Biomes.field_76779_k);

    private Biome biome;
    private String name;

    private EnumBiomes(String s, Biome b) {
        this.name = s;
        this.biome = b;
    }

    public Biome getBiome() {
        return this.biome;
    }

    public String getName() {
        return this.name;
    }

    public static EnumBiomes parseBiome(String name) {
        for (EnumBiomes b : EnumBiomes.values()) {
            if (!b.name.equalsIgnoreCase(name)) continue;
            return b;
        }
        return null;
    }

    public static ArrayList<EnumBiomes> getAllBiomes() {
        ArrayList<EnumBiomes> list = new ArrayList<EnumBiomes>();
        EnumBiomes[] t = EnumBiomes.values();
        Collections.addAll(list, t);
        return list;
    }

    public static boolean hasBiome(String name) {
        try {
            return EnumBiomes.valueOf(name) != null;
        }
        catch (Exception e) {
            return false;
        }
    }
}

