/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.enums;

import com.pixelmonmod.pixelmon.client.models.obj.ObjLoader;
import com.pixelmonmod.pixelmon.client.models.smd.ValveStudioModel;
import com.pixelmonmod.pixelmon.client.models.smd.ValveStudioModelLoader;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;

public enum EnumCustomModel {
    PillarPlatform("blocks/pillar/pillar_platform.obj"),
    PillarColumn("blocks/pillar/pillar_column.obj"),
    PillarColumnFracturedBottom("blocks/pillar/pillar_column_fractured_bottom.obj"),
    PillarColumnFracturedTop("blocks/pillar/pillar_column_fractured_top.obj"),
    Pokeball("pokeballs/base.pqc"),
    Cherishball("pokeballs/cherishball.pqc"),
    Greatball("pokeballs/greatball.pqc"),
    Heavyball("pokeballs/heavyball.pqc"),
    Masterball("pokeballs/masterball.pqc"),
    Netball("pokeballs/netball.pqc"),
    Timerball("pokeballs/timerball.pqc"),
    Beastball("pokeballs/beastball.pqc"),
    Sash("playeritems/sash/sash.pqc"),
    Fez("playeritems/hats/fez.pqc"),
    Fedora("playeritems/hats/fedora.pqc"),
    TopHat("playeritems/hats/tophat.pqc"),
    Monocle("playeritems/hats/monocle.pqc"),
    TrainerHat("playeritems/hats/trainerhat.pqc"),
    PikaHood("playeritems/hats/pikahood.pqc"),
    MegaBraceletORAS("playeritems/megaitems/megabraceletoras.pqc"),
    MegaBraceletORASStone("playeritems/megaitems/megabraceletorasstone.pqc"),
    CharizardBackpack("playeritems/backpacks/charizard.pqc"),
    Cap("cosmetics/head/cap.pqc");

    String fileName;
    public IModel theModel;
    private boolean initialised = false;

    private EnumCustomModel(String fileName) {
        this.fileName = fileName;
    }

    public IModel getModel() {
        if (!this.initialised) {
            try {
                ResourceLocation rl = new ResourceLocation("pixelmon:models/" + this.fileName);
                if (ValveStudioModelLoader.instance.accepts(rl)) {
                    this.theModel = ValveStudioModelLoader.instance.loadModel(rl);
                } else if (ObjLoader.accepts(rl)) {
                    this.theModel = ObjLoader.loadModel(rl);
                }
            }
            catch (Exception var2) {
                System.out.println("Could not load the model: " + this.fileName);
                var2.printStackTrace();
            }
            this.initialised = true;
        }
        return this.theModel instanceof ValveStudioModel ? new ValveStudioModel((ValveStudioModel)this.theModel) : this.theModel;
    }

    public static EnumCustomModel getFromString(String customModel) {
        for (EnumCustomModel enumCustomModel : EnumCustomModel.values()) {
            if (!enumCustomModel.name().equalsIgnoreCase(customModel)) continue;
            return enumCustomModel;
        }
        return null;
    }
}

