/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.enums;

import com.pixelmonmod.pixelmon.RandomHelper;
import net.minecraft.init.Biomes;
import net.minecraft.world.biome.Biome;

public enum EnumScatteredStructure {
    mansion(0, 55, 4, Biomes.field_76780_h, "mansion"),
    gymRed(1, 10, 2, Biomes.field_76772_c, "gymRed"),
    moltresSpawn(2, 35, 1, Biomes.field_76767_f, "moltresSpawn", "Pikachu", 57, 38, 54),
    zapdosSpawn(3, 30, 0, Biomes.field_76770_e, "zapdosSpawn", "Pikachu", 5, 2, 5);

    public int structureId;
    public int rarity;
    public Biome biome;
    public String schematicName;
    public boolean spawnPokemon = false;
    public String pokemonSpawn;
    public int pokemonX;
    public int pokemonZ;
    public int pokemonY;
    public int depthInGround;

    private EnumScatteredStructure(int structureId, int rarity, int depthInGround, Biome biome, String schematicName) {
        this.structureId = structureId;
        this.rarity = rarity;
        this.depthInGround = depthInGround;
        this.biome = biome;
        this.schematicName = schematicName;
    }

    private EnumScatteredStructure(int structureId, int rarity, int depthInGround, Biome biome, String schematicName, String pokemonSpawn, int pokemonX, int pokemonY, int pokemonZ) {
        this.structureId = structureId;
        this.rarity = rarity;
        this.depthInGround = depthInGround;
        this.biome = biome;
        this.schematicName = schematicName;
        this.spawnPokemon = true;
        this.pokemonSpawn = pokemonSpawn;
        this.pokemonX = pokemonX;
        this.pokemonY = pokemonY;
        this.pokemonZ = pokemonZ;
    }

    public int getRarity() {
        return RandomHelper.rand.nextInt(this.rarity * 10);
    }

    public int getY(int par1) {
        return par1 - this.depthInGround;
    }

    public Biome biomeToSpawnIn() {
        return this.biome;
    }

    public String getSchematicPath() {
        return "resources/pixelmon/structures/standAlone/" + this.schematicName + ".schematic";
    }

    public static EnumScatteredStructure getStructureFromBiome(Biome biome) {
        for (EnumScatteredStructure e : EnumScatteredStructure.values()) {
            if (e.biomeToSpawnIn() != biome) continue;
            return e;
        }
        return null;
    }

    public static boolean hasScatteredStructure(String name) {
        try {
            return EnumScatteredStructure.valueOf(name) != null;
        }
        catch (Exception e) {
            return false;
        }
    }
}

