/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items.heldItems;

import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.Confusion;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.Gluttony;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.StatsType;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.links.EntityLink;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.links.WrapperLink;
import com.pixelmonmod.pixelmon.enums.EnumBerry;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumBerryRestoreHP;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import com.pixelmonmod.pixelmon.items.HealFixed;
import com.pixelmonmod.pixelmon.items.HealFraction;
import com.pixelmonmod.pixelmon.items.IHealHP;
import com.pixelmonmod.pixelmon.items.MedicinePotion;
import com.pixelmonmod.pixelmon.items.heldItems.ItemBerry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class ItemBerryRestoreHP
extends ItemBerry {
    public EnumBerryRestoreHP berryType;
    public StatsType confusedStat;
    private MedicinePotion healMethod;

    public ItemBerryRestoreHP(EnumBerryRestoreHP berryType, EnumBerry berry, String itemName, StatsType confusedStat) {
        super(EnumHeldItems.berryRestoreHP, berry, itemName);
        this.berryType = berryType;
        this.confusedStat = confusedStat;
        this.healMethod = new MedicinePotion(this.getHealAmount());
    }

    @Override
    public boolean interact(EntityPixelmon pokemon, ItemStack itemstack, EntityPlayer player) {
        return this.healMethod.useMedicine(new EntityLink(pokemon));
    }

    @Override
    public void tookDamage(PixelmonWrapper attacker, PixelmonWrapper pokemon, float damage, DamageTypeEnum damageType) {
        int lowHealth;
        int n = lowHealth = this.confusedStat == null ? 50 : 25;
        if (lowHealth == 25 && pokemon.getBattleAbility() instanceof Gluttony) {
            lowHealth = 50;
        }
        if (pokemon.isAlive() && pokemon.getHealthPercent() <= (float)lowHealth) {
            this.eatBerry(pokemon);
        }
    }

    @Override
    public void applySwitchInEffect(PixelmonWrapper newPokemon) {
        int lowHealth;
        int n = lowHealth = this.confusedStat == null ? 50 : 25;
        if (lowHealth == 25 && newPokemon.getBattleAbility() instanceof Gluttony) {
            lowHealth = 50;
        }
        if (newPokemon.getHealthPercent() <= (float)lowHealth) {
            this.eatBerry(newPokemon);
        }
    }

    @Override
    public void applyRepeatedEffect(PixelmonWrapper pw) {
        this.applySwitchInEffect(pw);
    }

    @Override
    public void eatBerry(PixelmonWrapper pokemon) {
        if (ItemBerryRestoreHP.canEatBerry(pokemon) && this.healPokemon(pokemon)) {
            super.eatBerry(pokemon);
            pokemon.consumeItem();
        }
    }

    @Override
    public boolean useFromBag(PixelmonWrapper userWrapper, PixelmonWrapper targetWrapper) {
        if (!this.healPokemon(userWrapper)) {
            userWrapper.bc.sendToAll("pixelmon.general.noeffect", new Object[0]);
        }
        return super.useFromBag(userWrapper, targetWrapper);
    }

    public boolean healPokemon(PixelmonWrapper pokemon) {
        if (this.healMethod.useMedicine(new WrapperLink(pokemon))) {
            String nickname = pokemon.getNickname();
            pokemon.bc.sendToAll("pixelmon.helditems.consumerestorehp", nickname, this.getLocalizedName());
            if (pokemon.getNature().decreasedStat == this.confusedStat && pokemon.addStatus(new Confusion(), pokemon)) {
                pokemon.bc.sendToAll("pixelmon.effect.becameconfused", nickname);
            }
            return true;
        }
        return false;
    }

    public IHealHP getHealAmount() {
        switch (this.berryType) {
            case oranBerry: {
                return new HealFixed(10);
            }
            case sitrusBerry: {
                return new HealFraction(0.25f);
            }
        }
        return new HealFraction(0.5f);
    }
}

