/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items.heldItems;

import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.StatsType;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import com.pixelmonmod.pixelmon.items.ItemHeld;

public class StatEnhancingItems
extends ItemHeld {
    private StatsType[] raisedStats;
    private float statMultiplier;
    private EnumPokemon[] affected;

    public StatEnhancingItems(EnumHeldItems type, String itemName, StatsType[] raisedStats, float statMultiplier, EnumPokemon ... affected) {
        super(type, itemName);
        this.raisedStats = raisedStats;
        this.statMultiplier = statMultiplier;
        this.affected = affected;
    }

    @Override
    public int[] modifyStats(PixelmonWrapper user, int[] stats) {
        if (this.canAffect(user)) {
            for (StatsType stat : this.raisedStats) {
                int n = stat.getStatIndex();
                stats[n] = (int)((float)stats[n] * this.statMultiplier);
            }
        }
        return stats;
    }

    protected boolean canAffect(PixelmonWrapper pokemon) {
        EnumPokemon species = pokemon.getSpecies();
        for (EnumPokemon p : this.affected) {
            if (p != species) continue;
            return true;
        }
        return false;
    }
}

