/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.listener;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.battles.BattleQuery;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.controller.BattleControllerBase;
import com.pixelmonmod.pixelmon.battles.rules.teamselection.TeamSelectionList;
import com.pixelmonmod.pixelmon.comm.packetHandlers.ServerConfigList;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.rules.UpdateClientRules;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.customStarters.SelectPokemonController;
import com.pixelmonmod.pixelmon.entities.pixelmon.drops.DropItemQueryList;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.EvolutionQuery;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.EvolutionQueryList;
import com.pixelmonmod.pixelmon.enums.EnumMegaItem;
import com.pixelmonmod.pixelmon.enums.battle.EnumBattleEndCause;
import com.pixelmonmod.pixelmon.listener.EntityPlayerExtension;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerExtraData;
import com.pixelmonmod.pixelmon.storage.PlayerExtras;
import com.pixelmonmod.pixelmon.storage.PlayerNotLoadedException;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import com.pixelmonmod.pixelmon.util.MoveCostList;
import com.pixelmonmod.pixelmon.util.PixelmonMsg;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PixelmonPlayerTracker {
    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayerMP player = (EntityPlayerMP)event.player;
        PixelmonPlayerTracker.removePlayer(player);
        Pixelmon.network.sendTo((IMessage)new ServerConfigList(), player);
        try {
            PixelmonStorage.pokeBallManager.refreshPlayerStorage(player);
            PixelmonStorage.computerManager.refreshComputerStorage(player);
        }
        catch (PlayerNotLoadedException var5) {
            var5.printStackTrace();
        }
        PlayerExtraData extras = PlayerExtras.getExtras(player);
        if (PixelmonConfig.alwaysHaveMegaRing) {
            try {
                PlayerStorage storage = PixelmonStorage.pokeBallManager.getPlayerStorage(player).get();
                if (storage.megaData.getMegaItem() == EnumMegaItem.Disabled || storage.megaData.getMegaItem() == EnumMegaItem.None) {
                    storage.megaData.setMegaItem(EnumMegaItem.BraceletORAS, false);
                    EntityPlayerExtension.updatePlayerMegaItem(player, EnumMegaItem.BraceletORAS);
                }
            }
            catch (Exception var6) {
                var6.printStackTrace();
            }
        }
        PixelmonMsg.handleJoin((EntityPlayer)player, extras.isDeveloper);
        Pixelmon.network.sendTo((IMessage)new UpdateClientRules(), player);
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        EntityPlayer player = event.player;
        if (player instanceof EntityPlayerMP) {
            PixelmonPlayerTracker.removePlayer((EntityPlayerMP)player);
        }
    }

    public static void removePlayer(EntityPlayerMP player) {
        try {
            EvolutionQuery eq;
            SelectPokemonController.removePlayer(player);
            BattleQuery bq = BattleQuery.getQuery(player);
            if (bq != null) {
                bq.declineQuery(player);
            }
            if ((eq = EvolutionQueryList.get((EntityPlayer)player)) != null) {
                EvolutionQueryList.declineQuery(player, eq.pokemonID);
            }
            DropItemQueryList.removeQuery(player);
            BattleControllerBase bc = BattleRegistry.getBattle((EntityPlayer)player);
            if (bc != null) {
                if (bc.hasSpectator((EntityPlayer)player)) {
                    bc.removeSpectator(player);
                } else {
                    bc.endBattle(EnumBattleEndCause.FORCE);
                }
            }
            MoveCostList.removeEntry(player);
            TeamSelectionList.removeSelection(player);
        }
        catch (Exception var4) {
            var4.printStackTrace();
        }
    }
}

