/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.spawning;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.api.spawning.SpawnInfo;
import com.pixelmonmod.pixelmon.api.spawning.SpawnSet;
import com.pixelmonmod.pixelmon.api.spawning.SpawnerCoordinator;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.spawners.TriggerSpawner;
import com.pixelmonmod.pixelmon.api.spawning.conditions.LocationType;
import com.pixelmonmod.pixelmon.api.spawning.util.SetLoader;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.entities.pixelmon.externalMoves.RockSmash;
import com.pixelmonmod.pixelmon.spawning.PixelmonSpawner;
import com.pixelmonmod.pixelmon.spawning.TrackingSpawnerCoordinator;
import java.io.File;
import java.util.ArrayList;

public class PixelmonSpawning {
    public static SpawnerCoordinator coordinator = null;
    public static ArrayList<SpawnSet> standard = new ArrayList();
    public static TriggerSpawner fishingSpawner = null;

    public static void startTrackingSpawner() {
        if (!PixelmonSpawner.spawners.contains(PixelmonSpawner.spawnerNPC)) {
            PixelmonSpawner.spawners.add(PixelmonSpawner.spawnerNPC);
        }
        if (!PixelmonSpawner.spawners.contains(PixelmonSpawner.spawnerBoss)) {
            PixelmonSpawner.spawners.add(PixelmonSpawner.spawnerBoss);
        }
        if (coordinator != null && coordinator.getActive()) {
            coordinator.deactivate();
        }
        if (coordinator == null || !coordinator.getActive()) {
            coordinator = new TrackingSpawnerCoordinator().activate();
        }
    }

    public static void registerSpawnSets() {
        Pixelmon.LOGGER.info("Registering spawn sets.");
        if (PixelmonConfig.useExternalJSONFilesSpawning) {
            if ("default".equals(PixelmonConfig.spawnSetFolder)) {
                File spawnSetDir = new File("pixelmon/spawning/default");
                if (!spawnSetDir.isDirectory()) {
                    Pixelmon.LOGGER.info("Creating spawning directory");
                    spawnSetDir.mkdirs();
                }
                SetLoader.checkForMissingSpawnSets();
            }
            standard = SetLoader.importSetsFrom("pixelmon/spawning/" + PixelmonConfig.spawnSetFolder + "/");
        } else {
            ArrayList<SpawnSet> internalSets = SetLoader.retrieveSpawnSetsFromAssets();
            standard.addAll(internalSets);
        }
        TrackingSpawnerCoordinator.spawnerPreset.setSpawnSets(standard);
        SpawnSet rockSmashSet = new SpawnSet();
        rockSmashSet.id = "Rock Smash";
        SpawnSet fishingSet = new SpawnSet();
        fishingSet.id = "Fishing";
        SpawnSet lavaFishingSet = new SpawnSet();
        lavaFishingSet.id = "Lava Fishing";
        for (SpawnSet spawnSet : standard) {
            for (SpawnInfo spawnInfo : spawnSet.spawnInfos) {
                if (spawnInfo.locationTypes.contains(LocationType.ROCK_SMASH)) {
                    rockSmashSet.spawnInfos.add(spawnInfo);
                }
                if (spawnInfo.locationTypes.contains(LocationType.OLD_ROD) || spawnInfo.locationTypes.contains(LocationType.GOOD_ROD) || spawnInfo.locationTypes.contains(LocationType.SUPER_ROD)) {
                    fishingSet.spawnInfos.add(spawnInfo);
                }
                if (!spawnInfo.locationTypes.contains(LocationType.OLD_ROD_LAVA) && !spawnInfo.locationTypes.contains(LocationType.GOOD_ROD_LAVA) && !spawnInfo.locationTypes.contains(LocationType.SUPER_ROD_LAVA)) continue;
                lavaFishingSet.spawnInfos.add(spawnInfo);
            }
        }
        RockSmash.ROCK_SMASH_SPAWNER = new AbstractSpawner.SpawnerBuilder().setSpawnSets(rockSmashSet).apply(new TriggerSpawner());
        fishingSpawner = new AbstractSpawner.SpawnerBuilder().setSpawnSets(fishingSet, lavaFishingSet).apply(new TriggerSpawner());
    }
}

