/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.spawning.spawners;

import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.config.PixelmonServerConfig;
import com.pixelmonmod.pixelmon.database.SpawnLocation;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity3HasStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.BaseStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.Evolution;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.types.LevelingEvolution;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.pixelmonmod.pixelmon.spawning.SpawnData;
import com.pixelmonmod.pixelmon.spawning.WorldVariable;
import com.pixelmonmod.pixelmon.spawning.spawners.EntityData;
import com.pixelmonmod.pixelmon.spawning.spawners.EnumWorldState;
import com.pixelmonmod.pixelmon.spawning.spawners.SpawnRequestEvent;
import com.pixelmonmod.pixelmon.spawning.spawners.SpawnerNPC;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventBus;

public abstract class SpawnerBase {
    public static final EventBus SPAWN_DENIAL_BUS = new EventBus();
    public SpawnLocation spawnLocation;
    public WorldVariable<Integer> count = new WorldVariable<Integer>(0);
    private static Set<Material> validFloorMaterials = new HashSet<Material>();
    private static Set<Material> validAirMaterials;

    public SpawnerBase(SpawnLocation spawnLocation) {
        this.spawnLocation = spawnLocation;
    }

    public abstract int getMaxNum();

    public static void register(Object obj) {
        SPAWN_DENIAL_BUS.register(obj);
    }

    protected boolean requestSpawn(World world, BlockPos pos) {
        SpawnRequestEvent event = new SpawnRequestEvent(world, pos, this.spawnLocation);
        SPAWN_DENIAL_BUS.post((Event)event);
        return event.approved;
    }

    public abstract Integer getSpawnConditionY(World var1, BlockPos var2);

    public abstract List<SpawnData> getEntityList(String var1);

    public final String getRandomEntity(World world, Random rand, String biomeID, BlockPos pos) {
        EntityData data = this.getRandomEntity(world, rand, biomeID, pos, -1);
        return data == null ? "" : data.name;
    }

    public EntityData getRandomEntity(World world, Random rand, String biomeID, BlockPos pos, int level) {
        List<SpawnData> spawnData = this.getEntityList(biomeID);
        if (spawnData == null || spawnData.isEmpty()) {
            return null;
        }
        if (PixelmonConfig.spawnLevelsByDistance && level >= 0) {
            float randNum;
            if (this instanceof SpawnerNPC) {
                return new EntityData(SpawnerBase.getWeightedEntryFromList(world, spawnData), level);
            }
            if (level > 5 && (randNum = rand.nextFloat()) > 0.5f) {
                level = (int)((randNum - 0.5f) / 0.5f * (float)(level - 5) + 5.0f);
            }
            for (int i = 0; i < 3; ++i) {
                String testSpawn = SpawnerBase.getWeightedEntryFromList(world, spawnData);
                Optional<BaseStats> stats = Entity3HasStats.getBaseStats(testSpawn);
                if (!stats.isPresent()) continue;
                int slevel = 0;
                int maxLevel = PixelmonServerConfig.maxLevel;
                for (EnumPokemon enumPokemon : stats.get().preEvolutions) {
                    Optional<BaseStats> evostats = Entity3HasStats.getBaseStats(enumPokemon.name);
                    if (!evostats.isPresent()) continue;
                    for (Evolution evo : evostats.get().evolutions) {
                        if (evo == null || !(evo instanceof LevelingEvolution) || !evo.to.name.equals(stats.get().pokemon.name)) continue;
                        slevel = ((LevelingEvolution)evo).level;
                    }
                }
                for (Evolution evolution : stats.get().evolutions) {
                    if (evolution == null || !(evolution instanceof LevelingEvolution)) continue;
                    maxLevel = ((LevelingEvolution)evolution).level + 2;
                }
                if (level < slevel || level > maxLevel) continue;
                return new EntityData(testSpawn, level);
            }
            return null;
        }
        return new EntityData(SpawnerBase.getWeightedEntryFromList(world, spawnData), level);
    }

    public boolean canPokemonSpawnHere(World par1World, BlockPos pos) {
        if (!this.requestSpawn(par1World, pos)) {
            return false;
        }
        return this.canPokemonSpawnHereImpl(par1World, pos);
    }

    public float getYOffset(float x, float y, float z, EntityLiving pokemon) {
        return 0.0f;
    }

    public static EnumWorldState getWorldState(World world) {
        long time = world.func_72820_D() % 24000L;
        EnumWorldState state = time >= 22500L || time < 1000L ? EnumWorldState.dawn : (time >= 1000L && time < 11000L ? EnumWorldState.day : (time >= 11000L && time < 13500L ? EnumWorldState.dusk : EnumWorldState.night));
        return state;
    }

    public static String getWeightedEntryFromList(World world, List<SpawnData> spawnList) {
        EnumWorldState state = SpawnerBase.getWorldState(world);
        ArrayList<Integer> rarities = new ArrayList<Integer>();
        for (SpawnData aSpawnList1 : spawnList) {
            rarities.add(aSpawnList1.getRarity(state));
        }
        int spawnIndex = RandomHelper.getRandomIndexFromWeights(rarities);
        if (spawnIndex != -1) {
            return spawnList.get((int)spawnIndex).name;
        }
        return null;
    }

    protected abstract boolean canPokemonSpawnHereImpl(World var1, BlockPos var2);

    public boolean isBlockValidForPixelmonSpawning(World world, BlockPos pos) {
        IBlockState groundBlock = world.func_180495_p(pos.func_177977_b());
        Material spawnFloorGroundMaterial = groundBlock.func_185904_a();
        Material[] spawnAirMaterial = new Material[]{world.func_180495_p(pos).func_185904_a(), world.func_180495_p(pos.func_177984_a()).func_185904_a()};
        Set<Material> validFloorMaterials = this.getSpawnCheckMaterials();
        Set<Material> validAirMaterials = this.getValidSpawnAirMaterials();
        return validFloorMaterials.contains(spawnFloorGroundMaterial) && validAirMaterials.contains(spawnAirMaterial[0]) && validAirMaterials.contains(spawnAirMaterial[1]);
    }

    public Set<Material> getSpawnCheckMaterials() {
        return validFloorMaterials;
    }

    public Set<Material> getValidGroundMaterials() {
        return validFloorMaterials;
    }

    public Set<Material> getValidSpawnAirMaterials() {
        return validAirMaterials;
    }

    public Integer getTopEarthBlock(World world, BlockPos pos, boolean ignoreWater) {
        Chunk chunk = world.func_175726_f(pos);
        Integer k = null;
        BlockPos.MutableBlockPos p = new BlockPos.MutableBlockPos();
        k = Math.max(0, Math.min(chunk.func_76625_h() + 15, 255));
        while (k > 0) {
            p.func_181079_c(pos.func_177958_n(), k.intValue(), pos.func_177952_p());
            IBlockState state = world.func_180495_p((BlockPos)p);
            Block block = state.func_177230_c();
            if (block != Blocks.field_150350_a && (this.getValidGroundMaterials().contains(state.func_185904_a()) || !ignoreWater && state.func_185904_a() == Material.field_151586_h) && !block.isFoliage((IBlockAccess)world, (BlockPos)p)) {
                return k + 1;
            }
            k = k - 1;
        }
        return null;
    }

    public Integer getTopWaterBlock(World world, BlockPos pos) {
        Chunk chunk = world.func_175726_f(pos);
        Integer k = null;
        BlockPos.MutableBlockPos p = new BlockPos.MutableBlockPos();
        k = Math.max(0, Math.min(chunk.func_76625_h() + 15, 255));
        while (k > 0) {
            p.func_181079_c(pos.func_177958_n(), k.intValue(), pos.func_177952_p());
            IBlockState state = world.func_180495_p((BlockPos)p);
            Block block = state.func_177230_c();
            if (block != Blocks.field_150350_a && state.func_185904_a() == Material.field_151586_h) {
                return k;
            }
            k = k - 1;
        }
        return null;
    }

    public void modifyPokemon(EntityLiving pokemon, int x, int z) {
    }

    public SpawnLocation getActualSpawnLocation(EntityPixelmon pokemon) {
        return this.spawnLocation;
    }

    public boolean shouldSpawnInThisChunk(int chunkCount) {
        return true;
    }

    static {
        validFloorMaterials.add(Material.field_151577_b);
        validFloorMaterials.add(Material.field_151578_c);
        validFloorMaterials.add(Material.field_151576_e);
        validFloorMaterials.add(Material.field_151595_p);
        validFloorMaterials.add(Material.field_151588_w);
        validFloorMaterials.add(Material.field_151596_z);
        validFloorMaterials.add(Material.field_151598_x);
        validAirMaterials = new HashSet<Material>();
        validAirMaterials.add(Material.field_151579_a);
    }
}

