/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.spawning.spawners;

import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.database.SpawnLocation;
import com.pixelmonmod.pixelmon.spawning.EnumBiomeType;
import com.pixelmonmod.pixelmon.spawning.PixelmonBiomeDictionary;
import com.pixelmonmod.pixelmon.spawning.SpawnData;
import com.pixelmonmod.pixelmon.spawning.SpawnRegistry;
import com.pixelmonmod.pixelmon.spawning.spawners.SpawnerBase;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.material.Material;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;

public class SpawnerNPC
extends SpawnerBase {
    static Set<Material> validFloorMaterials = new HashSet<Material>();
    static Set<Material> validAirMaterials;

    public SpawnerNPC() {
        super(SpawnLocation.LandNPC);
    }

    @Override
    public Integer getSpawnConditionY(World world, BlockPos pos) {
        if (world.func_72912_H().func_76067_t() == WorldType.field_77138_c && this.isBlockValidForPixelmonSpawning(world, new BlockPos(pos.func_177958_n(), world.func_175645_m(pos).func_177956_o(), pos.func_177952_p()))) {
            return world.func_175645_m(pos).func_177956_o();
        }
        Integer topEarth = this.getTopEarthBlock(world, pos, false);
        if (topEarth == null) {
            return null;
        }
        Integer cpY = null;
        if (this.isBlockValidForPixelmonSpawning(world, new BlockPos(pos.func_177958_n(), topEarth.intValue(), pos.func_177952_p()))) {
            cpY = topEarth;
        } else {
            String biomeID = world.func_180494_b(pos).getRegistryName().func_110623_a();
            if (PixelmonBiomeDictionary.isBiomeOfType(biomeID, EnumBiomeType.JUNGLE)) {
                for (int i = 0; i < 5; ++i) {
                    if (!this.isBlockValidForPixelmonSpawning(world, new BlockPos(pos.func_177958_n(), topEarth + i, pos.func_177952_p()))) continue;
                    cpY = topEarth + i;
                    break;
                }
            }
        }
        return cpY;
    }

    @Override
    public List<SpawnData> getEntityList(String biomeID) {
        return SpawnRegistry.getNPCSpawnsForBiome(biomeID);
    }

    @Override
    public boolean canPokemonSpawnHereImpl(World world, BlockPos pos) {
        return this.isBlockValidForPixelmonSpawning(world, pos);
    }

    @Override
    public Set<Material> getSpawnCheckMaterials() {
        return validFloorMaterials;
    }

    @Override
    public Set<Material> getValidSpawnAirMaterials() {
        return validAirMaterials;
    }

    @Override
    public int getMaxNum() {
        return PixelmonConfig.maxNumNPCs;
    }

    static {
        validFloorMaterials.add(Material.field_151596_z);
        validFloorMaterials.add(Material.field_151577_b);
        validFloorMaterials.add(Material.field_151578_c);
        validFloorMaterials.add(Material.field_151588_w);
        validFloorMaterials.add(Material.field_151584_j);
        validFloorMaterials.add(Material.field_151576_e);
        validFloorMaterials.add(Material.field_151595_p);
        validFloorMaterials.add(Material.field_151597_y);
        validFloorMaterials.add(Material.field_151598_x);
        validFloorMaterials.add(Material.field_151585_k);
        validAirMaterials = new HashSet<Material>();
        validAirMaterials.add(Material.field_151579_a);
        validAirMaterials.add(Material.field_151585_k);
        validAirMaterials.add(Material.field_151597_y);
        validAirMaterials.add(Material.field_151582_l);
    }
}

