/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.spawning.spawners;

import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.database.SpawnLocation;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.FlyingParameters;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.SwimmingParameters;
import com.pixelmonmod.pixelmon.spawning.EnumBiomeType;
import com.pixelmonmod.pixelmon.spawning.PixelmonBiomeDictionary;
import com.pixelmonmod.pixelmon.spawning.SpawnData;
import com.pixelmonmod.pixelmon.spawning.WorldVariable;
import com.pixelmonmod.pixelmon.spawning.spawners.SpawnerBase;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;

public abstract class SpawnerTimed
extends SpawnerBase {
    private WorldVariable<Long> initTicks = new WorldVariable<Long>(0L);
    private WorldVariable<Integer> numTicksTillSpawn = new WorldVariable<Integer>(0);
    private WorldVariable<Boolean> init = new WorldVariable<Boolean>(true);
    static Set<Material> validFloorMaterials = new HashSet<Material>();
    static Set<Material> validAirMaterials;

    public SpawnerTimed(SpawnLocation location) {
        super(location);
    }

    @Override
    public Integer getSpawnConditionY(World world, BlockPos pos) {
        if (this.isDisabled()) {
            return null;
        }
        long worldTime = world.func_82737_E();
        int baseTicks = this.getSpawnTickBase();
        double tickVariance = this.getSpawnTickVariance();
        int maxTicksTillSpawn = (int)((double)baseTicks * (1.0 + tickVariance));
        int curNumTicksTillSpawn = Math.min(this.numTicksTillSpawn.get(world), maxTicksTillSpawn);
        this.numTicksTillSpawn.set(world, curNumTicksTillSpawn);
        long curInitTicks = Math.min(this.initTicks.get(world), worldTime);
        this.initTicks.set(world, curInitTicks);
        if (worldTime - curInitTicks >= (long)curNumTicksTillSpawn) {
            this.numTicksTillSpawn.set(world, RandomHelper.getRandomNumberBetween((int)((double)baseTicks * (1.0 - tickVariance)), maxTicksTillSpawn));
            this.initTicks.set(world, worldTime);
            if (!this.init.get(world).booleanValue() && this.rollSpawnChance()) {
                int yPos;
                int xPos = pos.func_177958_n();
                int zPos = pos.func_177952_p();
                if (world.func_72912_H().func_76067_t() == WorldType.field_77138_c && this.isBlockValidForPixelmonSpawning(world, new BlockPos(xPos, yPos = world.func_175645_m(pos).func_177956_o(), zPos))) {
                    return yPos;
                }
                Integer topEarth = this.getTopEarthBlock(world, pos, true);
                if (topEarth == null) {
                    return null;
                }
                Integer cpY = null;
                if (this.isBlockValidForPixelmonSpawning(world, new BlockPos(xPos, topEarth.intValue(), zPos))) {
                    cpY = topEarth;
                } else {
                    String biomeID = world.func_180494_b(pos).getRegistryName().func_110623_a();
                    if (PixelmonBiomeDictionary.isBiomeOfType(biomeID, EnumBiomeType.JUNGLE)) {
                        for (int i = 0; i < 5; ++i) {
                            if (!this.isBlockValidForPixelmonSpawning(world, new BlockPos(xPos, topEarth + i, zPos))) continue;
                            cpY = topEarth + i;
                            break;
                        }
                    }
                }
                return cpY;
            }
            this.init.set(world, false);
        }
        return null;
    }

    protected abstract boolean isDisabled();

    protected abstract int getSpawnTickBase();

    protected abstract double getSpawnTickVariance();

    protected boolean rollSpawnChance() {
        return true;
    }

    @Override
    public abstract int getMaxNum();

    @Override
    public abstract List<SpawnData> getEntityList(String var1);

    @Override
    protected boolean canPokemonSpawnHereImpl(World par1World, BlockPos pos) {
        return this.isBlockValidForPixelmonSpawning(par1World, pos);
    }

    @Override
    public boolean shouldSpawnInThisChunk(int chunkCount) {
        return RandomHelper.getRandomChance(1.0f / (float)chunkCount);
    }

    @Override
    public Set<Material> getSpawnCheckMaterials() {
        return validFloorMaterials;
    }

    @Override
    public Set<Material> getValidSpawnAirMaterials() {
        return validAirMaterials;
    }

    @Override
    public float getYOffset(float x, float y, float z, EntityLiving entity) {
        if (entity instanceof EntityPixelmon) {
            SwimmingParameters swimmingParameters;
            EntityPixelmon pokemon = (EntityPixelmon)entity;
            SpawnLocation location = this.getActualSpawnLocation(pokemon);
            if (location == SpawnLocation.AirPersistent) {
                FlyingParameters flyingParameters = pokemon.getFlyingParameters();
                int heightMin = flyingParameters.flyHeightMin;
                int heightMax = flyingParameters.flyHeightMax;
                return RandomHelper.getRandomNumberBetween(heightMin, heightMax);
            }
            if (location == SpawnLocation.Water && (swimmingParameters = pokemon.getSwimmingParameters()) != null && swimmingParameters.depthRangeStart == -1) {
                Integer topEarth = this.getTopEarthBlock(pokemon.field_70170_p, new BlockPos((double)x, (double)y, (double)z), false);
                return (float)topEarth.intValue() - y;
            }
        }
        return 0.0f;
    }

    static {
        validFloorMaterials.add(Material.field_151596_z);
        validFloorMaterials.add(Material.field_151577_b);
        validFloorMaterials.add(Material.field_151578_c);
        validFloorMaterials.add(Material.field_151588_w);
        validFloorMaterials.add(Material.field_151584_j);
        validFloorMaterials.add(Material.field_151576_e);
        validFloorMaterials.add(Material.field_151595_p);
        validFloorMaterials.add(Material.field_151597_y);
        validFloorMaterials.add(Material.field_151598_x);
        validFloorMaterials.add(Material.field_151585_k);
        validAirMaterials = new HashSet<Material>();
        validAirMaterials.add(Material.field_151579_a);
        validAirMaterials.add(Material.field_151586_h);
    }
}

