/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.spawning.spawners;

import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.database.SpawnLocation;
import com.pixelmonmod.pixelmon.spawning.SpawnData;
import com.pixelmonmod.pixelmon.spawning.SpawnRegistry;
import com.pixelmonmod.pixelmon.spawning.spawners.SpawnerBase;
import java.util.List;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;

public class SpawnerUnderground
extends SpawnerBase {
    protected static final int ENCLOSURE_RADIUS = 5;

    public SpawnerUnderground() {
        super(SpawnLocation.UnderGround);
    }

    @Override
    public Integer getSpawnConditionY(World world, BlockPos pos) {
        if (world.func_72912_H().func_76067_t() == WorldType.field_77138_c) {
            return null;
        }
        int intMaxAttempts = 5;
        boolean isValidY = false;
        Integer cpY = null;
        for (int intCounter = 0; intCounter < intMaxAttempts && !isValidY; ++intCounter) {
            cpY = world.field_73012_v.nextInt(55) + 5;
            isValidY = this.canPokemonSpawnHereImpl(world, new BlockPos(pos.func_177958_n(), cpY.intValue(), pos.func_177952_p()));
        }
        if (isValidY) {
            return cpY;
        }
        return null;
    }

    @Override
    public List<SpawnData> getEntityList(String biomeID) {
        return SpawnRegistry.getUndergroundSpawns();
    }

    @Override
    public boolean canPokemonSpawnHereImpl(World par1World, BlockPos pos) {
        if (!this.isMostlyEnclosedSpace(par1World, pos, 5)) {
            return false;
        }
        return this.isBlockValidForPixelmonSpawning(par1World, pos);
    }

    protected boolean isMostlyEnclosedSpace(World world, BlockPos pos, int radius) {
        for (EnumFacing dir : EnumFacing.values()) {
            boolean ok = false;
            for (int i = 0; i < radius; ++i) {
                if (!world.func_175677_d(new BlockPos(pos.func_177958_n() + dir.func_82601_c() * i, pos.func_177956_o() + dir.func_96559_d() * i, pos.func_177952_p() + dir.func_82599_e() * i), true)) continue;
                ok = true;
                break;
            }
            if (ok) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getMaxNum() {
        return PixelmonConfig.maxNumUndergroundPokemon;
    }
}

