/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.storage;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.PixelmonMethods;
import com.pixelmonmod.pixelmon.comm.PixelmonData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pcClientStorage.PCAdd;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pcClientStorage.PCClear;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pcClientStorage.PCRemove;
import com.pixelmonmod.pixelmon.config.PixelmonEntityList;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.pixelmonmod.pixelmon.enums.EnumType;
import com.pixelmonmod.pixelmon.storage.PlayerComputerStorage;
import com.pixelmonmod.pixelmon.storage.deepstorage.DeepStorageManager;
import java.util.ArrayList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ComputerBox {
    public boolean hasChanged = false;
    public static final int boxLimit = 30;
    public int position;
    private NBTTagCompound[] storedPokemon = new NBTTagCompound[30];
    private PlayerComputerStorage parentStorage;

    public ComputerBox(PlayerComputerStorage parentStorage, int position) {
        this.position = position;
        this.hasChanged = true;
        this.parentStorage = parentStorage;
    }

    public boolean hasSpace() {
        int count = 0;
        for (int i = 0; i < 30; ++i) {
            if (this.storedPokemon[i] == null) continue;
            ++count;
        }
        return count < 30;
    }

    public int count() {
        int count = 0;
        for (int i = 0; i < 30; ++i) {
            if (this.storedPokemon[i] == null) continue;
            ++count;
        }
        return count;
    }

    public void add(EntityPixelmon p) {
        NBTTagCompound n = new NBTTagCompound();
        p.setPokemonId(this.parentStorage.playerStorage.getNewPokemonID());
        p.func_70014_b(n);
        p.func_189511_e(n);
        int pos = this.getNextSpace();
        n.func_74778_a("id", p.getPokemonName());
        n.func_74757_a("IsInBall", true);
        n.func_74757_a("IsShiny", p.getIsShiny());
        if (p.func_70902_q() != null) {
            n.func_74778_a("originalTrainer", p.func_70902_q().func_145748_c_().func_150260_c());
        }
        n.func_74768_a("PixelmonOrder", pos);
        n.func_74768_a("BoxNumber", this.position);
        if (n.func_74765_d("Health") > 0) {
            n.func_74757_a("IsFainted", false);
        }
        if (p.type.get(0) != p.baseStats.type1) {
            n.func_74777_a("primaryType", (short)((EnumType)((Object)p.type.get(0))).getIndex());
        }
        if (p.type.size() > 1) {
            if (p.type.get(1) != p.baseStats.type2) {
                n.func_74777_a("secondaryType", (short)((EnumType)((Object)p.type.get(1))).getIndex());
            }
        } else {
            n.func_74777_a("secondaryType", (short)-1);
        }
        this.storedPokemon[pos] = n;
        this.hasChanged = true;
    }

    public int getNextSpace() {
        for (int i = 0; i < 30; ++i) {
            if (this.storedPokemon[i] != null) continue;
            return i;
        }
        return 0;
    }

    public NBTTagCompound get(int[] id) {
        for (NBTTagCompound n : this.storedPokemon) {
            if (n == null || !PixelmonMethods.isIDSame(n, id)) continue;
            return n;
        }
        return null;
    }

    public NBTTagCompound[] getStoredPokemon() {
        for (int i = 0; i < this.storedPokemon.length; ++i) {
            NBTTagCompound n = this.storedPokemon[i];
            if (n == null || !n.func_74779_i("Name").equals("")) continue;
            this.storedPokemon[i] = null;
        }
        return this.storedPokemon;
    }

    public NBTTagCompound getNBTByPosition(int pos) {
        return this.storedPokemon[pos];
    }

    public void load(NBTTagCompound boxTag) {
        for (int i = 0; i < 30; ++i) {
            this.storedPokemon[i] = null;
        }
        ArrayList<NBTTagCompound> unaddedPokemon = new ArrayList<NBTTagCompound>();
        for (int i = 0; i < 30; ++i) {
            if (!boxTag.func_74764_b("pc" + i)) continue;
            NBTTagCompound tag = boxTag.func_74775_l("pc" + i);
            if (!tag.func_74764_b("pixelmonID1")) {
                int[] id = this.parentStorage.playerStorage.getNewPokemonID();
                tag.func_74768_a("pixelmonID1", id[0]);
                tag.func_74768_a("pixelmonID2", id[1]);
            }
            if (!EnumPokemon.hasPokemonAnyCase(tag.func_74779_i("Name"))) {
                unaddedPokemon.add(tag);
                boxTag.func_82580_o("pc" + i);
                continue;
            }
            this.storedPokemon[i] = tag;
        }
        if (!unaddedPokemon.isEmpty()) {
            DeepStorageManager.bury(this.parentStorage.getPlayerID(), unaddedPokemon, false);
            this.hasChanged = true;
        } else {
            this.hasChanged = false;
        }
    }

    public void save(NBTTagCompound nbt) {
        for (int i = 0; i < 30; ++i) {
            if (this.storedPokemon[i] == null) continue;
            this.storedPokemon[i].func_74768_a("PixelmonOrder", i);
            nbt.func_74782_a("pc" + i, (NBTBase)this.storedPokemon[i]);
        }
        this.hasChanged = false;
    }

    public void addToFirstSpace(NBTTagCompound n) {
        for (int i = 0; i < 30; ++i) {
            if (this.storedPokemon[i] != null) continue;
            n.func_74768_a("PixelmonOrder", i);
            this.storedPokemon[i] = n;
            this.updatePCData(i);
            this.hasChanged = true;
            return;
        }
    }

    public void changePokemon(int boxPos, NBTTagCompound n) {
        if (n != null) {
            n.func_74768_a("PixelmonOrder", boxPos);
            n.func_74768_a("BoxNumber", this.position);
        }
        this.storedPokemon[boxPos] = n;
        this.hasChanged = true;
    }

    private void updatePCData(int pos) {
        if (this.parentStorage.getPlayer() != null) {
            Pixelmon.network.sendTo((IMessage)new PCClear(), this.parentStorage.getPlayer());
            if (this.storedPokemon[pos] != null) {
                Pixelmon.network.sendTo((IMessage)new PCAdd(new PixelmonData(this.storedPokemon[pos])), this.parentStorage.getPlayer());
            } else {
                Pixelmon.network.sendTo((IMessage)new PCRemove(this.position, pos), this.parentStorage.getPlayer());
            }
        }
    }

    public boolean contains(int[] id) {
        for (NBTTagCompound n : this.storedPokemon) {
            if (n == null || !PixelmonMethods.isIDSame(n, id)) continue;
            return true;
        }
        return false;
    }

    public EntityPixelmon getPokemonEntity(int[] pokemonID, World worldObj) {
        for (NBTTagCompound n : this.storedPokemon) {
            if (n == null || !PixelmonMethods.isIDSame(n, pokemonID)) continue;
            n.func_74776_a("FallDistance", 0.0f);
            n.func_74757_a("IsInBall", false);
            EntityPixelmon e = (EntityPixelmon)PixelmonEntityList.createEntityFromNBT(n, worldObj);
            e.func_184754_b(this.parentStorage.getPlayerID());
            e.playerOwned = true;
            e.field_70179_y = 0.0;
            e.field_70181_x = 0.0;
            e.field_70159_w = 0.0;
            e.field_70128_L = false;
            return e;
        }
        return null;
    }

    public void updatePokemonEntry(EntityPixelmon p) {
        for (int i = 0; i < this.storedPokemon.length; ++i) {
            NBTTagCompound nbt = this.storedPokemon[i];
            if (nbt == null || !PixelmonMethods.isIDSame(nbt, p)) continue;
            NBTTagCompound n = new NBTTagCompound();
            p.func_70014_b(n);
            p.func_189511_e(n);
            n.func_74778_a("id", p.getPokemonName());
            n.func_74757_a("IsInBall", true);
            n.func_74757_a("IsShiny", p.getIsShiny());
            n.func_74768_a("PixelmonOrder", nbt.func_74762_e("PixelmonOrder"));
            n.func_74757_a("isInRanch", nbt.func_74767_n("isInRanch"));
            n.func_74768_a("BoxNumber", this.position);
            if (n.func_74765_d("Health") > 0) {
                n.func_74757_a("IsFainted", false);
            }
            this.storedPokemon[i] = n;
            this.hasChanged = true;
        }
    }

    public NBTTagCompound getPokemonNBT(int[] id) {
        for (NBTTagCompound n : this.storedPokemon) {
            if (n == null || !PixelmonMethods.isIDSame(n, id)) continue;
            return n;
        }
        return null;
    }

    public void updatePokemonNBT(int[] id, NBTTagCompound nbt) {
        for (int i = 0; i < this.storedPokemon.length; ++i) {
            NBTTagCompound n = this.storedPokemon[i];
            if (n == null || !PixelmonMethods.isIDSame(n, id)) continue;
            this.storedPokemon[i] = nbt;
            this.hasChanged = true;
        }
    }

    public void unlockAllPokemon() {
        for (int i = 0; i < 30; ++i) {
            if (this.storedPokemon[i] == null) continue;
            this.storedPokemon[i].func_74757_a("isInRanch", false);
        }
    }

    public int getPlayerIdFromPokemon() {
        for (int i = 0; i < 30; ++i) {
            if (this.storedPokemon[i] == null) continue;
            return PixelmonMethods.getID(this.storedPokemon[i])[0];
        }
        return -1;
    }
}

