/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.storage;

import com.google.common.collect.Maps;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.storage.PlayerComputerStorage;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import com.pixelmonmod.pixelmon.storage.StorageAdapter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;

@Deprecated
public class DatabaseStorage
implements StorageAdapter {
    private static final String PLAYER_TABLE = "PLAYERDATA";
    private static final String POKEMON_TABLE = "POKEMON";
    private static final String READ_PLAYER = "SELECT * FROM PLAYERDATA WHERE UUIDMost = ? AND UUIDLeast = ?;";
    private static final String READ_PLAYER_ID = "SELECT id FROM PLAYERDATA WHERE UUIDMost = ? AND UUIDLeast = ?;";
    private static final String READ_PLAYER_POKEMON = "SELECT * FROM POKEMON WHERE PLAYERID = ? AND BOXNUMBER = -1;";
    private static final String READ_COMPUTER_POKEMON = "SELECT * FROM POKEMON WHERE PLAYERID = ? AND BOXNUMBER <> -1;";
    private static final String DEL_POKEMON_BOX = "DELETE FROM POKEMON WHERE PLAYERID = ? AND BOXNUMBER = ?;";
    private static final String UPDATE_POKEDEX = "UPDATE PLAYERDATA SET POKEDEX = ? WHERE id = ?;";
    private boolean checked_structure = false;
    public Connection connection;
    private LinkedHashMap<String, Class> playerTags;
    private LinkedHashMap<String, Class> pokeTags;

    public boolean checkConnection() {
        try {
            if (this.connection != null && this.connection.isValid(0)) {
                return true;
            }
            this.connection = DatabaseStorage.createConnection();
            this.checkPokemonDatabaseStructure();
            return this.connection.isValid(0);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public NBTTagCompound readPlayerData(UUID uuid) {
        this.checkConnection();
        NBTTagCompound nbt = new NBTTagCompound();
        try {
            int playerId;
            Throwable throwable;
            ResultSet rs2;
            Throwable throwable2;
            block61: {
                throwable2 = null;
                try (PreparedStatement readPlayer = this.connection.prepareStatement(READ_PLAYER);){
                    readPlayer.setLong(1, uuid.getMostSignificantBits());
                    readPlayer.setLong(2, uuid.getLeastSignificantBits());
                    rs2 = readPlayer.executeQuery();
                    throwable = null;
                    try {
                        if (rs2.first()) {
                            playerId = rs2.getInt("ID");
                            ArrayList<String> columns = DatabaseStorage.getColumns(rs2);
                            columns.remove("id");
                            columns.remove("UUIDMost");
                            columns.remove("UUIDLeast");
                            columns.remove("Pokedex");
                            this.readTags(this.playerTags, nbt, columns, rs2);
                            try {
                                Blob pokedexBlob = rs2.getBlob("POKEDEX");
                                NBTTagCompound pokedex = CompressedStreamTools.func_74794_a((DataInputStream)new DataInputStream(pokedexBlob.getBinaryStream()));
                                nbt.func_74782_a("Pokedex", pokedex.func_74781_a("pokedex"));
                            }
                            catch (IOException | SQLException e) {
                                e.printStackTrace();
                            }
                            break block61;
                        }
                        NBTTagCompound columns = null;
                        return columns;
                    }
                    catch (Throwable columns) {
                        throwable = columns;
                        throw columns;
                    }
                    finally {
                        if (rs2 != null) {
                            if (throwable != null) {
                                try {
                                    rs2.close();
                                }
                                catch (Throwable columns) {
                                    throwable.addSuppressed(columns);
                                }
                            } else {
                                rs2.close();
                            }
                        }
                    }
                }
                catch (Throwable rs2) {
                    throwable2 = rs2;
                    throw rs2;
                }
            }
            throwable2 = null;
            try (PreparedStatement readpokemon = this.connection.prepareStatement(READ_PLAYER_POKEMON);){
                readpokemon.setInt(1, playerId);
                rs2 = readpokemon.executeQuery();
                throwable = null;
                try {
                    int pokeCount = 0;
                    while (rs2.next()) {
                        ArrayList<String> columns = DatabaseStorage.getColumns(rs2);
                        NBTTagCompound pokemon = new NBTTagCompound();
                        this.readTags(this.pokeTags, pokemon, columns, rs2);
                        if (pokemon.func_74764_b("HeldItemName") && !pokemon.func_74779_i("HeldItemName").isEmpty()) {
                            ItemStack heldItem = new ItemStack(Item.func_111206_d((String)pokemon.func_74779_i("HeldItemName")));
                            pokemon.func_74782_a("HeldItemStack", (NBTBase)heldItem.func_77955_b(new NBTTagCompound()));
                        }
                        if (pokemon.func_74764_b("Status") && pokemon.func_74762_e("Status") == -1) {
                            pokemon.func_82580_o("Status");
                        }
                        nbt.func_74782_a("party" + pokeCount++, (NBTBase)pokemon);
                    }
                    return nbt;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    if (rs2 != null) {
                        if (throwable != null) {
                            try {
                                rs2.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            rs2.close();
                        }
                    }
                }
            }
            catch (Throwable throwable5) {
                throwable2 = throwable5;
                throw throwable5;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return nbt;
    }

    @Override
    public void writePlayerData(UUID uuid, NBTTagCompound storage) {
        this.checkConnection();
        try {
            Serializable tags;
            int playerId = this.readPlayerId(uuid);
            if (playerId != -1) {
                ArrayList<NBTBase> tags2 = new ArrayList<NBTBase>(this.playerTags.size() + 2);
                for (String tag : this.playerTags.keySet()) {
                    if (tag.equalsIgnoreCase("Pokedex")) continue;
                    tags2.add(storage.func_74781_a(tag));
                }
                tags2.add((NBTBase)new NBTTagLong(uuid.getMostSignificantBits()));
                tags2.add((NBTBase)new NBTTagLong(uuid.getLeastSignificantBits()));
                Iterator<String> i = this.playerTags.keySet().iterator();
                Object next = i.next();
                StringBuilder keys = new StringBuilder((String)next).append("=?");
                while (i.hasNext()) {
                    next = i.next();
                    if (((String)next).equalsIgnoreCase("Pokedex")) continue;
                    keys.append(",").append((String)next).append("=?");
                }
                PreparedStatement preparedStatement = this.connection.prepareStatement("UPDATE PLAYERDATA SET " + keys + " WHERE UUIDMost = ? AND UUIDLeast = ?;");
                this.writeTags(preparedStatement, tags2);
                preparedStatement.executeUpdate();
                preparedStatement.close();
            } else {
                ArrayList<String> playerTags = new ArrayList<String>(this.playerTags.size() + 2);
                playerTags.add("UUIDMost");
                playerTags.add("UUIDLeast");
                playerTags.addAll(this.playerTags.keySet());
                tags = new ArrayList<NBTBase>(playerTags.size());
                ((ArrayList)tags).add(new NBTTagLong(uuid.getMostSignificantBits()));
                ((ArrayList)tags).add(new NBTTagLong(uuid.getLeastSignificantBits()));
                for (String tag : this.playerTags.keySet()) {
                    ((ArrayList)tags).add(storage.func_74781_a(tag));
                }
                PreparedStatement preparedStatement = this.createInsert(PLAYER_TABLE, playerTags);
                this.writeTags(preparedStatement, (ArrayList<NBTBase>)tags);
                preparedStatement.executeUpdate();
                preparedStatement.close();
                playerId = this.readPlayerId(uuid);
            }
            PreparedStatement clearBox = this.connection.prepareStatement(DEL_POKEMON_BOX);
            tags = null;
            try {
                clearBox.setInt(1, playerId);
                clearBox.setInt(2, -1);
                clearBox.executeUpdate();
            }
            catch (Throwable preparedStatement) {
                tags = preparedStatement;
                throw preparedStatement;
            }
            finally {
                if (clearBox != null) {
                    if (tags != null) {
                        try {
                            clearBox.close();
                        }
                        catch (Throwable preparedStatement) {
                            ((Throwable)tags).addSuppressed(preparedStatement);
                        }
                    } else {
                        clearBox.close();
                    }
                }
            }
            ArrayList<NBTTagCompound> party = new ArrayList<NBTTagCompound>(6);
            for (int i = 0; i < 6; ++i) {
                if (!storage.func_74764_b("party" + i)) continue;
                NBTTagCompound pokemon = storage.func_74775_l("party" + i);
                pokemon.func_74768_a("BoxNumber", -1);
                if (!pokemon.func_74764_b("Status")) {
                    pokemon.func_74768_a("Status", -1);
                }
                if (pokemon.func_74764_b("HeldItemStack")) {
                    ItemStack heldItem = new ItemStack(pokemon.func_74775_l("HeldItemStack"));
                    String item = heldItem.func_190926_b() ? "" : heldItem.func_77973_b().getRegistryName().toString();
                    pokemon.func_74778_a("HeldItemName", item);
                }
                party.add(pokemon);
            }
            this.insertPokemon(playerId, party);
            try {
                NBTTagCompound outsideTag = new NBTTagCompound();
                outsideTag.func_74782_a("pokedex", (NBTBase)storage.func_150295_c("Pokedex", 8));
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                DataOutputStream s = new DataOutputStream(bos);
                CompressedStreamTools.func_74800_a((NBTTagCompound)outsideTag, (DataOutput)s);
                try (PreparedStatement update = this.connection.prepareStatement(UPDATE_POKEDEX);){
                    update.setBlob(1, new ByteArrayInputStream(bos.toByteArray()));
                    update.setInt(2, playerId);
                    update.executeUpdate();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (SQLException e) {
            Pixelmon.LOGGER.error("There was an issue storing party data for: " + uuid.toString(), (Throwable)e);
        }
    }

    @Override
    public NBTTagCompound readComputerData(UUID uuid) {
        this.checkConnection();
        NBTTagCompound nbt = new NBTTagCompound();
        try {
            int playerId = this.readPlayerId(uuid);
            if (playerId == -1) {
                return null;
            }
            try (PreparedStatement readPokemon = this.connection.prepareStatement(READ_COMPUTER_POKEMON);){
                readPokemon.setInt(1, playerId);
                try (ResultSet rs = readPokemon.executeQuery();){
                    while (rs.next()) {
                        int box;
                        NBTTagCompound pokemon = new NBTTagCompound();
                        ArrayList<String> columns = DatabaseStorage.getColumns(rs);
                        this.readTags(this.pokeTags, pokemon, columns, rs);
                        if (pokemon.func_74764_b("HeldItemName") && !pokemon.func_74779_i("HeldItemName").isEmpty()) {
                            ItemStack heldItem = new ItemStack(Item.func_111206_d((String)pokemon.func_74779_i("HeldItemName")));
                            pokemon.func_74782_a("HeldItemStack", (NBTBase)heldItem.func_77955_b(new NBTTagCompound()));
                        }
                        if (!nbt.func_74764_b((box = pokemon.func_74762_e("BoxNumber")) + "")) {
                            nbt.func_74782_a(box + "", (NBTBase)new NBTTagCompound());
                        }
                        NBTTagCompound boxTag = nbt.func_74775_l(box + "");
                        int order = pokemon.func_74762_e("PixelmonOrder");
                        boxTag.func_74782_a("pc" + order, (NBTBase)pokemon);
                    }
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return nbt;
    }

    @Override
    public void writeComputerData(UUID uuid, NBTTagCompound storage) {
        this.checkConnection();
        try {
            int playerId = this.readPlayerId(uuid);
            if (playerId == -1) {
                return;
            }
            try (PreparedStatement clearBox = this.connection.prepareStatement(DEL_POKEMON_BOX);){
                clearBox.setInt(1, playerId);
                for (int boxNum = 0; boxNum < PlayerComputerStorage.boxCount; ++boxNum) {
                    clearBox.setInt(2, boxNum);
                    NBTTagCompound boxTag = storage.func_74775_l("" + boxNum);
                    ArrayList<NBTTagCompound> pokemonBox = new ArrayList<NBTTagCompound>();
                    for (int j = 0; j < 30; ++j) {
                        if (!boxTag.func_74764_b("pc" + j)) continue;
                        NBTTagCompound pokemon = boxTag.func_74775_l("pc" + j);
                        pokemon.func_74768_a("BoxNumber", boxNum);
                        if (!pokemon.func_74764_b("Status")) {
                            pokemon.func_74768_a("Status", -1);
                        }
                        if (pokemon.func_74764_b("HeldItemStack")) {
                            ItemStack heldItem = new ItemStack(pokemon.func_74775_l("HeldItemStack"));
                            String item = heldItem.func_190926_b() ? "" : heldItem.func_77973_b().getRegistryName().toString();
                            pokemon.func_74778_a("HeldItemName", item);
                        }
                        pokemonBox.add(pokemon);
                    }
                    clearBox.executeUpdate();
                    this.insertPokemon(playerId, pokemonBox);
                }
            }
        }
        catch (SQLException e) {
            Pixelmon.LOGGER.error("There was an issue storing computer data for: " + uuid.toString(), (Throwable)e);
        }
    }

    private int readPlayerId(UUID uuid) throws SQLException {
        try (PreparedStatement readPlayerId = this.connection.prepareStatement(READ_PLAYER_ID);){
            readPlayerId.setLong(1, uuid.getMostSignificantBits());
            readPlayerId.setLong(2, uuid.getLeastSignificantBits());
            try (ResultSet rs = readPlayerId.executeQuery();){
                if (rs.first()) {
                    int n = rs.getInt("ID");
                    return n;
                }
            }
        }
        return -1;
    }

    private void writeTags(PreparedStatement statement, ArrayList<NBTBase> tags) throws SQLException {
        int index = 1;
        for (NBTBase tag : tags) {
            if (tag instanceof NBTTagByte) {
                statement.setByte(index++, ((NBTTagByte)tag).func_150290_f());
                continue;
            }
            if (tag instanceof NBTTagShort) {
                statement.setShort(index++, ((NBTTagShort)tag).func_150289_e());
                continue;
            }
            if (tag instanceof NBTTagInt) {
                statement.setInt(index++, ((NBTTagInt)tag).func_150287_d());
                continue;
            }
            if (tag instanceof NBTTagLong) {
                statement.setLong(index++, ((NBTTagLong)tag).func_150291_c());
                continue;
            }
            if (tag instanceof NBTTagFloat) {
                statement.setFloat(index++, ((NBTTagFloat)tag).func_150288_h());
                continue;
            }
            if (tag instanceof NBTTagDouble) {
                statement.setDouble(index++, ((NBTTagDouble)tag).func_150291_c());
                continue;
            }
            if (tag instanceof NBTTagString) {
                statement.setString(index++, ((NBTTagString)tag).func_150285_a_());
                continue;
            }
            if (tag instanceof NBTTagList) {
                byte[] array = new byte[]{};
                try {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    DataOutputStream s = new DataOutputStream(bos);
                    NBTTagCompound compound = new NBTTagCompound();
                    compound.func_74782_a("blob", tag);
                    CompressedStreamTools.func_74800_a((NBTTagCompound)compound, (DataOutput)s);
                    array = bos.toByteArray();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                statement.setBlob(index++, new ByteArrayInputStream(array));
                continue;
            }
            if (tag == null) {
                statement.setNull(index++, 4);
                Pixelmon.LOGGER.error("SAVING NULL TAG ");
                continue;
            }
            Pixelmon.LOGGER.error("I don't know how to save " + tag.getClass().getName());
        }
    }

    private void readTags(Map<String, Class> expectedTags, NBTTagCompound compound, ArrayList<String> columns, ResultSet resultSet) throws SQLException {
        for (String name : columns) {
            for (Map.Entry<String, Class> entry : expectedTags.entrySet()) {
                if (!name.equalsIgnoreCase(entry.getKey())) continue;
                if (entry.getValue() == Byte.class || entry.getValue() == Boolean.class) {
                    compound.func_74774_a(entry.getKey(), resultSet.getByte(name));
                    continue;
                }
                if (entry.getValue() == Short.class) {
                    compound.func_74777_a(entry.getKey(), resultSet.getShort(name));
                    continue;
                }
                if (entry.getValue() == Integer.class) {
                    compound.func_74768_a(entry.getKey(), resultSet.getInt(name));
                    continue;
                }
                if (entry.getValue() == Long.class) {
                    compound.func_74772_a(entry.getKey(), resultSet.getLong(name));
                    continue;
                }
                if (entry.getValue() == Float.class) {
                    compound.func_74776_a(entry.getKey(), resultSet.getFloat(name));
                    continue;
                }
                if (entry.getValue() == Double.class) {
                    compound.func_74780_a(entry.getKey(), resultSet.getDouble(name));
                    continue;
                }
                if (entry.getValue() == String.class) {
                    compound.func_74778_a(entry.getKey(), resultSet.getString(name));
                    continue;
                }
                if (entry.getValue() == NBTTagList.class) {
                    Blob pokedexBlob = resultSet.getBlob(name);
                    try {
                        NBTTagCompound blob = CompressedStreamTools.func_74794_a((DataInputStream)new DataInputStream(pokedexBlob.getBinaryStream()));
                        compound.func_74782_a(entry.getKey(), blob.func_74781_a("blob"));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                Pixelmon.LOGGER.error("I don't know how to read " + entry.getValue().getClass().getName());
            }
        }
    }

    private void insertPokemon(int playerID, Collection<NBTTagCompound> pokemon) throws SQLException {
        if (pokemon.size() < 1) {
            return;
        }
        Iterator<String> i = this.pokeTags.keySet().iterator();
        String next = i.next();
        StringBuilder keys = new StringBuilder(next);
        StringBuilder values = new StringBuilder("?");
        while (i.hasNext()) {
            next = i.next();
            keys.append(", ").append(next);
            values.append(", ?");
        }
        String sql = "INSERT INTO POKEMON (PLAYERID, " + keys.toString() + ") VALUES (?, " + values.toString() + ");";
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(sql);){
            preparedStatement.setInt(1, playerID);
            for (NBTTagCompound compound : pokemon) {
                int index = 2;
                for (Map.Entry<String, Class> entry : this.pokeTags.entrySet()) {
                    if (entry.getValue() == Byte.class || entry.getValue() == Boolean.class) {
                        preparedStatement.setByte(index++, compound.func_74771_c(entry.getKey()));
                        continue;
                    }
                    if (entry.getValue() == Short.class) {
                        preparedStatement.setShort(index++, compound.func_74765_d(entry.getKey()));
                        continue;
                    }
                    if (entry.getValue() == Integer.class) {
                        preparedStatement.setInt(index++, compound.func_74762_e(entry.getKey()));
                        continue;
                    }
                    if (entry.getValue() == Long.class) {
                        preparedStatement.setLong(index++, compound.func_74763_f(entry.getKey()));
                        continue;
                    }
                    if (entry.getValue() == Float.class) {
                        preparedStatement.setFloat(index++, compound.func_74760_g(entry.getKey()));
                        continue;
                    }
                    if (entry.getValue() == Double.class) {
                        preparedStatement.setDouble(index++, compound.func_74769_h(entry.getKey()));
                        continue;
                    }
                    if (entry.getValue() == String.class) {
                        preparedStatement.setString(index++, compound.func_74779_i(entry.getKey()));
                        continue;
                    }
                    Pixelmon.LOGGER.error("insertPokemon I don't know how to write " + entry.getValue().getName());
                }
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
        }
    }

    private PreparedStatement createInsert(String table, Iterable<String> collection) throws SQLException {
        Iterator<String> i = collection.iterator();
        String next = i.next();
        StringBuilder keys = new StringBuilder(next);
        StringBuilder values = new StringBuilder("?");
        while (i.hasNext()) {
            next = i.next();
            keys.append(", ").append(next);
            values.append(", ?");
        }
        return this.connection.prepareStatement("INSERT INTO " + table + "(" + keys.toString() + ") VALUES (" + values.toString() + ");");
    }

    private void checkPokemonDatabaseStructure() {
        if (this.checked_structure) {
            return;
        }
        this.playerTags = PlayerStorage.getNBTTags();
        this.pokeTags = new LinkedHashMap();
        EntityPixelmon p = new EntityPixelmon(FMLCommonHandler.instance().getMinecraftServerInstance().func_130014_f_());
        p.getNBTTags(this.pokeTags);
        try {
            this.connection.createStatement().execute("CREATE TABLE IF NOT EXISTS PLAYERDATA (id INTEGER NOT NULL AUTO_INCREMENT, PRIMARY KEY (id));");
            this.connection.createStatement().execute("CREATE TABLE IF NOT EXISTS POKEMON (id INTEGER NOT NULL AUTO_INCREMENT, PLAYERID INTEGER, PRIMARY KEY (id));");
            DatabaseMetaData meta = this.connection.getMetaData();
            LinkedHashMap tempPlayerTags = Maps.newLinkedHashMap();
            tempPlayerTags.put("UUIDMost", Long.class);
            tempPlayerTags.put("UUIDLeast", Long.class);
            tempPlayerTags.putAll(this.playerTags);
            this.checkTable(meta, PLAYER_TABLE, tempPlayerTags);
            this.checkTable(meta, POKEMON_TABLE, this.pokeTags);
            this.checked_structure = true;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void checkTable(DatabaseMetaData meta, String table, HashMap<String, Class> tags) throws SQLException {
        ResultSet rs = meta.getColumns(null, null, table, null);
        ArrayList<String> columns = new ArrayList<String>();
        while (rs.next()) {
            columns.add(rs.getString("COLUMN_NAME").toLowerCase());
        }
        Statement statement = this.connection.createStatement();
        for (Map.Entry<String, Class> entry : tags.entrySet()) {
            if (columns.contains(entry.getKey().toLowerCase())) continue;
            if (entry.getValue() == Byte.class || entry.getValue() == Boolean.class) {
                statement.addBatch("ALTER TABLE " + table + " ADD " + entry.getKey() + " TINYINT;");
                continue;
            }
            if (entry.getValue() == Short.class) {
                statement.addBatch("ALTER TABLE " + table + " ADD " + entry.getKey() + " SMALLINT;");
                continue;
            }
            if (entry.getValue() == Integer.class) {
                statement.addBatch("ALTER TABLE " + table + " ADD " + entry.getKey() + " INTEGER;");
                continue;
            }
            if (entry.getValue() == Long.class) {
                statement.addBatch("ALTER TABLE " + table + " ADD " + entry.getKey() + " BIGINT;");
                continue;
            }
            if (entry.getValue() == Float.class) {
                statement.addBatch("ALTER TABLE " + table + " ADD " + entry.getKey() + " FLOAT;");
                continue;
            }
            if (entry.getValue() == Double.class) {
                statement.addBatch("ALTER TABLE " + table + " ADD " + entry.getKey() + " DOUBLE;");
                continue;
            }
            if (entry.getValue() == String.class) {
                statement.addBatch("ALTER TABLE " + table + " ADD " + entry.getKey() + " VARCHAR(64);");
                continue;
            }
            if (entry.getValue() == NBTTagList.class) {
                statement.addBatch("ALTER TABLE " + table + " ADD " + entry.getKey() + " BLOB;");
                continue;
            }
            Pixelmon.LOGGER.error("I don't know how to create " + entry.getValue().getClass().getName());
        }
        statement.executeBatch();
    }

    private static ArrayList<String> getColumns(ResultSet resultSet) throws SQLException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        int colCount = metaData.getColumnCount() + 1;
        ArrayList<String> columns = new ArrayList<String>(colCount);
        for (int i = 1; i < colCount; ++i) {
            columns.add(metaData.getColumnName(i));
        }
        return columns;
    }

    private static Connection createConnection() throws SQLException {
        if (PixelmonConfig.connectionString.contains("mysql")) {
            try {
                if (Pixelmon.devEnvironment) {
                    Loader.instance().getModClassLoader().addFile(new File(Pixelmon.modDirectory + "/database/mysql-connector-java-5.1.28-bin.jar"));
                }
                Class.forName("com.mysql.jdbc.Driver").newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return DriverManager.getConnection(PixelmonConfig.connectionString);
    }
}

