/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.storage;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.enums.DeleteType;
import com.pixelmonmod.pixelmon.api.events.PixelmonDeletedEvent;
import com.pixelmonmod.pixelmon.comm.PixelmonData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pcClientStorage.PCAdd;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pcClientStorage.PCClear;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pcClientStorage.PCLastBox;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.storage.ComputerBox;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerComputerStorage;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import java.util.Optional;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PCServer {
    public static void deletePokemon(EntityPlayerMP player, int box, int pos) {
        Optional<PlayerStorage> optstorage = PixelmonStorage.pokeBallManager.getPlayerStorage(player);
        if (optstorage.isPresent()) {
            PlayerStorage storage = optstorage.get();
            storage.recallAllPokemon();
        }
        Pixelmon.EVENT_BUS.post((Event)new PixelmonDeletedEvent(player, PCServer.getPokemonAtPos(player, box, pos), DeleteType.PC));
        PCServer.storePokemonAtPos(player, null, box, pos);
    }

    public static void swapPokemon(EntityPlayerMP player, int firstBox, int firstPos, int secondBox, int secondPos) {
        NBTTagCompound n1 = PCServer.getPokemonAtPos(player, firstBox, firstPos);
        NBTTagCompound n2 = PCServer.getPokemonAtPos(player, secondBox, secondPos);
        PCServer.unloadEntity(player, firstBox, firstPos);
        PCServer.unloadEntity(player, secondBox, secondPos);
        PCServer.storePokemonAtPos(player, n1, secondBox, secondPos);
        PCServer.storePokemonAtPos(player, n2, firstBox, firstPos);
    }

    private static void storePokemonAtPos(EntityPlayerMP player, NBTTagCompound nbt, int box, int pos) {
        if (box == -1) {
            Optional<PlayerStorage> optstorage = PixelmonStorage.pokeBallManager.getPlayerStorage(player);
            if (optstorage.isPresent()) {
                PlayerStorage storage = optstorage.get();
                storage.changePokemon(pos, nbt);
            }
        } else {
            PlayerComputerStorage storage = PixelmonStorage.computerManager.getPlayerStorage(player);
            storage.getBox(box).changePokemon(pos, nbt);
            storage.lastBoxOpen = box;
        }
    }

    private static void unloadEntity(EntityPlayerMP player, int box, int pos) {
        Optional<EntityPixelmon> p;
        PlayerStorage storage;
        int[] id;
        Optional<PlayerStorage> optstorage = PixelmonStorage.pokeBallManager.getPlayerStorage(player);
        if (optstorage.isPresent() && (id = (storage = optstorage.get()).getIDFromPosition(pos))[0] != -1 && id[1] != -1 && (p = storage.getAlreadyExists(id, player.field_70170_p)).isPresent()) {
            p.get().unloadEntity();
        }
    }

    public static NBTTagCompound getPokemonAtPos(EntityPlayerMP player, int box, int pos) {
        if (box == -1) {
            Optional<PlayerStorage> optstorage = PixelmonStorage.pokeBallManager.getPlayerStorage(player);
            if (optstorage.isPresent()) {
                PlayerStorage storage = optstorage.get();
                return storage.getList()[pos];
            }
            return null;
        }
        return PixelmonStorage.computerManager.getPlayerStorage(player).getBox(box).getNBTByPosition(pos);
    }

    public static void sendContentsToPlayer(EntityPlayerMP player) {
        Pixelmon.network.sendTo((IMessage)new PCClear(), player);
        PlayerComputerStorage s = PixelmonStorage.computerManager.getPlayerStorage(player);
        Pixelmon.network.sendTo((IMessage)new PCLastBox(s.lastBoxOpen), player);
        for (ComputerBox b : s.getBoxList()) {
            for (NBTTagCompound n : b.getStoredPokemon()) {
                if (n == null) continue;
                PixelmonData p = new PixelmonData(n);
                Pixelmon.network.sendTo((IMessage)new PCAdd(p), player);
            }
        }
    }
}

