/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.storage;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.packetHandlers.SendExtraData;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.EnumSpecialTexture;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerExtraData;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import com.pixelmonmod.pixelmon.util.RegexPatterns;
import java.net.URL;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.io.IOUtils;

public class PlayerExtras {
    private static final ExecutorService executorService = new ThreadPoolExecutor(0, 2, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>());

    public static void refreshExtras(EntityPlayerMP player) {
        Optional<PlayerStorage> optstorage = PixelmonStorage.pokeBallManager.getPlayerStorage(player);
        if (optstorage.isPresent()) {
            PlayerStorage storage = optstorage.get();
            storage.getExtraData().reset();
            PlayerExtras.refreshOnline(player);
        }
    }

    public static PlayerExtraData getExtras(EntityPlayerMP player) {
        Optional<PlayerStorage> optstorage = PixelmonStorage.pokeBallManager.getPlayerStorage(player);
        if (optstorage.isPresent()) {
            PlayerStorage storage = optstorage.get();
            PlayerExtraData e = storage.getExtraData();
            if (e.hasData() && e.shouldRefresh()) {
                PlayerExtras.refreshOnline(player);
            }
            return e;
        }
        return new PlayerExtraData(player.func_110124_au());
    }

    public static void checkOnlineData(EntityPlayerMP player, EntityPixelmon pokemon) {
        UUID uuid = player.func_110124_au();
        PlayerExtras.checkDataOnline(uuid, extras -> player.func_71121_q().func_152344_a(() -> {
            PlayerExtras.updatePlayer(player, extras);
            if (pokemon != null && (extras.hasHalloween && pokemon.baseStats.pokemon == EnumPokemon.Haunter || extras.hasLugia && pokemon.baseStats.pokemon == EnumPokemon.Lugia)) {
                pokemon.setSpecialTexture(EnumSpecialTexture.Online.id);
                Optional<PlayerStorage> optstorage = pokemon.getStorage();
                if (optstorage.isPresent()) {
                    PlayerStorage storage = optstorage.get();
                    storage.update(pokemon, EnumUpdateType.Texture);
                }
            }
        }));
    }

    private static void refreshOnline(EntityPlayerMP player) {
        UUID uuid = player.func_110124_au();
        PlayerExtras.checkDataOnline(uuid, extras -> PlayerExtras.updatePlayer(player, extras));
    }

    private static void updatePlayer(EntityPlayerMP player, PlayerExtraData extras) {
        Optional<PlayerStorage> optstorage = PixelmonStorage.pokeBallManager.getPlayerStorage(player);
        if (optstorage.isPresent()) {
            PlayerStorage storage = optstorage.get();
            storage.getExtraData().setDataValues(extras);
            if (extras.hasData()) {
                Pixelmon.network.sendToAll((IMessage)new SendExtraData(storage.getExtraData()));
            }
        }
    }

    public static void checkDataOnline(UUID uuid, Consumer<PlayerExtraData> callback) {
        if (uuid.version() == 3) {
            callback.accept(new PlayerExtraData(uuid));
            return;
        }
        executorService.submit(() -> {
            try {
                String response = IOUtils.toString((URL)new URL("http://api.pixelmonmod.com/arctic/" + RegexPatterns.DOT_SYMBOL.matcher("6.2.3").replaceAll("") + "/mc_group.php?uuid=" + RegexPatterns.DASH_SYMBOL.matcher(uuid.toString()).replaceAll("")));
                String[] splits = response.split(";");
                String[] groups = splits[0].split(",");
                PlayerExtraData extras = new PlayerExtraData(uuid);
                for (String group : groups) {
                    String g = RegexPatterns.NEWLINE_CHAR.matcher(group).replaceAll("");
                    int grp = Integer.valueOf(g.trim());
                    if (grp == 5) {
                        extras.isAdmin = true;
                    } else if (grp == 43) {
                        extras.isDeveloper = true;
                    } else if (grp == 39) {
                        extras.isModeller = true;
                    } else if (grp == 44) {
                        extras.isSupport = true;
                    } else if (grp == 21) {
                        extras.isJAdmin = true;
                    } else if (grp == 56) {
                        extras.hasRainbowSash = true;
                    } else if (grp == 45) {
                        extras.hasCap = true;
                    } else if (grp == 62) {
                        extras.hasLugia = true;
                    } else if (grp == 53) {
                        extras.isCompWinner = true;
                    }
                    if (grp == 5 || grp == 43 || grp == 47 || grp == 39 || grp == 56) {
                        extras.hasSash = true;
                    }
                    if (grp != 48 && grp != 5) continue;
                    extras.hasHalloween = true;
                }
                if (splits.length > 1) {
                    String[] colours = splits[1].split(",");
                    extras.colours[0] = Integer.parseInt(colours[0]);
                    extras.colours[1] = Integer.parseInt(colours[1]);
                    extras.colours[2] = Integer.parseInt(colours[2]);
                }
                callback.accept(extras);
            }
            catch (Exception exception) {
                Pixelmon.LOGGER.info("Couldn't connect to Pixelmon servers: " + exception.getLocalizedMessage());
            }
        });
    }

    public static enum HatType {
        NONE(-1),
        TOP_HAT(0),
        FEZ(1),
        FEDORA(2),
        TRAINER_HAT(4);

        public final int id;

        private HatType(int id) {
            this.id = id;
        }

        public static HatType getFromId(int id) {
            for (HatType hat : HatType.values()) {
                if (hat.id != id) continue;
                return hat;
            }
            return NONE;
        }

        public static HatType getFromName(String name) {
            for (HatType hat : HatType.values()) {
                if (!hat.name().replace("_", "").equalsIgnoreCase(name)) continue;
                return hat;
            }
            return NONE;
        }
    }
}

