/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.storage.playerData;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.comm.PixelmonData;
import com.pixelmonmod.pixelmon.entities.pixelmon.externalMoves.ExternalMoveBase;
import com.pixelmonmod.pixelmon.entities.pixelmon.externalMoves.ExternalMoveRegistry;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.pixelmonmod.pixelmon.enums.forms.EnumGreninja;
import com.pixelmonmod.pixelmon.items.ItemHeld;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import com.pixelmonmod.pixelmon.storage.playerData.ExternalMoveData;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.nbt.NBTTagCompound;

public class ExternalMoves {
    private HashMap<Integer, ExternalMoveData[]> moves = new HashMap();
    private PlayerStorage storage;

    public ExternalMoves(PlayerStorage parent) {
        this.storage = parent;
    }

    public void refresh() {
        for (int i = 0; i < 6; ++i) {
            this.refresh(this.storage.partyPokemon[i]);
        }
    }

    public void refresh(NBTTagCompound nbt) {
        int id;
        int i;
        int numMoves;
        ArrayList<ExternalMoveData> pokeMoves = new ArrayList<ExternalMoveData>();
        pokeMoves.add(new ExternalMoveData(5, ExternalMoveRegistry.forage));
        String name = nbt.func_74779_i("Name");
        EnumPokemon pokemon = EnumPokemon.getFromNameAnyCase(name);
        if (pokemon.hasMega()) {
            if (PixelmonWrapper.hasCompatibleMegaStone(ItemHeld.getItemHeld(ItemHeld.readHeldItemFromNBT(nbt)), pokemon)) {
                pokeMoves.add(new ExternalMoveData(99, ExternalMoveRegistry.megaEvolution));
            }
        } else if (pokemon == EnumPokemon.Greninja && nbt.func_74762_e("Variant") == EnumGreninja.BATTLE_BOND.getForm()) {
            pokeMoves.add(new ExternalMoveData(99, ExternalMoveRegistry.megaEvolution));
        } else if (pokemon == EnumPokemon.Rayquaza) {
            numMoves = nbt.func_74762_e("PixelmonNumberMoves");
            for (i = 0; i < numMoves; ++i) {
                id = nbt.func_74762_e("PixelmonMoveID" + i);
                if (id != Attack.getAttackBase((String)"Dragon Ascent").get().attackIndex) continue;
                pokeMoves.add(new ExternalMoveData(99, ExternalMoveRegistry.megaEvolution));
            }
        }
        numMoves = nbt.func_74762_e("PixelmonNumberMoves");
        for (i = 0; i < numMoves; ++i) {
            id = nbt.func_74762_e("PixelmonMoveID" + i);
            ExternalMoveBase e = ExternalMoveRegistry.getExternalMove(id);
            if (e == null) continue;
            pokeMoves.add(new ExternalMoveData(i, e));
        }
        ExternalMoveData[] list = this.moves.get(nbt.func_74762_e("pixelmonID2"));
        ExternalMoveData[] base = pokeMoves.toArray(new ExternalMoveData[pokeMoves.size()]);
        if (list != null) {
            for (ExternalMoveData data : base) {
                for (ExternalMoveData oldData : list) {
                    if (data.getBaseExternalMove() != oldData.getBaseExternalMove()) continue;
                    data.timeLastUsed = oldData.timeLastUsed;
                }
            }
        }
        this.moves.put(nbt.func_74762_e("pixelmonID2"), base);
    }

    public static ExternalMoveData[] load(PixelmonData pdata) {
        int id;
        int i;
        ArrayList<ExternalMoveData> pokeMoves = new ArrayList<ExternalMoveData>();
        int numMoves = pdata.numMoves;
        pokeMoves.add(new ExternalMoveData(5, ExternalMoveRegistry.forage));
        EnumPokemon pokemon = pdata.getSpecies();
        if (pokemon.hasMega()) {
            if (PixelmonWrapper.hasCompatibleMegaStone(ItemHeld.getItemHeld(pdata.heldItem), pokemon)) {
                pokeMoves.add(new ExternalMoveData(99, ExternalMoveRegistry.megaEvolution));
            }
        } else if (pokemon == EnumPokemon.Greninja && pdata.form == EnumGreninja.BATTLE_BOND.getForm()) {
            pokeMoves.add(new ExternalMoveData(99, ExternalMoveRegistry.megaEvolution));
        } else if (pokemon == EnumPokemon.Rayquaza) {
            for (i = 0; i < numMoves; ++i) {
                id = pdata.moveset[i].attackIndex;
                if (id != Attack.getAttackBase((String)"Dragon Ascent").get().attackIndex) continue;
                pokeMoves.add(new ExternalMoveData(99, ExternalMoveRegistry.megaEvolution));
            }
        }
        for (i = 0; i < numMoves; ++i) {
            id = pdata.moveset[i].attackIndex;
            ExternalMoveBase e = ExternalMoveRegistry.getExternalMove(id);
            if (e == null) continue;
            pokeMoves.add(new ExternalMoveData(i, e));
        }
        return pokeMoves.toArray(new ExternalMoveData[pokeMoves.size()]);
    }

    public ExternalMoveData get(int[] pokemonId, int moveIndex) {
        ExternalMoveData[] list = this.moves.get(pokemonId[1]);
        if (list != null && moveIndex >= 0 && moveIndex < list.length) {
            return list[moveIndex];
        }
        return null;
    }

    public void set(int[] pokemonId, int moveIndex, ExternalMoveData move) {
        ExternalMoveData[] list = this.moves.get(pokemonId[1]);
        if (list != null && moveIndex >= 0 && moveIndex < list.length) {
            list[moveIndex] = move;
        }
        this.moves.put(pokemonId[1], list);
    }
}

