/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.storage.playerData;

import com.pixelmonmod.pixelmon.storage.playerData.ISaveData;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3d;

public class TeleportPosition
implements ISaveData {
    private double x;
    private double y;
    private double z;
    private float yaw;
    private float pitch;

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74780_a("tpPosX", this.x);
        nbt.func_74780_a("tpPosY", this.y);
        nbt.func_74780_a("tpPosZ", this.z);
        nbt.func_74776_a("tpRotY", this.yaw);
        nbt.func_74776_a("tpRotP", this.pitch);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.x = nbt.func_74769_h("tpPosX");
        this.y = nbt.func_74769_h("tpPosY");
        this.z = nbt.func_74769_h("tpPosZ");
        this.yaw = nbt.func_74760_g("tpRotY");
        this.pitch = nbt.func_74760_g("tpRotP");
    }

    public void store(double posX, double posY, double posZ, float rotationYaw, float rotationPitch) {
        this.x = posX;
        this.y = posY;
        this.z = posZ;
        this.yaw = rotationYaw;
        this.pitch = rotationPitch;
    }

    public void teleport(EntityPlayerMP player) {
        if (this.x != 0.0 && this.y != 0.0 && this.z != 0.0) {
            player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187534_aX, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            player.field_71135_a.func_147364_a(this.x, this.y, this.z, this.yaw, this.pitch);
            player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187534_aX, SoundCategory.NEUTRAL, 1.0f, 1.0f);
        }
    }

    public static void getNBTTags(HashMap<String, Class> tags) {
        tags.put("tpPosX", Double.class);
        tags.put("tpPosY", Double.class);
        tags.put("tpPosZ", Double.class);
        tags.put("tpRotP", Float.class);
        tags.put("tpRotY", Float.class);
    }

    public Vec3d getPosition() {
        return new Vec3d(this.x, this.y, this.z);
    }

    public Vec2f getYawAndPitch() {
        return new Vec2f(this.yaw, this.pitch);
    }
}

