/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.worldGeneration.structure.util;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.pixelmonmod.pixelmon.util.PixelBlockSnapshot;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class StructureSnapshot {
    private final int width;
    private final int hight;
    private final int lenght;
    private List<NBTTagCompound> statues = Lists.newArrayList();
    private Map<Vec3i, NBTTagCompound> tileEntityData = Maps.newHashMap();
    private BiMap<BlockState, Integer> idToBlock = HashBiMap.create((int)32);
    private int[][][] ids;

    public StructureSnapshot(int width, int hight, int lenght) {
        this.width = width;
        this.hight = hight;
        this.lenght = lenght;
        this.ids = new int[width][hight][lenght];
    }

    public int getWidth() {
        return this.width;
    }

    public int getHight() {
        return this.hight;
    }

    public int getLenght() {
        return this.lenght;
    }

    public PixelBlockSnapshot getBlockAt(int x, int y, int z) {
        int id = this.ids[x][y][z];
        BlockPos pos = new BlockPos(x, y, z);
        BlockState state = (BlockState)this.idToBlock.inverse().get((Object)id);
        NBTTagCompound nbt = this.tileEntityData.getOrDefault(pos, null);
        return new PixelBlockSnapshot(new BlockPos(x, y, z), state.getBlockState(), nbt);
    }

    public List<NBTTagCompound> getStatues() {
        return this.statues;
    }

    public static StructureSnapshot readFromNBT(NBTTagCompound compound) {
        if (compound.func_74771_c("formatVersion") == 0) {
            return StructureSnapshot.loadOldFormat(compound);
        }
        return StructureSnapshot.loadOldFormat(compound);
    }

    private static StructureSnapshot loadOldFormat(NBTTagCompound compound) {
        int width = compound.func_74762_e("Width");
        int height = compound.func_74762_e("Height");
        int length = compound.func_74762_e("Length");
        StructureSnapshot snapshot = new StructureSnapshot(width, height, length);
        int nextId = 1;
        snapshot.idToBlock.put((Object)new BlockState(Blocks.field_150350_a, 0), (Object)0);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                for (int z = 0; z < length; ++z) {
                    int id;
                    NBTTagCompound blockTag = (NBTTagCompound)compound.func_74781_a("X" + x + "Y" + y + "Z" + z);
                    if (blockTag.func_74767_n("hasTE")) {
                        snapshot.tileEntityData.put(new Vec3i(x, y, z), blockTag.func_74775_l("tileEntity"));
                    }
                    String domain = blockTag.func_74764_b("blockMod") ? blockTag.func_74779_i("blockMod") : "minecraft";
                    String resource = blockTag.func_74779_i("blockName");
                    int meta = blockTag.func_74762_e("metadata");
                    Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(domain, resource));
                    if (block == Blocks.field_150350_a) continue;
                    BlockState state = new BlockState(block, meta);
                    if (!snapshot.idToBlock.containsKey((Object)state)) {
                        snapshot.idToBlock.put((Object)state, (Object)nextId++);
                    }
                    snapshot.ids[x][y][z] = id = ((Integer)snapshot.idToBlock.get((Object)state)).intValue();
                }
            }
        }
        int numStatues = compound.func_74762_e("numStatues");
        if (numStatues > 0) {
            float baseX = compound.func_74762_e("baseX");
            float baseY = compound.func_74762_e("baseY");
            float baseZ = compound.func_74762_e("baseZ");
            for (int i = 0; i < numStatues; ++i) {
                NBTTagCompound statue = compound.func_74775_l("statue" + i);
                NBTTagList pos = statue.func_150295_c("Pos", 6);
                double posX = pos.func_150309_d(0);
                double posY = pos.func_150309_d(1);
                double posZ = pos.func_150309_d(2);
                pos.func_150304_a(0, (NBTBase)new NBTTagDouble(posX - (double)baseX));
                pos.func_150304_a(1, (NBTBase)new NBTTagDouble(posY - (double)baseY));
                pos.func_150304_a(2, (NBTBase)new NBTTagDouble(posZ - (double)baseZ));
                snapshot.statues.add(statue);
            }
        }
        return snapshot;
    }

    private static class BlockState {
        Block block;
        int meta;

        public BlockState(Block block, int meta) {
            this.block = block;
            this.meta = meta;
        }

        public BlockState(IBlockState state) {
            this.block = state.func_177230_c();
            this.meta = this.block.func_176201_c(state);
        }

        public IBlockState getBlockState() {
            return this.block.func_176203_a(this.meta);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BlockState state = (BlockState)o;
            return this.meta == state.meta && Objects.equals(this.block, state.block);
        }

        public int hashCode() {
            return Objects.hash(this.block, this.meta);
        }
    }
}

