/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore;

import java.beans.ExceptionListener;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.h2.compress.CompressLZF;
import org.h2.compress.Compressor;
import org.h2.engine.Constants;
import org.h2.mvstore.Chunk;
import org.h2.mvstore.Cursor;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.FreeSpaceBitSet;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVMapConcurrent;
import org.h2.mvstore.Page;
import org.h2.mvstore.cache.CacheLongKeyLIRS;
import org.h2.mvstore.cache.FilePathCache;
import org.h2.mvstore.type.StringDataType;
import org.h2.store.fs.FilePath;
import org.h2.store.fs.FilePathCrypt;
import org.h2.store.fs.FilePathNio;
import org.h2.util.MathUtils;
import org.h2.util.New;

public class MVStore {
    public static final boolean ASSERT = false;
    static final int BLOCK_SIZE = 4096;
    private static final int FORMAT_WRITE = 1;
    private static final int FORMAT_READ = 1;
    volatile Thread backgroundThread;
    private boolean closed;
    private final String fileName;
    private final char[] filePassword;
    private int pageSize = 6144;
    private FileChannel file;
    private FileLock fileLock;
    private long fileSize;
    private long rootChunkStart;
    private final CacheLongKeyLIRS<Page> cache;
    private int lastChunkId;
    private final ConcurrentHashMap<Integer, Chunk> chunks = new ConcurrentHashMap();
    private FreeSpaceBitSet freeSpace = new FreeSpaceBitSet(2, 4096);
    private final HashMap<Long, HashMap<Integer, Chunk>> freedPages = New.hashMap();
    private MVMapConcurrent<String, String> meta;
    private final ConcurrentHashMap<Integer, MVMap<?, ?>> maps = new ConcurrentHashMap();
    private HashMap<String, String> fileHeader = New.hashMap();
    private ByteBuffer writeBuffer;
    private boolean readOnly;
    private int lastMapId;
    private volatile boolean reuseSpace = true;
    private long retainVersion = -1L;
    private final Compressor compressor = new CompressLZF();
    private final boolean compress;
    private long currentVersion;
    private long lastStoredVersion;
    private int fileReadCount;
    private int fileWriteCount;
    private int unsavedPageCount;
    private int maxUnsavedPages;
    private long creationTime;
    private int retentionTime = 45000;
    private long lastStoreTime;
    private long lastCommittedVersion;
    private Chunk retainChunk;
    private volatile long currentStoreVersion = -1L;
    private volatile boolean metaChanged;
    private int writeDelay = 1000;
    private ExceptionListener backgroundExceptionListener;

    MVStore(HashMap<String, Object> hashMap) {
        String string = (String)hashMap.get("fileName");
        if (string != null && string.indexOf(58) < 0) {
            FilePathNio.class.getName();
            string = "nio:" + string;
        }
        this.fileName = string;
        this.readOnly = hashMap.containsKey("readOnly");
        this.compress = hashMap.containsKey("compress");
        if (this.fileName != null) {
            Object object = hashMap.get("cacheSize");
            int n = object == null ? 16 : (Integer)object;
            int n2 = n * 1024 * 1024;
            int n3 = this.pageSize / 2;
            int n4 = 16;
            int n5 = n2 / n3 * 2 / 100;
            this.cache = new CacheLongKeyLIRS(n2, n3, n4, n5);
            this.filePassword = (char[])hashMap.get("encrypt");
            object = hashMap.get("writeBufferSize");
            n = object == null ? 4 : (Integer)object;
            int n6 = n * 1024 * 1024;
            this.maxUnsavedPages = n6 / this.pageSize;
            object = hashMap.get("writeDelay");
            this.writeDelay = object == null ? 1000 : (Integer)object;
        } else {
            this.cache = null;
            this.filePassword = null;
        }
    }

    public static MVStore open(String string) {
        HashMap<String, Object> hashMap = New.hashMap();
        hashMap.put("fileName", string);
        MVStore mVStore = new MVStore(hashMap);
        mVStore.open();
        return mVStore;
    }

    <T extends MVMap<?, ?>> T openMapVersion(long l, int n, MVMap<?, ?> mVMap) {
        MVMap<String, String> mVMap2 = this.getMetaMap(l);
        String string = mVMap2.get("root." + n);
        long l2 = string == null ? 0L : Long.parseLong(string);
        MVMap<?, ?> mVMap3 = mVMap.openReadOnly();
        mVMap3.setRootPos(l2, l);
        return (T)mVMap3;
    }

    public <K, V> MVMap<K, V> openMap(String string) {
        return this.openMap(string, new MVMap.Builder());
    }

    public <M extends MVMap<K, V>, K, V> M openMap(String string, MVMap.MapBuilder<M, K, V> mapBuilder) {
        long l;
        M m;
        int n;
        this.checkOpen();
        String string2 = (String)this.meta.get("name." + string);
        if (string2 != null) {
            n = Integer.parseInt(string2);
            MVMap<?, ?> mVMap = this.maps.get(n);
            if (mVMap != null) {
                return (M)mVMap;
            }
            m = mapBuilder.create();
            String string3 = (String)this.meta.get("map." + string2);
            HashMap<String, String> hashMap = DataUtils.parseMap(string3);
            hashMap.put("id", string2);
            ((MVMap)m).init(this, hashMap);
            String string4 = (String)this.meta.get("root." + n);
            l = string4 == null ? 0L : Long.parseLong(string4);
        } else {
            HashMap<String, String> hashMap = New.hashMap();
            n = ++this.lastMapId;
            hashMap.put("id", Integer.toString(n));
            hashMap.put("createVersion", Long.toString(this.currentVersion));
            m = mapBuilder.create();
            ((MVMap)m).init(this, hashMap);
            this.meta.put("map." + n, ((MVMap)m).asString(string));
            this.meta.put("name." + string, Integer.toString(n));
            this.markMetaChanged();
            l = 0L;
        }
        ((MVMap)m).setRootPos(l, -1L);
        this.maps.put(n, (MVMap<?, ?>)m);
        return m;
    }

    public MVMap<String, String> getMetaMap() {
        this.checkOpen();
        return this.meta;
    }

    private MVMap<String, String> getMetaMap(long l) {
        Chunk chunk = this.getChunkForVersion(l);
        DataUtils.checkArgument(chunk != null, "Unknown version {0}", l);
        chunk = this.readChunkHeader(chunk.start);
        MVMap<String, String> mVMap = this.meta.openReadOnly();
        mVMap.setRootPos(chunk.metaRootPos, l);
        return mVMap;
    }

    private Chunk getChunkForVersion(long l) {
        int n = this.lastChunkId;
        Chunk chunk;
        while ((chunk = this.chunks.get(n)) != null && chunk.version >= l) {
            if (chunk.version == l) {
                return chunk;
            }
            --n;
        }
        return null;
    }

    void removeMap(int n) {
        String string = this.getMapName(n);
        this.markMetaChanged();
        this.meta.remove("map." + n);
        this.meta.remove("name." + string);
        this.meta.remove("root." + n);
        this.maps.remove(n);
    }

    void markChanged(MVMap<?, ?> mVMap) {
        if (mVMap == this.meta) {
            this.metaChanged = true;
        }
    }

    private void markMetaChanged() {
        this.markChanged(this.meta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void open() {
        this.meta = new MVMapConcurrent(StringDataType.INSTANCE, StringDataType.INSTANCE);
        HashMap<String, String> hashMap = New.hashMap();
        hashMap.put("id", "0");
        hashMap.put("createVersion", Long.toString(this.currentVersion));
        this.meta.init(this, hashMap);
        if (this.fileName == null) {
            return;
        }
        FilePath filePath = FilePath.get(this.fileName).getParent();
        if (!filePath.exists()) {
            throw DataUtils.newIllegalArgumentException("Directory does not exist: {0}", filePath);
        }
        try {
            if (this.readOnly) {
                this.openFile();
            } else if (!this.openFile()) {
                this.readOnly = true;
                this.openFile();
            }
        }
        finally {
            if (this.filePassword != null) {
                Arrays.fill(this.filePassword, '\u0000');
            }
        }
        this.lastStoreTime = this.getTime();
        String string = (String)this.meta.get("rollbackOnOpen");
        if (string != null) {
            long l = Long.parseLong(string);
            this.rollbackTo(l);
        }
        this.lastCommittedVersion = this.currentVersion;
        this.setWriteDelay(this.writeDelay);
    }

    private boolean openFile() {
        IllegalStateException illegalStateException;
        try {
            this.log("file open");
            FilePath filePath = FilePath.get(this.fileName);
            if (filePath.exists() && !filePath.canWrite()) {
                this.readOnly = true;
            }
            this.file = filePath.open(this.readOnly ? "r" : "rw");
            if (this.filePassword != null) {
                byte[] byArray = FilePathCrypt.getPasswordBytes(this.filePassword);
                this.file = new FilePathCrypt.FileCrypt(this.fileName, byArray, this.file);
            }
            this.file = FilePathCache.wrap(this.file);
            try {
                this.fileLock = this.readOnly ? this.file.tryLock(0L, Long.MAX_VALUE, true) : this.file.tryLock();
            }
            catch (OverlappingFileLockException overlappingFileLockException) {
                throw DataUtils.newIllegalStateException(7, "The file is locked: {0}", this.fileName, overlappingFileLockException);
            }
            if (this.fileLock == null) {
                throw DataUtils.newIllegalStateException(7, "The file is locked: {0}", this.fileName);
            }
            this.fileSize = this.file.size();
            if (this.fileSize == 0L) {
                this.creationTime = 0L;
                this.lastStoreTime = this.creationTime = this.getTime();
                this.fileHeader.put("H", "3");
                this.fileHeader.put("blockSize", "4096");
                this.fileHeader.put("format", "1");
                this.fileHeader.put("creationTime", "" + this.creationTime);
                this.writeFileHeader();
            } else {
                int n;
                this.readFileHeader();
                int n2 = Integer.parseInt(this.fileHeader.get("format"));
                String string = this.fileHeader.get("formatRead");
                int n3 = n = string == null ? n2 : Integer.parseInt(string);
                if (n > 1) {
                    throw DataUtils.newIllegalStateException(5, "The file format {0} is larger than the supported format {1}", n, 1);
                }
                if (n2 > 1) {
                    this.readOnly = true;
                    this.file.close();
                    return false;
                }
                if (this.rootChunkStart > 0L) {
                    this.readMeta();
                }
            }
            illegalStateException = null;
        }
        catch (IOException iOException) {
            illegalStateException = DataUtils.newIllegalStateException(1, "Could not open file {0}", this.fileName, iOException);
        }
        catch (IllegalStateException illegalStateException2) {
            illegalStateException = illegalStateException2;
        }
        if (illegalStateException != null) {
            try {
                this.closeFile(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw illegalStateException;
        }
        return true;
    }

    private void readMeta() {
        Chunk chunk = this.readChunkHeader(this.rootChunkStart);
        this.lastChunkId = chunk.id;
        this.chunks.put(chunk.id, chunk);
        this.meta.setRootPos(chunk.metaRootPos, -1L);
        for (int i = this.lastChunkId; i >= 0; --i) {
            String object = (String)this.meta.get("chunk." + i);
            if (object == null) continue;
            Chunk chunk2 = Chunk.fromString(object);
            if (chunk2.id == chunk.id) {
                chunk2.start = chunk.start;
                chunk2.length = chunk.length;
                chunk2.metaRootPos = chunk.metaRootPos;
                chunk2.pageCount = chunk.pageCount;
                chunk2.pageCountLive = chunk.pageCountLive;
                chunk2.maxLength = chunk.maxLength;
                chunk2.maxLengthLive = chunk.maxLengthLive;
            }
            this.lastChunkId = Math.max(chunk2.id, this.lastChunkId);
            this.chunks.put(chunk2.id, chunk2);
            if (chunk2.pageCountLive != 0) continue;
            this.registerFreePage(this.currentVersion, chunk2.id, 0L, 0);
        }
        this.freeSpace.clear();
        for (Chunk chunk3 : this.chunks.values()) {
            if (chunk3.start == Long.MAX_VALUE) continue;
            int n = MathUtils.roundUpInt(chunk3.length, 4096) + 4096;
            this.freeSpace.markUsed(chunk3.start, n);
        }
    }

    private void readFileHeader() {
        this.currentVersion = -1L;
        ByteBuffer byteBuffer = ByteBuffer.allocate(12288);
        byteBuffer.limit(4096);
        ++this.fileReadCount;
        DataUtils.readFully(this.file, this.fileSize - 4096L, byteBuffer);
        byteBuffer.limit(12288);
        byteBuffer.position(4096);
        ++this.fileReadCount;
        DataUtils.readFully(this.file, 0L, byteBuffer);
        for (int i = 0; i < 12288; i += 4096) {
            long l;
            int n;
            HashMap<String, String> hashMap;
            String string = new String(byteBuffer.array(), i, 4096, Constants.UTF8).trim();
            try {
                hashMap = DataUtils.parseMap(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
            String string2 = hashMap.remove("fletcher");
            if (string2 == null) continue;
            try {
                n = (int)Long.parseLong(string2, 16);
            }
            catch (NumberFormatException numberFormatException) {
                n = -1;
            }
            string = string.substring(0, string.lastIndexOf("fletcher") - 1);
            byte[] byArray = string.getBytes(Constants.UTF8);
            int n2 = DataUtils.getFletcher32(byArray, byArray.length / 2 * 2);
            if (n != n2 || (l = Long.parseLong(hashMap.get("version"))) <= this.currentVersion) continue;
            this.fileHeader = hashMap;
            this.rootChunkStart = Long.parseLong(hashMap.get("rootChunk"));
            this.creationTime = Long.parseLong(hashMap.get("creationTime"));
            this.currentVersion = l;
            this.lastMapId = Integer.parseInt(hashMap.get("lastMapId"));
        }
        if (this.currentVersion < 0L) {
            throw DataUtils.newIllegalStateException(6, "File header is corrupt: {0}", this.fileName);
        }
        this.lastStoredVersion = -1L;
    }

    private byte[] getFileHeaderBytes() {
        StringBuilder stringBuilder = new StringBuilder();
        this.fileHeader.put("lastMapId", "" + this.lastMapId);
        this.fileHeader.put("rootChunk", "" + this.rootChunkStart);
        this.fileHeader.put("version", "" + this.currentVersion);
        DataUtils.appendMap(stringBuilder, this.fileHeader);
        byte[] byArray = stringBuilder.toString().getBytes(Constants.UTF8);
        int n = DataUtils.getFletcher32(byArray, byArray.length / 2 * 2);
        DataUtils.appendMap(stringBuilder, "fletcher", Integer.toHexString(n));
        byArray = stringBuilder.toString().getBytes(Constants.UTF8);
        if (byArray.length > 4096) {
            throw DataUtils.newIllegalStateException(5, "File header too large: {0}", stringBuilder);
        }
        return byArray;
    }

    private void writeFileHeader() {
        byte[] byArray = this.getFileHeaderBytes();
        ByteBuffer byteBuffer = ByteBuffer.allocate(8192);
        byteBuffer.put(byArray);
        byteBuffer.position(4096);
        byteBuffer.put(byArray);
        byteBuffer.rewind();
        ++this.fileWriteCount;
        DataUtils.writeFully(this.file, 0L, byteBuffer);
        this.fileSize = Math.max(this.fileSize, 8192L);
    }

    public void close() {
        if (this.closed) {
            return;
        }
        if (!this.readOnly && this.hasUnsavedChanges()) {
            this.rollbackTo(this.lastCommittedVersion);
            this.store(false);
        }
        this.closeFile(true);
    }

    public void closeImmediately() {
        this.closeFile(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeFile(boolean bl) {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.file == null) {
            return;
        }
        this.stopBackgroundThread();
        MVStore mVStore = this;
        synchronized (mVStore) {
            try {
                if (bl) {
                    this.shrinkFileIfPossible(0);
                }
                this.log("file close");
                if (this.fileLock != null) {
                    this.fileLock.release();
                    this.fileLock = null;
                }
                this.file.close();
                for (MVMap<?, ?> mVMap : New.arrayList(this.maps.values())) {
                    mVMap.close();
                }
                this.meta = null;
                this.chunks.clear();
                this.freeSpace.clear();
                this.cache.clear();
                this.maps.clear();
            }
            catch (Exception exception) {
                throw DataUtils.newIllegalStateException(2, "Closing failed for file {0}", this.fileName, exception);
            }
            finally {
                this.file = null;
            }
        }
    }

    Chunk getChunk(long l) {
        return this.chunks.get(DataUtils.getPageChunkId(l));
    }

    public long incrementVersion() {
        return ++this.currentVersion;
    }

    public long commit() {
        long l;
        this.lastCommittedVersion = l = ++this.currentVersion;
        if (this.writeDelay == 0) {
            this.store(false);
        }
        return l;
    }

    public long store() {
        this.checkOpen();
        return this.store(false);
    }

    private synchronized long store(boolean bl) {
        Object object5;
        long l;
        Object object2;
        Object object3;
        Object object4;
        Object object6;
        long l2;
        if (this.closed) {
            return this.currentVersion;
        }
        if (this.currentStoreVersion >= 0L) {
            return this.currentVersion;
        }
        if (!this.hasUnsavedChanges()) {
            return this.currentVersion;
        }
        if (this.readOnly) {
            throw DataUtils.newIllegalStateException(2, "This store is read-only", new Object[0]);
        }
        int n = this.unsavedPageCount;
        long l3 = this.currentStoreVersion = this.currentVersion;
        long l4 = this.incrementVersion();
        if (this.file == null) {
            return l4;
        }
        this.lastStoreTime = l2 = this.getTime();
        if (bl) {
            this.meta.put("rollbackOnOpen", Long.toString(this.lastCommittedVersion));
            long l5 = Long.MAX_VALUE;
            object6 = null;
            for (Chunk object52 : this.chunks.values()) {
                if (object52.version >= l5) continue;
                l5 = object52.version;
                object6 = object52;
            }
            this.retainChunk = object6;
        } else {
            this.lastCommittedVersion = l4;
            this.meta.remove("rollbackOnOpen");
            this.retainChunk = null;
        }
        Chunk chunk = this.chunks.get(this.lastChunkId);
        if (chunk != null) {
            this.meta.put("chunk." + chunk.id, chunk.asString());
            l2 = Math.max(chunk.time, l2);
        }
        Chunk chunk2 = new Chunk(++this.lastChunkId);
        chunk2.maxLength = Long.MAX_VALUE;
        chunk2.maxLengthLive = Long.MAX_VALUE;
        chunk2.start = Long.MAX_VALUE;
        chunk2.length = Integer.MAX_VALUE;
        chunk2.time = l2;
        chunk2.version = l4;
        this.chunks.put(chunk2.id, chunk2);
        this.meta.put("chunk." + chunk2.id, chunk2.asString());
        object6 = New.arrayList(this.maps.values());
        ArrayList arrayList = New.arrayList();
        Iterator iterator = ((ArrayList)object6).iterator();
        while (iterator.hasNext()) {
            long l5;
            object4 = (MVMap)iterator.next();
            if (object4 == this.meta || (l5 = ((MVMap)object4).getVersion()) < 0L || ((MVMap)object4).getVersion() < this.lastStoredVersion) continue;
            object3 = ((MVMap)object4).openVersion(l3);
            ((MVMap)object3).waitUntilWritten(((MVMap)object3).getRoot());
            if (((MVMap)object3).getRoot().getPos() != 0L) continue;
            arrayList.add(object3);
        }
        Iterator iterator2 = arrayList.iterator();
        while (iterator2.hasNext()) {
            object4 = (MVMap)iterator2.next();
            object2 = ((MVMap)object4).getRoot();
            if (((Page)object2).getTotalCount() == 0L) {
                this.meta.put("root." + ((MVMap)object4).getId(), "0");
                continue;
            }
            this.meta.put("root." + ((MVMap)object4).getId(), String.valueOf(Integer.MAX_VALUE));
        }
        Set<Chunk> set = this.applyFreedPages(l3, l2);
        if (this.writeBuffer != null) {
            object4 = this.writeBuffer;
            ((ByteBuffer)object4).clear();
        } else {
            object4 = ByteBuffer.allocate(0x100000);
        }
        chunk2.writeHeader((ByteBuffer)object4);
        chunk2.maxLength = 0L;
        chunk2.maxLengthLive = 0L;
        object2 = arrayList.iterator();
        while (object2.hasNext()) {
            MVMap mVMap = (MVMap)object2.next();
            object3 = mVMap.getRoot();
            if (((Page)object3).getTotalCount() <= 0L) continue;
            object4 = ((Page)object3).writeUnsavedRecursive(chunk2, (ByteBuffer)object4);
            long l6 = ((Page)object3).getPos();
            this.meta.put("root." + mVMap.getId(), "" + l6);
        }
        this.meta.put("chunk." + chunk2.id, chunk2.asString());
        object4 = this.meta.getRoot().writeUnsavedRecursive(chunk2, (ByteBuffer)object4);
        int n2 = ((Buffer)object4).position();
        int n3 = MathUtils.roundUpInt(n2, 4096) + 4096;
        if (n3 > ((Buffer)object4).capacity()) {
            object4 = DataUtils.ensureCapacity((ByteBuffer)object4, n3 - ((Buffer)object4).capacity());
        }
        ((ByteBuffer)object4).limit(n3);
        long l7 = this.getFileSizeUsed();
        if (this.reuseSpace) {
            l = this.freeSpace.allocate(n3);
        } else {
            l = l7;
            this.freeSpace.markUsed(l7, n3);
        }
        boolean bl2 = l + (long)n3 >= l7;
        for (Object object5 : set) {
            int n4 = MathUtils.roundUpInt(((Chunk)object5).length, 4096) + 4096;
            this.freeSpace.free(((Chunk)object5).start, n4);
        }
        chunk2.start = l;
        chunk2.length = n2;
        chunk2.metaRootPos = this.meta.getRoot().getPos();
        ((ByteBuffer)object4).position(0);
        chunk2.writeHeader((ByteBuffer)object4);
        this.rootChunkStart = l;
        this.revertTemp(l3);
        ((ByteBuffer)object4).position(((Buffer)object4).limit() - 4096);
        Object object7 = this.getFileHeaderBytes();
        ((ByteBuffer)object4).put((byte[])object7);
        ((ByteBuffer)object4).put(new byte[4096 - ((Object)object7).length]);
        ((ByteBuffer)object4).position(0);
        ++this.fileWriteCount;
        DataUtils.writeFully(this.file, l, (ByteBuffer)object4);
        this.fileSize = Math.max(this.fileSize, l + (long)((Buffer)object4).position());
        if (((Buffer)object4).capacity() <= 0x400000) {
            this.writeBuffer = object4;
        }
        if (!bl2) {
            this.writeFileHeader();
            this.shrinkFileIfPossible(1);
        }
        object5 = arrayList.iterator();
        while (object5.hasNext()) {
            MVMap mVMap = (MVMap)object5.next();
            Page page = mVMap.getRoot();
            if (page.getTotalCount() <= 0L) continue;
            page.writeEnd();
        }
        this.meta.getRoot().writeEnd();
        this.unsavedPageCount = Math.max(0, this.unsavedPageCount - n);
        this.currentStoreVersion = -1L;
        this.metaChanged = false;
        this.lastStoredVersion = l3;
        return l4;
    }

    private boolean canOverwriteChunk(Chunk chunk, long l) {
        if (chunk.time + (long)this.retentionTime > l) {
            return false;
        }
        Chunk chunk2 = this.retainChunk;
        return chunk2 == null || chunk.version <= chunk2.version;
    }

    private long getTime() {
        return System.currentTimeMillis() - this.creationTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Chunk> applyFreedPages(long l, long l2) {
        HashSet<Chunk> hashSet = New.hashSet();
        HashMap<Long, HashMap<Integer, Chunk>> hashMap = this.freedPages;
        synchronized (hashMap) {
            ArrayList<Chunk> arrayList;
            do {
                arrayList = New.arrayList();
                Iterator<Object> iterator = this.freedPages.keySet().iterator();
                while (iterator.hasNext()) {
                    long l3 = iterator.next();
                    if (l3 > l) continue;
                    Map map = this.freedPages.get(l3);
                    for (Chunk chunk : map.values()) {
                        Chunk chunk2 = this.chunks.get(chunk.id);
                        chunk2.maxLengthLive += chunk.maxLengthLive;
                        chunk2.pageCountLive += chunk.pageCountLive;
                        if (chunk2.pageCountLive < 0) {
                            throw DataUtils.newIllegalStateException(3, "Corrupt page count {0}", chunk2.pageCountLive);
                        }
                        if (chunk2.maxLengthLive < 0L) {
                            throw DataUtils.newIllegalStateException(3, "Corrupt max length {0}", chunk2.maxLengthLive);
                        }
                        if (chunk2.pageCount == 0 && chunk2.maxLengthLive > 0L) {
                            throw DataUtils.newIllegalStateException(3, "Corrupt max length {0}", chunk2.maxLengthLive);
                        }
                        arrayList.add(chunk2);
                    }
                    iterator.remove();
                }
                for (Chunk chunk : arrayList) {
                    if (chunk.maxLengthLive == 0L) {
                        if (this.canOverwriteChunk(chunk, l2)) {
                            hashSet.add(chunk);
                            this.chunks.remove(chunk.id);
                            this.meta.remove("chunk." + chunk.id);
                            continue;
                        }
                        this.registerFreePage(l + 1L, chunk.id, 0L, 0);
                        continue;
                    }
                    this.meta.put("chunk." + chunk.id, chunk.asString());
                }
            } while (arrayList.size() != 0);
        }
        return hashSet;
    }

    private void shrinkFileIfPossible(int n) {
        long l = this.getFileSizeUsed();
        if (l >= this.fileSize) {
            return;
        }
        if (n > 0 && this.fileSize - l < 4096L) {
            return;
        }
        int n2 = (int)(100L - l * 100L / this.fileSize);
        if (n2 < n) {
            return;
        }
        try {
            this.file.truncate(l);
        }
        catch (IOException iOException) {
            throw DataUtils.newIllegalStateException(2, "Could not truncate file {0} to size {1}", this.fileName, l, iOException);
        }
        this.fileSize = l;
    }

    private long getFileSizeUsed() {
        long l = 8192L;
        for (Chunk chunk : this.chunks.values()) {
            if (chunk.start == Long.MAX_VALUE) continue;
            long l2 = chunk.start + (long)chunk.length;
            l = Math.max(l, MathUtils.roundUpLong(l2, 4096L) + 4096L);
        }
        return l;
    }

    public boolean hasUnsavedChanges() {
        this.checkOpen();
        if (this.metaChanged) {
            return true;
        }
        for (MVMap<?, ?> mVMap : this.maps.values()) {
            long l;
            if (mVMap.isClosed() || (l = mVMap.getVersion()) < 0L || l < this.lastStoredVersion) continue;
            return true;
        }
        return false;
    }

    private Chunk readChunkHeader(long l) {
        ++this.fileReadCount;
        ByteBuffer byteBuffer = ByteBuffer.allocate(40);
        DataUtils.readFully(this.file, l, byteBuffer);
        byteBuffer.rewind();
        return Chunk.fromHeader(byteBuffer, l);
    }

    public boolean compact(int n) {
        int n2;
        this.checkOpen();
        if (this.chunks.size() == 0) {
            return false;
        }
        long l = 0L;
        long l2 = 0L;
        for (Chunk chunk : this.chunks.values()) {
            l += chunk.maxLength;
            l2 += chunk.maxLengthLive;
        }
        if (l <= 0L) {
            l = 1L;
        }
        if ((n2 = (int)(100L * l2 / l)) > n) {
            return false;
        }
        int n3 = (int)(l / (long)this.chunks.size());
        long l3 = this.getTime();
        ArrayList<Chunk> arrayList = New.arrayList();
        for (Chunk chunk : this.chunks.values()) {
            if (!this.canOverwriteChunk(chunk, l3)) continue;
            int n4 = this.lastChunkId - chunk.id + 1;
            chunk.collectPriority = chunk.getFillRate() / n4;
            arrayList.add(chunk);
        }
        if (arrayList.size() == 0) {
            return false;
        }
        Collections.sort(arrayList, new Comparator<Chunk>(){

            @Override
            public int compare(Chunk chunk, Chunk chunk2) {
                return new Integer(chunk.collectPriority).compareTo(chunk2.collectPriority);
            }
        });
        long l4 = 0L;
        Chunk iterator2 = null;
        for (Chunk iterator3 : arrayList) {
            if (iterator2 != null && l4 + iterator3.maxLengthLive > (long)n3) break;
            this.log(" chunk " + iterator3.id + " " + iterator3.getFillRate() + "% full; prio=" + iterator3.collectPriority);
            l4 += iterator3.maxLengthLive;
            iterator2 = iterator3;
        }
        boolean bl = false;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Chunk chunk = (Chunk)iterator.next();
            if (iterator2 == chunk) {
                bl = true;
                continue;
            }
            if (!bl) continue;
            iterator.remove();
        }
        for (Chunk chunk : arrayList) {
            this.copyLive(chunk, arrayList);
        }
        this.store();
        return true;
    }

    private void copyLive(Chunk chunk, ArrayList<Chunk> arrayList) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(chunk.length);
        DataUtils.readFully(this.file, chunk.start, byteBuffer);
        Chunk.fromHeader(byteBuffer, chunk.start);
        int n = chunk.length;
        this.markMetaChanged();
        while (byteBuffer.position() < n) {
            int n2 = byteBuffer.position();
            int n3 = byteBuffer.getInt();
            byteBuffer.getShort();
            int n4 = DataUtils.readVarInt(byteBuffer);
            MVMap<?, ?> mVMap = this.getMap(n4);
            if (mVMap == null) {
                byteBuffer.position(n2 + n3);
                continue;
            }
            byteBuffer.position(n2);
            Page page = new Page(mVMap, 0L);
            page.read(byteBuffer, chunk.id, byteBuffer.position(), chunk.length);
            for (int i = 0; i < page.getKeyCount(); ++i) {
                Chunk chunk2;
                Object object = page.getKey(i);
                Page page2 = mVMap.getPage(object);
                if (page2 == null || page2.getPos() < 0L || !arrayList.contains(chunk2 = this.getChunk(page2.getPos()))) continue;
                this.log("       move key:" + object + " chunk:" + chunk2.id);
                Object obj = mVMap.remove(object);
                mVMap.put(object, obj);
            }
        }
    }

    private MVMap<?, ?> getMap(int n) {
        if (n == 0) {
            return this.meta;
        }
        return this.maps.get(n);
    }

    Page readPage(MVMap<?, ?> mVMap, long l) {
        Page page = this.cache.get(l);
        if (page == null) {
            Chunk chunk = this.getChunk(l);
            if (chunk == null) {
                throw DataUtils.newIllegalStateException(6, "Chunk {0} not found", DataUtils.getPageChunkId(l));
            }
            long l2 = chunk.start;
            ++this.fileReadCount;
            page = Page.read(this.file, mVMap, l, l2 += (long)DataUtils.getPageOffset(l), this.fileSize);
            this.cache.put(l, page, page.getMemory());
        }
        return page;
    }

    void removePage(MVMap<?, ?> mVMap, long l) {
        if (l == 0L) {
            this.unsavedPageCount = Math.max(0, this.unsavedPageCount - 1);
            return;
        }
        this.cache.remove(l);
        Chunk chunk = this.getChunk(l);
        long l2 = this.currentVersion;
        if (mVMap == this.meta && this.currentStoreVersion >= 0L) {
            l2 = this.currentStoreVersion;
        }
        this.registerFreePage(l2, chunk.id, DataUtils.getPageMaxLength(l), 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerFreePage(long l, int n, long l2, int n2) {
        HashMap<Long, HashMap<Integer, Chunk>> hashMap = this.freedPages;
        synchronized (hashMap) {
            Chunk chunk;
            HashMap<Integer, Chunk> hashMap2 = this.freedPages.get(l);
            if (hashMap2 == null) {
                hashMap2 = New.hashMap();
                this.freedPages.put(l, hashMap2);
            }
            if ((chunk = hashMap2.get(n)) == null) {
                chunk = new Chunk(n);
                hashMap2.put(n, chunk);
            }
            chunk.maxLengthLive -= l2;
            chunk.pageCountLive -= n2;
        }
    }

    void log(String string) {
    }

    public void setPageSize(int n) {
        this.pageSize = n;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    Compressor getCompressor() {
        return this.compressor;
    }

    boolean getCompress() {
        return this.compress;
    }

    public boolean getReuseSpace() {
        return this.reuseSpace;
    }

    public void setReuseSpace(boolean bl) {
        this.reuseSpace = bl;
    }

    public int getRetentionTime() {
        return this.retentionTime;
    }

    public void setRetentionTime(int n) {
        this.retentionTime = n;
    }

    public void setRetainVersion(long l) {
        this.retainVersion = l;
    }

    public long getRetainVersion() {
        long l = this.retainVersion;
        if (this.currentStoreVersion >= -1L) {
            l = Math.min(l, this.currentStoreVersion);
        }
        return l;
    }

    public void setBackgroundExceptionListener(ExceptionListener exceptionListener) {
        this.backgroundExceptionListener = exceptionListener;
    }

    public ExceptionListener getBackgroundExceptionListener() {
        return this.backgroundExceptionListener;
    }

    private boolean isKnownVersion(long l) {
        String string;
        if (l > this.currentVersion || l < 0L) {
            return false;
        }
        if (l == this.currentVersion || this.chunks.size() == 0) {
            return true;
        }
        Chunk chunk = this.getChunkForVersion(l);
        if (chunk == null) {
            return false;
        }
        MVMap<String, String> mVMap = this.getMetaMap(l);
        if (mVMap == null) {
            return false;
        }
        Cursor<String> cursor = mVMap.keyIterator("chunk.");
        while (cursor.hasNext() && (string = (String)cursor.next()).startsWith("chunk.")) {
            if (this.meta.containsKey(string)) continue;
            return false;
        }
        return true;
    }

    public int getUnsavedPageCount() {
        return this.unsavedPageCount;
    }

    void registerUnsavedPage() {
        ++this.unsavedPageCount;
    }

    void beforeWrite() {
        if (this.currentStoreVersion >= 0L) {
            return;
        }
        if (this.unsavedPageCount > this.maxUnsavedPages && this.maxUnsavedPages > 0) {
            this.store(true);
        }
    }

    public int getStoreVersion() {
        this.checkOpen();
        String string = (String)this.meta.get("setting.storeVersion");
        return string == null ? 0 : Integer.parseInt(string);
    }

    public void setStoreVersion(int n) {
        this.checkOpen();
        this.markMetaChanged();
        this.meta.put("setting.storeVersion", Integer.toString(n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void rollbackTo(long l) {
        this.checkOpen();
        if (l == 0L) {
            for (MVMap<?, ?> mVMap : this.maps.values()) {
                mVMap.close();
            }
            this.meta.clear();
            this.chunks.clear();
            this.freeSpace.clear();
            this.maps.clear();
            HashMap<Long, HashMap<Integer, Chunk>> hashMap = this.freedPages;
            synchronized (hashMap) {
                this.freedPages.clear();
            }
            this.currentVersion = l;
            this.metaChanged = false;
            return;
        }
        DataUtils.checkArgument(this.isKnownVersion(l), "Unknown version {0}", l);
        for (MVMap<?, ?> object2 : this.maps.values()) {
            object2.rollbackTo(l);
        }
        HashMap<Long, HashMap<Integer, Chunk>> hashMap = this.freedPages;
        synchronized (hashMap) {
            for (long i = this.currentVersion; i >= l && this.freedPages.size() != 0; --i) {
                this.freedPages.remove(i);
            }
        }
        this.meta.rollbackTo(l);
        this.metaChanged = false;
        boolean bl = false;
        Chunk chunk = this.chunks.get(this.lastChunkId);
        if (chunk != null && chunk.version >= l) {
            Chunk chunk2;
            this.revertTemp(l);
            bl = true;
            do {
                chunk2 = this.chunks.remove(this.lastChunkId);
                int n = MathUtils.roundUpInt(chunk2.length, 4096) + 4096;
                this.freeSpace.free(chunk2.start, n);
                --this.lastChunkId;
            } while (chunk2.version > l && this.chunks.size() > 0);
            this.rootChunkStart = chunk2.start;
            this.writeFileHeader();
            Object object = this.getFileHeaderBytes();
            ByteBuffer byteBuffer = ByteBuffer.allocate(4096);
            byteBuffer.put((byte[])object);
            byteBuffer.rewind();
            ++this.fileWriteCount;
            DataUtils.writeFully(this.file, this.fileSize, byteBuffer);
            this.fileSize += 4096L;
            this.readFileHeader();
            this.readMeta();
        }
        for (MVMap<?, ?> mVMap : New.arrayList(this.maps.values())) {
            int n = mVMap.getId();
            if (mVMap.getCreateVersion() >= l) {
                mVMap.close();
                this.maps.remove(n);
                continue;
            }
            if (!bl) continue;
            String string = (String)this.meta.get("root." + n);
            long l2 = string == null ? 0L : Long.parseLong(string);
            mVMap.setRootPos(l2, -1L);
        }
        this.currentVersion = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void revertTemp(long l) {
        HashMap<Long, HashMap<Integer, Chunk>> hashMap = this.freedPages;
        synchronized (hashMap) {
            Iterator<Long> object = this.freedPages.keySet().iterator();
            while (object.hasNext()) {
                long l2 = object.next();
                if (l2 > l) continue;
                object.remove();
            }
        }
        for (MVMap mVMap : this.maps.values()) {
            mVMap.removeUnusedOldVersions();
        }
    }

    public long getCurrentVersion() {
        return this.currentVersion;
    }

    public long getCommittedVersion() {
        return this.lastCommittedVersion;
    }

    public int getFileWriteCount() {
        return this.fileWriteCount;
    }

    public int getFileReadCount() {
        return this.fileReadCount;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Map<String, String> getFileHeader() {
        return this.fileHeader;
    }

    public FileChannel getFile() {
        this.checkOpen();
        return this.file;
    }

    private void checkOpen() {
        if (this.closed) {
            throw DataUtils.newIllegalStateException(4, "This store is closed", new Object[0]);
        }
    }

    void renameMap(MVMap<?, ?> mVMap, String string) {
        this.checkOpen();
        DataUtils.checkArgument(mVMap != this.meta, "Renaming the meta map is not allowed", new Object[0]);
        if (mVMap.getName().equals(string)) {
            return;
        }
        DataUtils.checkArgument(!this.meta.containsKey("name." + string), "A map named {0} already exists", string);
        int n = mVMap.getId();
        String string2 = this.getMapName(n);
        this.markMetaChanged();
        this.meta.remove("map." + n);
        this.meta.remove("name." + string2);
        this.meta.put("map." + n, mVMap.asString(string));
        this.meta.put("name." + string, Integer.toString(n));
    }

    String getMapName(int n) {
        String string = (String)this.meta.get("map." + n);
        return DataUtils.parseMap(string).get("name");
    }

    void storeInBackground() {
        block5: {
            if (this.closed || this.unsavedPageCount == 0) {
                return;
            }
            if (this.lastCommittedVersion >= this.currentVersion) {
                return;
            }
            long l = this.getTime();
            if (l <= this.lastStoreTime + (long)this.writeDelay) {
                return;
            }
            try {
                this.store(true);
            }
            catch (Exception exception) {
                if (this.backgroundExceptionListener == null) break block5;
                this.backgroundExceptionListener.exceptionThrown(exception);
            }
        }
    }

    public void setCacheSize(long l) {
        if (this.cache != null) {
            this.cache.setMaxMemory(l * 1024L * 1024L);
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopBackgroundThread() {
        if (this.backgroundThread == null) {
            return;
        }
        Thread thread = this.backgroundThread;
        this.backgroundThread = null;
        MVStore mVStore = this;
        synchronized (mVStore) {
            this.notify();
        }
        try {
            thread.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setWriteDelay(int n) {
        this.writeDelay = n;
        this.stopBackgroundThread();
        if (n > 0) {
            int n2 = Math.max(1, n / 10);
            Writer writer = new Writer(this, n2);
            Thread thread = new Thread((Runnable)writer, "MVStore writer " + this.fileName);
            thread.setDaemon(true);
            thread.start();
            this.backgroundThread = thread;
        }
    }

    public int getWriteDelay() {
        return this.writeDelay;
    }

    public static class Builder {
        private final HashMap<String, Object> config = New.hashMap();

        private Builder set(String string, Object object) {
            this.config.put(string, object);
            return this;
        }

        public Builder fileName(String string) {
            return this.set("fileName", string);
        }

        public Builder encryptionKey(char[] cArray) {
            return this.set("encrypt", cArray);
        }

        public Builder readOnly() {
            return this.set("readOnly", 1);
        }

        public Builder cacheSize(int n) {
            return this.set("cacheSize", n);
        }

        public Builder compressData() {
            return this.set("compress", 1);
        }

        public Builder writeBufferSize(int n) {
            return this.set("writeBufferSize", n);
        }

        public Builder writeDelay(int n) {
            return this.set("writeDelay", n);
        }

        public MVStore open() {
            MVStore mVStore = new MVStore(this.config);
            mVStore.open();
            return mVStore;
        }

        public String toString() {
            return DataUtils.appendMap(new StringBuilder(), this.config).toString();
        }

        public static Builder fromString(String string) {
            HashMap<String, String> hashMap = DataUtils.parseMap(string);
            Builder builder = new Builder();
            builder.config.putAll(hashMap);
            return builder;
        }
    }

    private static class Writer
    implements Runnable {
        private final MVStore store;
        private final int sleep;

        Writer(MVStore mVStore, int n) {
            this.store = mVStore;
            this.sleep = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.store.backgroundThread != null) {
                MVStore mVStore = this.store;
                synchronized (mVStore) {
                    try {
                        this.store.wait(this.sleep);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.store.storeInBackground();
            }
        }
    }
}

