/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.vanillafix;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Scanner;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.Logger;
import org.dimdev.vanillafix.ModConfig;

@Mod(modid="vanillafix", name="VanillaFix", acceptableRemoteVersions="*", updateJSON="https://gist.githubusercontent.com/Runemoro/28e8cf4c24a5f17f508a5d34f66d229f/raw/vanillafix_update.json")
public class VanillaFix {
    private static final int CONFIG_VERSION = 1;
    private static final boolean DEBUG_BLOCK_IDS = false;
    private static final boolean DEBUG_ITEM_IDS = false;
    private static final boolean DEBUG_INIT_ERROR = false;

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent event) {
        boolean configOutdated;
        File configVersionFile;
        Logger log;
        block45: {
            log = event.getModLog();
            File modDir = new File(event.getModConfigurationDirectory(), "vanillafix");
            modDir.mkdirs();
            configVersionFile = new File(modDir, "config_version");
            if (configVersionFile.exists()) {
                try (FileReader reader = new FileReader(configVersionFile);
                     Scanner scanner = new Scanner(reader);){
                    try {
                        configOutdated = scanner.nextInt() != 1;
                    }
                    catch (NumberFormatException e) {
                        configOutdated = true;
                    }
                    break block45;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            configOutdated = true;
        }
        if (configOutdated) {
            File configFile = new File(event.getModConfigurationDirectory(), "vanillafix.cfg");
            if (configFile.exists()) {
                log.info("Regenerating outdated config");
                configFile.delete();
            }
            try (FileWriter writer = new FileWriter(configVersionFile);){
                writer.write(String.valueOf(1));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        ConfigManager.sync((String)"vanillafix", (Config.Type)Config.Type.INSTANCE);
        MinecraftForge.EVENT_BUS.register(ModConfig.class);
        IForgeRegistry blockRegistry = GameRegistry.findRegistry(Block.class);
        IForgeRegistry itemRegistry = GameRegistry.findRegistry(Item.class);
    }
}

