/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.vanillafix;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dimdev.utils.SSLUtils;
import org.dimdev.vanillafix.LoadingConfig;
import org.dimdev.vanillafix.crashes.DeobfuscatingRewritePolicy;
import org.dimdev.vanillafix.crashes.StacktraceDeobfuscator;
import org.spongepowered.asm.launch.MixinBootstrap;
import org.spongepowered.asm.mixin.Mixins;

@IFMLLoadingPlugin.MCVersion(value="1.12.2")
@IFMLLoadingPlugin.SortingIndex(value=-100000)
public class VanillaFixLoadingPlugin
implements IFMLLoadingPlugin {
    private static final Logger log = LogManager.getLogger();
    private static final String MCP_VERSION = "20180618-1.12";
    private static boolean initialized = false;
    public static LoadingConfig config;

    public VanillaFixLoadingPlugin() {
        VanillaFixLoadingPlugin.initialize();
        MixinBootstrap.init();
        if (VanillaFixLoadingPlugin.config.bugFixes) {
            Mixins.addConfiguration("mixins.vanillafix.bugs.json");
        }
        if (VanillaFixLoadingPlugin.config.crashFixes) {
            Mixins.addConfiguration("mixins.vanillafix.crashes.json");
        }
        if (VanillaFixLoadingPlugin.config.profiler) {
            Mixins.addConfiguration("mixins.vanillafix.profiler.json");
        }
        if (VanillaFixLoadingPlugin.config.textureFixes) {
            Mixins.addConfiguration("mixins.vanillafix.textures.json");
        }
        if (VanillaFixLoadingPlugin.config.modSupport) {
            Mixins.addConfiguration("mixins.vanillafix.modsupport.json");
        }
    }

    public static void initialize() {
        if (initialized) {
            return;
        }
        initialized = true;
        config = new LoadingConfig();
        config.init(new File(Launch.minecraftHome, "config/vanillafix.cfg"));
        try (InputStream keyStoreInputStream = VanillaFixLoadingPlugin.class.getResourceAsStream("/dst_root_ca_x3.jks");){
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(keyStoreInputStream, "password".toCharArray());
            SSLUtils.trustCertificates(keyStore);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new RuntimeException();
        }
        File modDir = new File(Launch.minecraftHome, "config/vanillafix");
        modDir.mkdirs();
        log.info("Initializing StacktraceDeobfuscator");
        try {
            File mappings = new File(modDir, "methods-20180618-1.12.csv");
            if (mappings.exists()) {
                log.info("Found MCP method mappings: " + mappings.getName());
            } else {
                log.info("Downloading MCP method mappings to: " + mappings.getName());
            }
            StacktraceDeobfuscator.init(mappings, MCP_VERSION);
        }
        catch (Exception e) {
            log.error("Failed to get MCP data!", (Throwable)e);
        }
        log.info("Done initializing StacktraceDeobfuscator");
        DeobfuscatingRewritePolicy.install();
    }

    public String[] getASMTransformerClass() {
        return new String[0];
    }

    public String getModContainerClass() {
        return null;
    }

    @Nullable
    public String getSetupClass() {
        return null;
    }

    public void injectData(Map<String, Object> data) {
    }

    public String getAccessTransformerClass() {
        return null;
    }
}

