/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.vanillafix.crashes;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public final class StacktraceDeobfuscator {
    private static final boolean DEBUG_IN_DEV = false;
    private static HashMap<String, String> srgMcpMethodMap = null;

    public static void init(File mappings, String version) {
        if (srgMcpMethodMap != null) {
            return;
        }
        if (!mappings.exists()) {
            HttpURLConnection connection = null;
            try {
                URL mappingsURL = new URL("http://export.mcpbot.bspk.rs/mcp_snapshot_nodoc/" + version + "/mcp_snapshot_nodoc-" + version + ".zip");
                connection = (HttpURLConnection)mappingsURL.openConnection();
                connection.setDoInput(true);
                connection.connect();
                try (InputStream inputStream = connection.getInputStream();){
                    ZipEntry entry;
                    ZipInputStream zipInputStream = new ZipInputStream(inputStream);
                    while ((entry = zipInputStream.getNextEntry()) != null) {
                        if (!entry.getName().equals("methods.csv")) continue;
                        try (FileOutputStream out = new FileOutputStream(mappings);){
                            int len;
                            byte[] buffer = new byte[2048];
                            while ((len = zipInputStream.read(buffer)) > 0) {
                                out.write(buffer, 0, len);
                            }
                            break;
                        }
                    }
                    if (entry == null) {
                        throw new RuntimeException("Downloaded zip did not contain methods.csv");
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
        }
        HashMap<String, String> srgMcpMethodMap = new HashMap<String, String>();
        try (Scanner scanner = new Scanner(mappings);){
            scanner.nextLine();
            while (scanner.hasNext()) {
                String mappingLine = scanner.nextLine();
                int commaIndex = mappingLine.indexOf(44);
                String srgName = mappingLine.substring(0, commaIndex);
                String mcpName = mappingLine.substring(commaIndex + 1, commaIndex + 1 + mappingLine.substring(commaIndex + 1).indexOf(44));
                srgMcpMethodMap.put(srgName, mcpName);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        StacktraceDeobfuscator.srgMcpMethodMap = srgMcpMethodMap;
    }

    public static void deobfuscateThrowable(Throwable t) {
        ArrayDeque<Throwable> queue = new ArrayDeque<Throwable>();
        queue.add(t);
        while (!queue.isEmpty()) {
            t = (Throwable)queue.remove();
            t.setStackTrace(StacktraceDeobfuscator.deobfuscateStacktrace(t.getStackTrace()));
            if (t.getCause() != null) {
                queue.add(t.getCause());
            }
            Collections.addAll(queue, t.getSuppressed());
        }
    }

    public static StackTraceElement[] deobfuscateStacktrace(StackTraceElement[] stackTrace) {
        int index = 0;
        for (StackTraceElement el : stackTrace) {
            stackTrace[index++] = new StackTraceElement(el.getClassName(), StacktraceDeobfuscator.deobfuscateMethodName(el.getMethodName()), el.getFileName(), el.getLineNumber());
        }
        return stackTrace;
    }

    public static String deobfuscateMethodName(String srgName) {
        if (srgMcpMethodMap == null) {
            return srgName;
        }
        String mcpName = srgMcpMethodMap.get(srgName);
        return mcpName != null ? mcpName : srgName;
    }

    public static void main(String[] args) {
        StacktraceDeobfuscator.init(new File("methods.csv"), "20180519-1.12");
        for (Map.Entry<String, String> entry : srgMcpMethodMap.entrySet()) {
            System.out.println(entry.getKey() + " <=> " + entry.getValue());
        }
    }
}

