/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.vanillafix.crashes.mixins.client;

import com.google.common.util.concurrent.ListenableFutureTask;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.FutureTask;
import javax.annotation.Nullable;
import net.minecraft.client.LoadingScreenRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.toasts.GuiToast;
import net.minecraft.client.gui.toasts.IToast;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.FileResourcePack;
import net.minecraft.client.resources.FolderResourcePack;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.LanguageManager;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.client.resources.data.MetadataSerializer;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.crash.CrashReport;
import net.minecraft.profiler.ISnooperInfo;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.MinecraftError;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.client.SplashProgress;
import org.apache.logging.log4j.Logger;
import org.dimdev.utils.GlUtil;
import org.dimdev.vanillafix.ModConfig;
import org.dimdev.vanillafix.VanillaFix;
import org.dimdev.vanillafix.VanillaFixLoadingPlugin;
import org.dimdev.vanillafix.crashes.CrashUtils;
import org.dimdev.vanillafix.crashes.GuiCrashScreen;
import org.dimdev.vanillafix.crashes.GuiInitErrorScreen;
import org.dimdev.vanillafix.crashes.GuiWarningScreen;
import org.dimdev.vanillafix.crashes.IPatchedMinecraft;
import org.dimdev.vanillafix.crashes.ProblemToast;
import org.dimdev.vanillafix.crashes.StateManager;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class})
public abstract class MixinMinecraft
implements IThreadListener,
ISnooperInfo,
IPatchedMinecraft {
    @Shadow
    @Final
    private static Logger field_147123_G;
    @Shadow
    volatile boolean field_71425_J;
    @Shadow
    private boolean field_71434_R;
    @Shadow
    private CrashReport field_71433_S;
    @Shadow
    private long field_83002_am;
    @Shadow
    public static byte[] field_71444_a;
    @Shadow
    public RenderGlobal field_71438_f;
    @Shadow
    public GameSettings field_71474_y;
    @Shadow
    public GuiIngame field_71456_v;
    @Shadow
    public EntityRenderer field_71460_t;
    @Shadow
    @Final
    private Queue<FutureTask<?>> field_152351_aB;
    @Shadow
    private boolean field_184129_aV;
    @Shadow
    @Nullable
    private IntegratedServer field_71437_Z;
    @Shadow
    private boolean field_71455_al;
    @Shadow
    @Nullable
    public GuiScreen field_71462_r;
    @Shadow
    public int field_71443_c;
    @Shadow
    public int field_71440_d;
    @Shadow
    public TextureManager field_71446_o;
    @Shadow
    public FontRenderer field_71466_p;
    @Shadow
    private int field_71429_W;
    @Shadow
    private Framebuffer field_147124_at;
    @Shadow
    private IReloadableResourceManager field_110451_am;
    @Shadow
    private SoundHandler field_147127_av;
    @Shadow
    @Final
    private List<IResourcePack> field_110449_ao;
    @Shadow
    private LanguageManager field_135017_as;
    @Shadow
    @Final
    private MetadataSerializer field_110452_an;
    @Shadow
    public LoadingScreenRenderer field_71461_s;
    private boolean crashIntegratedServerNextTick;
    private int clientCrashCount = 0;
    private int serverCrashCount = 0;

    @Shadow
    private void func_71384_a() throws LWJGLException, IOException {
    }

    @Shadow
    private void func_71411_J() throws IOException {
    }

    @Shadow
    public void func_147108_a(@Nullable GuiScreen guiScreenIn) {
    }

    @Shadow
    public CrashReport func_71396_d(CrashReport theCrash) {
        return null;
    }

    @Shadow
    public void func_71405_e() {
    }

    @Shadow
    @Nullable
    public abstract NetHandlerPlayClient func_147114_u();

    @Shadow
    public static long func_71386_F() {
        return 0L;
    }

    @Shadow
    public abstract void func_71403_a(@Nullable WorldClient var1);

    @Shadow
    public abstract GuiToast func_193033_an();

    @Shadow
    protected abstract void func_175609_am() throws LWJGLException;

    @Shadow
    public abstract void func_110436_a();

    @Shadow
    public abstract TextureManager func_110434_K();

    @Shadow
    public abstract void func_175601_h();

    @Shadow
    protected abstract void func_71361_d(String var1);

    @Overwrite
    public void func_99999_d() {
        this.field_71425_J = true;
        try {
            this.func_71384_a();
        }
        catch (Throwable throwable) {
            CrashReport report = CrashReport.func_85055_a((Throwable)throwable, (String)"Initializing game");
            this.displayInitErrorScreen(this.func_71396_d(report));
            return;
        }
        try {
            while (this.field_71425_J) {
                if (!this.field_71434_R || this.field_71433_S == null) {
                    try {
                        this.func_71411_J();
                    }
                    catch (ReportedException e) {
                        ++this.clientCrashCount;
                        this.func_71396_d(e.func_71575_a());
                        this.addInfoToCrash(e.func_71575_a());
                        this.resetGameState();
                        field_147123_G.fatal("Reported exception thrown!", (Throwable)e);
                        this.displayCrashScreen(e.func_71575_a());
                    }
                    catch (Throwable e) {
                        ++this.clientCrashCount;
                        CrashReport report = new CrashReport("Unexpected error", e);
                        this.func_71396_d(report);
                        this.addInfoToCrash(report);
                        this.resetGameState();
                        field_147123_G.fatal("Unreported exception thrown!", e);
                        this.displayCrashScreen(report);
                    }
                    continue;
                }
                ++this.serverCrashCount;
                this.addInfoToCrash(this.field_71433_S);
                this.func_71398_f();
                this.displayCrashScreen(this.field_71433_S);
                this.field_71434_R = false;
                this.field_71433_S = null;
            }
        }
        catch (MinecraftError minecraftError) {
        }
        finally {
            this.func_71405_e();
        }
    }

    public void addInfoToCrash(CrashReport report) {
        report.func_85056_g().func_189529_a("Client Crashes Since Restart", () -> String.valueOf(this.clientCrashCount));
        report.func_85056_g().func_189529_a("Integrated Server Crashes Since Restart", () -> String.valueOf(this.serverCrashCount));
    }

    public void displayInitErrorScreen(CrashReport report) {
        CrashUtils.outputReport(report);
        try {
            VanillaFixLoadingPlugin.initialize();
            try {
                File modFile;
                URL url = VanillaFix.class.getProtectionDomain().getCodeSource().getLocation();
                if (url.getProtocol().equals("jar")) {
                    url = new URL(url.getFile().substring(0, url.getFile().indexOf(33)));
                }
                this.field_110449_ao.add((IResourcePack)((modFile = new File(url.toURI())).isDirectory() ? new FolderResourcePack(modFile) : new FileResourcePack(modFile)));
            }
            catch (Throwable t) {
                field_147123_G.error("Failed to load VanillaFix resource pack", t);
            }
            this.field_110451_am = new SimpleReloadableResourceManager(this.field_110452_an);
            this.field_71446_o = new TextureManager((IResourceManager)this.field_110451_am);
            this.field_110451_am.func_110542_a((IResourceManagerReloadListener)this.field_71446_o);
            this.field_135017_as = new LanguageManager(this.field_110452_an, this.field_71474_y.field_74363_ab);
            this.field_110451_am.func_110542_a((IResourceManagerReloadListener)this.field_135017_as);
            this.func_110436_a();
            this.field_71466_p = new FontRenderer(this.field_71474_y, new ResourceLocation("textures/font/ascii.png"), this.field_71446_o, false);
            this.field_110451_am.func_110542_a((IResourceManagerReloadListener)this.field_71466_p);
            this.field_147127_av = new SoundHandler((IResourceManager)this.field_110451_am, this.field_71474_y);
            this.field_110451_am.func_110542_a((IResourceManagerReloadListener)this.field_147127_av);
            this.field_71425_J = true;
            try {
                SplashProgress.pause();
            }
            catch (Throwable t) {
                // empty catch block
            }
            this.runGUILoop(new GuiInitErrorScreen(report));
        }
        catch (Throwable t) {
            field_147123_G.error("An uncaught exception occured while displaying the init error screen, making normal report instead", t);
            this.func_71377_b(report);
            System.exit(report.func_71497_f() != null ? -1 : -2);
        }
    }

    private void runGUILoop(GuiScreen screen) throws IOException {
        this.func_147108_a(screen);
        while (this.field_71425_J && this.field_71462_r != null && !(this.field_71462_r instanceof GuiMainMenu)) {
            if (Display.isCreated() && Display.isCloseRequested()) {
                System.exit(0);
            }
            this.field_71429_W = 10000;
            this.field_71462_r.func_146269_k();
            this.field_71462_r.func_73876_c();
            GlStateManager.func_179094_E();
            GlStateManager.func_179086_m((int)16640);
            this.field_147124_at.func_147610_a(true);
            GlStateManager.func_179098_w();
            GlStateManager.func_179083_b((int)0, (int)0, (int)this.field_71443_c, (int)this.field_71440_d);
            ScaledResolution scaledResolution = new ScaledResolution((Minecraft)this);
            GlStateManager.func_179086_m((int)256);
            GlStateManager.func_179128_n((int)5889);
            GlStateManager.func_179096_D();
            GlStateManager.func_179130_a((double)0.0, (double)scaledResolution.func_78327_c(), (double)scaledResolution.func_78324_d(), (double)0.0, (double)1000.0, (double)3000.0);
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179096_D();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-2000.0f);
            GlStateManager.func_179086_m((int)256);
            int width = scaledResolution.func_78326_a();
            int height = scaledResolution.func_78328_b();
            int mouseX = Mouse.getX() * width / this.field_71443_c;
            int mouseY = height - Mouse.getY() * height / this.field_71440_d - 1;
            this.field_71462_r.func_73863_a(mouseX, mouseY, 0.0f);
            this.field_147124_at.func_147609_e();
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            this.field_147124_at.func_147615_c(this.field_71443_c, this.field_71440_d);
            GlStateManager.func_179121_F();
            this.func_175601_h();
            Thread.yield();
            Display.sync((int)60);
            this.func_71361_d("VanillaFix GUI Loop");
        }
    }

    public void displayCrashScreen(CrashReport report) {
        try {
            CrashUtils.outputReport(report);
            this.field_71434_R = false;
            this.field_83002_am = -1L;
            this.crashIntegratedServerNextTick = false;
            this.field_71474_y.field_74330_P = false;
            this.field_71456_v.func_146158_b().func_146231_a(true);
            this.runGUILoop(new GuiCrashScreen(report));
        }
        catch (Throwable t) {
            field_147123_G.error("An uncaught exception occured while displaying the crash screen, making normal report instead", t);
            this.func_71377_b(report);
            System.exit(report.func_71497_f() != null ? -1 : -2);
        }
    }

    @Overwrite
    public void func_71377_b(CrashReport report) {
        CrashUtils.outputReport(report);
    }

    public void resetGameState() {
        try {
            int originalMemoryReserveSize = -1;
            try {
                if (field_71444_a != null) {
                    originalMemoryReserveSize = field_71444_a.length;
                    field_71444_a = new byte[0];
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            StateManager.resetStates();
            if (this.func_147114_u() != null) {
                this.func_147114_u().func_147298_b().func_150718_a((ITextComponent)new TextComponentString("[VanillaFix] Client crashed"));
            }
            this.func_71403_a(null);
            if (this.field_71460_t.func_147702_a()) {
                this.field_71460_t.func_181022_b();
            }
            this.field_152351_aB.clear();
            GlUtil.resetState();
            if (originalMemoryReserveSize != -1) {
                try {
                    field_71444_a = new byte[originalMemoryReserveSize];
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            System.gc();
        }
        catch (Throwable t) {
            field_147123_G.error("Failed to reset state after a crash", t);
            try {
                StateManager.resetStates();
                GlUtil.resetState();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Overwrite
    public void func_71398_f() {
        this.resetGameState();
    }

    @Redirect(method={"runTickKeyboard"}, at=@At(value="FIELD", target="Lnet/minecraft/client/Minecraft;debugCrashKeyPressTime:J", ordinal=0))
    private long checkForF3C(Minecraft mc) {
        if (Keyboard.isKeyDown((int)61) && Keyboard.isKeyDown((int)46)) {
            this.field_83002_am = MixinMinecraft.func_71386_F();
            this.field_184129_aV = true;
        } else {
            this.field_83002_am = -1L;
        }
        if (this.field_83002_am > 0L && MixinMinecraft.func_71386_F() - this.field_83002_am >= 0L) {
            if (GuiScreen.func_146272_n()) {
                if (GuiScreen.func_175283_s()) {
                    if (this.field_71455_al) {
                        this.field_71437_Z.func_152344_a(() -> {
                            throw new ReportedException(new CrashReport("Manually triggered server-side scheduled task exception", new Throwable()));
                        });
                    }
                } else {
                    this.field_152351_aB.add((FutureTask<?>)ListenableFutureTask.create(() -> {
                        throw new ReportedException(new CrashReport("Manually triggered client-side scheduled task exception", new Throwable()));
                    }));
                }
            } else if (GuiScreen.func_175283_s()) {
                if (this.field_71455_al) {
                    this.crashIntegratedServerNextTick = true;
                }
            } else {
                throw new ReportedException(new CrashReport("Manually triggered client-side debug crash", new Throwable()));
            }
        }
        return -1L;
    }

    @Redirect(method={"runTickKeyboard"}, at=@At(value="INVOKE", target="Lorg/lwjgl/input/Keyboard;isKeyDown(I)Z", ordinal=0))
    private boolean isKeyDownF3(int key) {
        return false;
    }

    @Override
    public boolean shouldCrashIntegratedServerNextTick() {
        return this.crashIntegratedServerNextTick;
    }

    @Override
    public void makeErrorNotification(CrashReport report) {
        ProblemToast lastToast;
        if (ModConfig.crashes.replaceErrorNotifications && (lastToast = (ProblemToast)this.func_193033_an().func_192990_a(ProblemToast.class, IToast.field_193655_b)) != null) {
            lastToast.hide = true;
        }
        this.func_193033_an().func_192988_a((IToast)new ProblemToast(report));
    }

    @Inject(method={"runTickKeyboard"}, at={@At(value="HEAD")})
    private void checkForCtrlI(CallbackInfo ci) {
        ProblemToast lastToast;
        if (GuiScreen.func_146271_m() && !GuiScreen.func_146272_n() && !GuiScreen.func_175283_s() && Keyboard.isKeyDown((int)23) && (lastToast = (ProblemToast)this.func_193033_an().func_192990_a(ProblemToast.class, IToast.field_193655_b)) != null) {
            lastToast.hide = true;
            this.func_147108_a(new GuiWarningScreen(lastToast.report, this.field_71462_r));
        }
    }

    @Override
    public void showWarningScreen(CrashReport report) {
        this.func_152344_a(() -> this.func_147108_a(new GuiWarningScreen(report, this.field_71462_r)));
    }
}

