/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.handler.compability.jei.imbuing;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import lumien.randomthings.handler.compability.jei.RandomThingsPlugin;
import lumien.randomthings.handler.compability.jei.imbuing.ImbuingRecipeWrapper;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class ImbuingRecipeCategory
implements IRecipeCategory {
    private static final int ingredientSlot1 = 0;
    private static final int ingredientSlot2 = 1;
    private static final int ingredientSlot3 = 2;
    private static final int toImbueSlot = 3;
    private static final int outputSlot = 4;
    private static final int outputSlotX = 92;
    private static final int outputSlotY = 47;
    @Nonnull
    private final IDrawable background;
    @Nonnull
    private final IDrawable slotDrawable;
    @Nonnull
    private final String localizedName;

    public ImbuingRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation location = new ResourceLocation("randomthings:textures/gui/imbuingStation.png");
        this.background = guiHelper.createDrawable(location, 32, 6, 112, 112, 0, 0, 0, 0);
        this.localizedName = Translator.translateToLocal((String)"tile.imbuingStation.name");
        this.slotDrawable = guiHelper.getSlotDrawable();
    }

    @Nonnull
    public String getUid() {
        return RandomThingsPlugin.IMBUE_ID;
    }

    @Nonnull
    public String getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(Minecraft minecraft) {
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull IRecipeWrapper recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        itemStacks.init(0, true, 47, 2);
        itemStacks.init(1, true, 2, 47);
        itemStacks.init(2, true, 47, 92);
        itemStacks.init(3, true, 47, 47);
        itemStacks.init(4, false, 92, 47);
        if (recipeWrapper instanceof ImbuingRecipeWrapper) {
            List inputs = ingredients.getInputs(ItemStack.class);
            List inputStacks1 = RandomThingsPlugin.stackHelper.toItemStackList(inputs.get(0));
            List inputStacks2 = RandomThingsPlugin.stackHelper.toItemStackList(inputs.get(1));
            List inputStacks3 = RandomThingsPlugin.stackHelper.toItemStackList(inputs.get(2));
            List toImbueStacks = RandomThingsPlugin.stackHelper.toItemStackList(inputs.get(3));
            itemStacks.set(0, inputStacks1);
            itemStacks.set(1, inputStacks2);
            itemStacks.set(2, inputStacks3);
            itemStacks.set(3, toImbueStacks);
            itemStacks.set(4, (List)ingredients.getOutputs(ItemStack.class).get(0));
        }
    }

    public IDrawable getIcon() {
        return null;
    }

    public List getTooltipStrings(int mouseX, int mouseY) {
        return Lists.newArrayList();
    }

    public String getModName() {
        return "Random Things";
    }
}

