/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.tileentity;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import lumien.randomthings.block.BlockPotionVaporizer;
import lumien.randomthings.lib.ISlotFilter;
import lumien.randomthings.network.PacketHandler;
import lumien.randomthings.network.messages.MessagePotionVaporizerParticles;
import lumien.randomthings.tileentity.TileEntityBase;
import lumien.randomthings.util.WorldUtil;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.common.network.NetworkRegistry;

public class TileEntityPotionVaporizer
extends TileEntityBase
implements ITickable {
    HashSet<BlockPos> affectedBlocks = new HashSet();
    final int MAX_BLOCKS = 100;
    PotionEffect currentPotionEffect;
    int durationLeft = 1;
    int fuelBurn;
    int fuelBurnTime = 0;
    HashSet<BlockPos> validBlocks = new HashSet();
    HashSet<BlockPos> checkedBlocks = new HashSet();
    ArrayList<BlockPos> toBeChecked = new ArrayList();
    int checkCounter;
    boolean firstCheck = true;

    public TileEntityPotionVaporizer() {
        this.setItemHandler(3);
        this.setItemHandlerPublic(new int[]{0, 1}, new int[]{2});
        this.addSlotFilter(0, new ISlotFilter(){

            @Override
            public boolean isItemStackValid(ItemStack is) {
                return TileEntityFurnace.func_145954_b((ItemStack)is);
            }
        });
        this.addSlotFilter(1, new ISlotFilter(){

            @Override
            public boolean isItemStackValid(ItemStack is) {
                if (is.func_77973_b() != Items.field_151068_bn) {
                    return false;
                }
                List effects = PotionUtils.func_185189_a((ItemStack)is);
                if (effects == null || effects.size() == 0) {
                    return false;
                }
                return !((PotionEffect)effects.get(0)).func_188419_a().func_76403_b();
            }
        });
        this.addSlotFilter(2, new ISlotFilter(){

            @Override
            public boolean isItemStackValid(ItemStack is) {
                return is.func_77973_b() == Items.field_151069_bo;
            }
        });
    }

    @Override
    public void writeDataToNBT(NBTTagCompound compound, boolean sync) {
        compound.func_74768_a("durationLeft", this.durationLeft);
        compound.func_74768_a("fuelBurn", this.fuelBurn);
        compound.func_74768_a("fuelBurnTime", this.fuelBurnTime);
        NBTTagCompound potionEffectCompound = new NBTTagCompound();
        if (this.currentPotionEffect != null) {
            this.currentPotionEffect.func_82719_a(potionEffectCompound);
            compound.func_74782_a("currentPotionEffect", (NBTBase)potionEffectCompound);
        }
        NBTTagList affectedBlocksList = new NBTTagList();
        for (BlockPos pos : this.affectedBlocks) {
            NBTTagCompound posCompound = new NBTTagCompound();
            posCompound.func_74768_a("posX", pos.func_177958_n());
            posCompound.func_74768_a("posY", pos.func_177956_o());
            posCompound.func_74768_a("posZ", pos.func_177952_p());
            affectedBlocksList.func_74742_a((NBTBase)posCompound);
        }
        compound.func_74782_a("affectedBlocks", (NBTBase)affectedBlocksList);
    }

    @Override
    public void readDataFromNBT(NBTTagCompound compound, boolean sync) {
        this.durationLeft = compound.func_74762_e("durationLeft");
        this.fuelBurn = compound.func_74762_e("fuelBurn");
        this.fuelBurnTime = compound.func_74762_e("fuelBurnTime");
        if (compound.func_74764_b("currentPotionEffect")) {
            NBTTagCompound potionEffectCompound = compound.func_74775_l("currentPotionEffect");
            this.currentPotionEffect = PotionEffect.func_82722_b((NBTTagCompound)potionEffectCompound);
        }
        NBTTagList affectedBlocksList = compound.func_150295_c("affectedBlocks", 10);
        for (int i = 0; i < affectedBlocksList.func_74745_c(); ++i) {
            NBTTagCompound posCompound = affectedBlocksList.func_150305_b(i);
            this.affectedBlocks.add(new BlockPos(posCompound.func_74762_e("posX"), posCompound.func_74762_e("posY"), posCompound.func_74762_e("posZ")));
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            int roomSteps = this.affectedBlocks.size() > 0 ? 2 : 5;
            for (int i = 0; i < roomSteps; ++i) {
                this.stepRoomDetection();
            }
            this.stepPotionTank();
            this.stepFuel();
            if (this.fuelBurnTime > 0 && this.affectedBlocks.size() > 0) {
                this.stepPotionEffect();
                this.spawnParticles();
            }
        }
    }

    public int getDurationLeft() {
        return this.durationLeft;
    }

    public int getDuration() {
        if (this.currentPotionEffect != null) {
            return this.currentPotionEffect.func_76459_b();
        }
        return 0;
    }

    public int getColor() {
        if (this.currentPotionEffect != null) {
            return this.currentPotionEffect.func_188419_a().func_76401_j();
        }
        return 0;
    }

    private void stepFuel() {
        if (this.fuelBurnTime > 0) {
            --this.fuelBurnTime;
        } else if (this.currentPotionEffect != null && this.affectedBlocks.size() > 0 && !this.getItemHandler().getStackInSlot(0).func_190926_b() && this.durationLeft > 0) {
            this.fuelBurnTime = this.fuelBurn = TileEntityFurnace.func_145952_a((ItemStack)this.getItemHandler().getStackInSlot(0));
            this.getItemHandler().extractItem(0, 1, false);
        }
    }

    private void stepPotionTank() {
        List effects;
        ItemStack output;
        ItemStack newPotion;
        if (!(this.currentPotionEffect != null || (newPotion = this.getItemHandler().getStackInSlot(1)).func_190926_b() || !(output = this.getItemHandler().getStackInSlot(2)).func_190926_b() && output.func_190916_E() >= 64 || (effects = PotionUtils.func_185189_a((ItemStack)newPotion)) == null || effects.isEmpty() || ((PotionEffect)effects.get(0)).func_188419_a().func_76403_b())) {
            this.currentPotionEffect = new PotionEffect((PotionEffect)effects.get(0));
            this.durationLeft = this.currentPotionEffect.func_76459_b();
            this.getItemHandler().extractItem(1, 1, false);
            if (!output.func_190926_b()) {
                output.func_190917_f(1);
            } else {
                this.getItemHandler().insertItem(2, new ItemStack(Items.field_151069_bo, 1, 0), false);
            }
        }
    }

    private void stepPotionEffect() {
        if (!this.field_145850_b.field_72995_K && this.currentPotionEffect != null) {
            --this.durationLeft;
            AxisAlignedBB[] bbs = new AxisAlignedBB[this.affectedBlocks.size()];
            int counter = 0;
            for (BlockPos pos : this.affectedBlocks) {
                bbs[counter] = new AxisAlignedBB(pos, pos.func_177982_a(1, 1, 1));
                ++counter;
            }
            for (EntityLivingBase entity : WorldUtil.getEntitiesWithinAABBs(this.field_145850_b, EntityLivingBase.class, bbs)) {
                boolean isNightVision;
                PotionEffect activeEffect = entity.func_70660_b(this.currentPotionEffect.func_188419_a());
                boolean bl = isNightVision = this.currentPotionEffect.func_188419_a() == MobEffects.field_76439_r;
                if (activeEffect != null && activeEffect.func_76459_b() >= (isNightVision ? 205 : 3)) continue;
                PotionEffect applyEffect = new PotionEffect(new PotionEffect(this.currentPotionEffect.func_188419_a(), isNightVision ? 205 : 80, this.currentPotionEffect.func_76458_c(), this.currentPotionEffect.func_82720_e(), this.currentPotionEffect.func_188418_e()));
                entity.func_70690_d(applyEffect);
            }
        }
        if (this.durationLeft == 0) {
            this.currentPotionEffect = null;
        }
    }

    private void spawnParticles() {
        if (!this.field_145850_b.field_72995_K && this.currentPotionEffect != null && this.field_145850_b.func_82737_E() % 5L == 0L) {
            MessagePotionVaporizerParticles message = new MessagePotionVaporizerParticles(new ArrayList<BlockPos>(this.affectedBlocks), this.currentPotionEffect.func_188419_a().func_76401_j());
            PacketHandler.INSTANCE.sendToAllAround(message, new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 32.0));
        }
    }

    private void stepRoomDetection() {
        if (this.firstCheck) {
            EnumFacing facing = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockPotionVaporizer.FACING);
            this.toBeChecked.add(this.field_174879_c.func_177972_a(facing));
            this.firstCheck = false;
        }
        if (this.checkCounter > 100) {
            this.affectedBlocks.clear();
            this.validBlocks.clear();
            this.reset();
        } else if (this.toBeChecked.size() > 0) {
            BlockPos toCheck = this.toBeChecked.remove(0);
            if (!this.checkedBlocks.contains(toCheck)) {
                this.checkedBlocks.add(toCheck);
                if (this.field_145850_b.func_175667_e(toCheck) && this.field_145850_b.func_175623_d(toCheck)) {
                    this.validBlocks.add(toCheck);
                    ++this.checkCounter;
                    for (EnumFacing facing : EnumFacing.field_82609_l) {
                        BlockPos nextPos = new BlockPos((Vec3i)toCheck.func_177972_a(facing));
                        if (this.checkedBlocks.contains(nextPos)) continue;
                        this.toBeChecked.add(nextPos);
                    }
                }
            }
        } else {
            this.reset();
        }
    }

    private void reset() {
        this.affectedBlocks.clear();
        this.affectedBlocks.addAll(this.validBlocks);
        this.checkCounter = 0;
        this.toBeChecked.clear();
        this.validBlocks.clear();
        this.checkedBlocks.clear();
        EnumFacing facing = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockPotionVaporizer.FACING);
        this.toBeChecked.add(this.field_174879_c.func_177972_a(facing));
    }

    public int getPotionID() {
        if (this.currentPotionEffect == null) {
            return 0;
        }
        return Potion.func_188409_a((Potion)this.currentPotionEffect.func_188419_a());
    }

    public int getAmplifier() {
        if (this.currentPotionEffect == null) {
            return 0;
        }
        return this.currentPotionEffect.func_76458_c();
    }

    public int getFuelBurnTime() {
        return this.fuelBurnTime;
    }

    public int getFuelBurn() {
        return this.fuelBurn;
    }
}

