/*
 * Decompiled with CFR 0.152.
 */
package reborncore.client.gui.builder.slot.elements;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import reborncore.api.recipe.IRecipeCrafterProvider;
import reborncore.client.gui.builder.GuiBase;
import reborncore.client.gui.builder.slot.GuiSlotConfiguration;
import reborncore.client.gui.builder.slot.elements.ButtonElement;
import reborncore.client.gui.builder.slot.elements.CheckBoxElement;
import reborncore.client.gui.builder.slot.elements.ElementBase;
import reborncore.client.gui.builder.slot.elements.SlotConfigPopupElement;
import reborncore.client.gui.builder.slot.elements.SlotType;
import reborncore.client.gui.builder.slot.elements.Sprite;
import reborncore.client.gui.slots.BaseSlot;
import reborncore.common.recipes.RecipeCrafter;

public class ConfigSlotElement
extends ElementBase {
    SlotType type;
    IInventory inventory;
    int id;
    public List<ElementBase> elements = new ArrayList<ElementBase>();
    boolean filter = false;

    public ConfigSlotElement(IInventory slotInventory, int slotId, SlotType type, int x, int y, GuiBase gui) {
        super(x, y, type.getButtonSprite());
        this.type = type;
        this.inventory = slotInventory;
        this.id = slotId;
        boolean inputEnabled = gui.container.field_75151_b.stream().filter(Objects::nonNull).filter(slot -> slot.field_75224_c == this.inventory).filter(slot -> slot instanceof BaseSlot).map(slot -> (BaseSlot)((Object)slot)).filter(baseSlot -> baseSlot.getSlotIndex() == slotId).allMatch(BaseSlot::canWorldBlockInsert);
        SlotConfigPopupElement popupElement = new SlotConfigPopupElement(this.id, x - 22, y - 22, this, inputEnabled);
        this.elements.add(popupElement);
        this.elements.add(new ButtonElement(x + 37, y - 25, Sprite.EXIT_BUTTON).addReleaseAction((element, gui1, provider, mouseX, mouseY) -> {
            GuiSlotConfiguration.selectedSlot = -1;
            GuiBase.slotConfigType = GuiBase.SlotConfigType.NONE;
            return true;
        }));
        if (inputEnabled) {
            this.elements.add(new CheckBoxElement("Auto Input", -1, x - 26, y + 42, "input", slotId, Sprite.LIGHT_CHECK_BOX, gui.getMachine(), checkBoxElement -> checkBoxElement.machineBase.slotConfiguration.getSlotDetails(checkBoxElement.slotID).autoInput()).addPressAction((element, gui12, provider, mouseX, mouseY) -> {
                popupElement.updateCheckBox((CheckBoxElement)element, "input", gui12);
                return true;
            }));
        }
        this.elements.add(new CheckBoxElement("Auto Output", -1, x - 26, y + (inputEnabled ? 57 : 42), "output", slotId, Sprite.LIGHT_CHECK_BOX, gui.getMachine(), checkBoxElement -> checkBoxElement.machineBase.slotConfiguration.getSlotDetails(checkBoxElement.slotID).autoOutput()).addPressAction((element, gui13, provider, mouseX, mouseY) -> {
            popupElement.updateCheckBox((CheckBoxElement)element, "output", gui13);
            return true;
        }));
        if (gui.getMachine() instanceof IRecipeCrafterProvider) {
            RecipeCrafter recipeCrafter = ((IRecipeCrafterProvider)((Object)gui.getMachine())).getRecipeCrafter();
            if (Arrays.stream(recipeCrafter.inputSlots).anyMatch(value -> value == slotId)) {
                this.elements.add(new CheckBoxElement("Filter Input", -1, x - 26, y + 72, "filter", slotId, Sprite.LIGHT_CHECK_BOX, gui.getMachine(), checkBoxElement -> checkBoxElement.machineBase.slotConfiguration.getSlotDetails(checkBoxElement.slotID).filter()).addPressAction((element, gui13, provider, mouseX, mouseY) -> {
                    popupElement.updateCheckBox((CheckBoxElement)element, "filter", gui13);
                    return true;
                }));
                this.filter = true;
                popupElement.filter = true;
            }
        }
        this.setWidth(85);
        this.setHeight(105 + (this.filter ? 15 : 0));
    }

    @Override
    public void draw(GuiBase gui) {
        super.draw(gui);
        ItemStack stack = this.inventory.func_70301_a(this.id);
        int xPos = this.x + 1 + gui.field_147003_i;
        int yPos = this.y + 1 + gui.field_147009_r;
        GlStateManager.func_179126_j();
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderHelper.func_74520_c();
        RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
        renderItem.func_184391_a((EntityLivingBase)gui.field_146297_k.field_71439_g, stack, xPos, yPos);
        renderItem.func_180453_a(gui.field_146297_k.field_71466_p, stack, xPos, yPos, null);
        GlStateManager.func_179097_i();
        GlStateManager.func_179140_f();
        GlStateManager.func_179121_F();
        if (this.isHovering) {
            this.drawSprite(gui, this.type.getButtonHoverOverlay(), this.x, this.y);
        }
        this.elements.forEach(elementBase -> elementBase.draw(gui));
    }

    public SlotType getType() {
        return this.type;
    }

    public int getId() {
        return this.id;
    }
}

