/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.capabilities.hacking;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.IHackableEntity;
import me.desht.pneumaticcraft.api.hacking.IHacking;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.PneumaticHelmetRegistry;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;

public class HackingImpl
implements IHacking {
    private final List<IHackableEntity> hackables = new ArrayList<IHackableEntity>();

    @Override
    public void update(Entity entity) {
        this.hackables.removeIf(hackable -> !hackable.afterHackTick(entity));
    }

    @Override
    public void addHackable(IHackableEntity hackable) {
        this.hackables.add(hackable);
    }

    @Override
    public List<IHackableEntity> getCurrentHacks() {
        return this.hackables;
    }

    public static class Storage
    implements Capability.IStorage<IHacking> {
        @Nullable
        public NBTBase writeNBT(Capability<IHacking> capability, IHacking instance, EnumFacing side) {
            NBTTagCompound compound = new NBTTagCompound();
            if (!instance.getCurrentHacks().isEmpty()) {
                NBTTagList tagList = new NBTTagList();
                for (IHackableEntity hackableEntity : instance.getCurrentHacks()) {
                    if (hackableEntity.getId() == null) continue;
                    NBTTagCompound tag = new NBTTagCompound();
                    tag.func_74778_a("id", hackableEntity.getId());
                    tagList.func_74742_a((NBTBase)tag);
                }
                compound.func_74782_a("hackables", (NBTBase)tagList);
            }
            return compound;
        }

        public void readNBT(Capability<IHacking> capability, IHacking instance, EnumFacing side, NBTBase nbt) {
            instance.getCurrentHacks().clear();
            NBTTagList tagList = ((NBTTagCompound)nbt).func_150295_c("hackables", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                String hackableId = tagList.func_150305_b(i).func_74779_i("id");
                Class<? extends IHackableEntity> hackableClass = PneumaticHelmetRegistry.getInstance().stringToEntityHackables.get(hackableId);
                if (hackableClass != null) {
                    try {
                        instance.getCurrentHacks().add(hackableClass.newInstance());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                Log.warning("hackable \"" + hackableId + "\" not found when constructing from NBT. Was it deleted?");
            }
        }
    }
}

