/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets;

import java.util.List;
import me.desht.pneumaticcraft.client.gui.GuiProgrammer;
import me.desht.pneumaticcraft.client.gui.programmer.GuiProgWidgetImportExport;
import me.desht.pneumaticcraft.common.progwidgets.ICountWidget;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ISidedWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetAreaItemBase;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ProgWidgetInventoryBase
extends ProgWidgetAreaItemBase
implements ISidedWidget,
ICountWidget {
    private boolean[] accessingSides = new boolean[]{true, true, true, true, true, true};
    private boolean useCount;
    private int count = 1;

    @Override
    public void addErrors(List<String> curInfo, List<IProgWidget> widgets) {
        super.addErrors(curInfo, widgets);
        boolean sideActive = false;
        for (boolean bool : this.accessingSides) {
            sideActive |= bool;
        }
        if (!sideActive) {
            curInfo.add("gui.progWidget.general.error.noSideActive");
        }
    }

    @Override
    public void setSides(boolean[] sides) {
        this.accessingSides = sides;
    }

    @Override
    public boolean[] getSides() {
        return this.accessingSides;
    }

    @Override
    public boolean useCount() {
        return this.useCount;
    }

    @Override
    public void setUseCount(boolean useCount) {
        this.useCount = useCount;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public void setCount(int count) {
        this.count = count;
    }

    @Override
    public void getTooltip(List<String> curTooltip) {
        super.getTooltip(curTooltip);
        if (this.isUsingSides()) {
            curTooltip.add("Accessing sides:");
        }
        curTooltip.add(this.getExtraStringInfo());
        if (this.useCount) {
            curTooltip.add("Using count (" + this.count + ")");
        }
    }

    protected boolean isUsingSides() {
        return true;
    }

    @Override
    public String getExtraStringInfo() {
        boolean allSides = true;
        boolean noSides = true;
        for (boolean bool : this.accessingSides) {
            if (bool) {
                noSides = false;
                continue;
            }
            allSides = false;
        }
        if (allSides) {
            return "All sides";
        }
        if (noSides) {
            return "No Sides";
        }
        StringBuilder tip = new StringBuilder();
        block9: for (int i = 0; i < 6; ++i) {
            if (!this.accessingSides[i]) continue;
            switch (EnumFacing.func_82600_a((int)i)) {
                case UP: {
                    tip.append("top, ");
                    continue block9;
                }
                case DOWN: {
                    tip.append("bottom, ");
                    continue block9;
                }
                case NORTH: {
                    tip.append("north, ");
                    continue block9;
                }
                case SOUTH: {
                    tip.append("south, ");
                    continue block9;
                }
                case EAST: {
                    tip.append("east, ");
                    continue block9;
                }
                case WEST: {
                    tip.append("west, ");
                }
            }
        }
        return tip.substring(0, tip.length() - 2);
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        for (int i = 0; i < 6; ++i) {
            tag.func_74757_a(EnumFacing.func_82600_a((int)i).name(), this.accessingSides[i]);
        }
        tag.func_74757_a("useCount", this.useCount);
        tag.func_74768_a("count", this.count);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        for (int i = 0; i < 6; ++i) {
            this.accessingSides[i] = tag.func_74767_n(EnumFacing.func_82600_a((int)i).name());
        }
        this.useCount = tag.func_74767_n("useCount");
        this.count = tag.func_74762_e("count");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getOptionWindow(GuiProgrammer guiProgrammer) {
        return new GuiProgWidgetImportExport<ProgWidgetInventoryBase>(this, guiProgrammer);
    }
}

