/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.computercraft;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.desht.pneumaticcraft.common.thirdparty.computercraft.ILuaMethod;
import org.apache.commons.lang3.Validate;

public class LuaMethodRegistry {
    private final List<ILuaMethod> luaMethods = new ArrayList<ILuaMethod>();
    private final Map<String, Integer> luaMethodMap = new HashMap<String, Integer>();
    private String[] luaMethodNames = null;

    public void registerLuaMethod(ILuaMethod method) {
        Integer idx = this.luaMethodMap.get(method.getMethodName());
        if (idx == null) {
            this.luaMethods.add(method);
            this.luaMethodMap.put(method.getMethodName(), this.luaMethods.size() - 1);
        } else {
            this.luaMethods.set(idx, method);
        }
    }

    public String[] getMethodNames() {
        if (this.luaMethodNames == null) {
            this.luaMethodNames = new String[this.luaMethods.size()];
            Arrays.setAll(this.luaMethodNames, i -> this.luaMethods.get(i).getMethodName());
        }
        return this.luaMethodNames;
    }

    public ILuaMethod getMethod(String methodName) {
        Validate.isTrue((boolean)this.luaMethodMap.containsKey(methodName), (String)("Attempt to get unregistered method '" + methodName + "'."), (Object[])new Object[0]);
        return this.luaMethods.get(this.luaMethodMap.get(methodName));
    }

    public ILuaMethod getMethod(int methodIndex) {
        return this.luaMethods.get(methodIndex);
    }

    public boolean isInited() {
        return !this.luaMethods.isEmpty();
    }
}

