/*
 * Decompiled with CFR 0.152.
 */
package openblocks.api;

import openblocks.api.IFlimFlamAction;
import openblocks.api.IFlimFlamDescription;

public class FlimFlamDescriptionSimple
implements IFlimFlamDescription {
    private boolean isSilent;
    private boolean isSafe;
    private final String name;
    private final int cost;
    private final int weight;
    private int lowerLuck;
    private int upperLuck;
    private final IFlimFlamAction effect;

    public FlimFlamDescriptionSimple(String name, int cost, int weight, IFlimFlamAction effect) {
        this.name = name;
        this.cost = cost;
        this.weight = weight;
        this.effect = effect;
        if (cost < 0) {
            this.setRange(Integer.MIN_VALUE, cost);
        } else {
            this.setRange(cost, Integer.MAX_VALUE);
        }
    }

    public FlimFlamDescriptionSimple markSafe() {
        this.isSafe = true;
        return this;
    }

    public FlimFlamDescriptionSimple markSilent() {
        this.isSilent = true;
        return this;
    }

    public FlimFlamDescriptionSimple setRange(int a, int b) {
        if (a < b) {
            this.lowerLuck = a;
            this.upperLuck = b;
        } else {
            this.lowerLuck = b;
            this.upperLuck = a;
        }
        return this;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int weight() {
        return this.weight;
    }

    @Override
    public int cost() {
        return this.cost;
    }

    @Override
    public boolean isSafe() {
        return this.isSafe;
    }

    @Override
    public boolean isSilent() {
        return this.isSilent;
    }

    @Override
    public IFlimFlamAction action() {
        return this.effect;
    }

    @Override
    public boolean canApply(int luck) {
        return this.lowerLuck <= luck && luck <= this.upperLuck;
    }
}

