/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.common.item;

import com.google.common.collect.Sets;
import java.beans.ConstructorProperties;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Queue;
import java.util.Set;
import javax.vecmath.Point2i;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.commons.lang3.ArrayUtils;
import team.chisel.api.carving.CarvingUtils;
import team.chisel.api.carving.IChiselMode;

public enum ChiselMode implements IChiselMode
{
    SINGLE{

        public Iterable<BlockPos> getCandidates(EntityPlayer player, BlockPos pos, EnumFacing side) {
            return Collections.singleton(pos);
        }

        @Override
        public AxisAlignedBB getBounds(EnumFacing side) {
            return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        }
    }
    ,
    PANEL{
        private final BlockPos ONE = new BlockPos(1, 1, 1);
        private final BlockPos NEG_ONE = new BlockPos(-1, -1, -1);

        public Iterable<BlockPos> getCandidates(EntityPlayer player, BlockPos pos, EnumFacing side) {
            if (side.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE) {
                side = side.func_176734_d();
            }
            Vec3i offset = side.func_176730_m();
            return ChiselMode.filteredIterable(Sets.newHashSet((Iterable)BlockPos.func_177980_a((BlockPos)this.NEG_ONE.func_177971_a(offset).func_177971_a((Vec3i)pos), (BlockPos)this.ONE.func_177973_b(offset).func_177971_a((Vec3i)pos))), player.field_70170_p, player.field_70170_p.func_180495_p(pos));
        }

        @Override
        public AxisAlignedBB getBounds(EnumFacing side) {
            switch (side.func_176740_k()) {
                default: {
                    return new AxisAlignedBB(0.0, -1.0, -1.0, 1.0, 2.0, 2.0);
                }
                case Y: {
                    return new AxisAlignedBB(-1.0, 0.0, -1.0, 2.0, 1.0, 2.0);
                }
                case Z: 
            }
            return new AxisAlignedBB(-1.0, -1.0, 0.0, 2.0, 2.0, 1.0);
        }
    }
    ,
    COLUMN{

        public Iterable<BlockPos> getCandidates(EntityPlayer player, BlockPos pos, EnumFacing side) {
            int facing = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            LinkedHashSet<BlockPos> ret = new LinkedHashSet<BlockPos>();
            for (int i = -1; i <= 1; ++i) {
                if (side != EnumFacing.DOWN && side != EnumFacing.UP) {
                    ret.add(pos.func_177981_b(i));
                    continue;
                }
                if (facing == 0 || facing == 2) {
                    ret.add(pos.func_177970_e(i));
                    continue;
                }
                ret.add(pos.func_177965_g(i));
            }
            return ChiselMode.filteredIterable(ret, player.field_70170_p, player.field_70170_p.func_180495_p(pos));
        }

        @Override
        public AxisAlignedBB getBounds(EnumFacing side) {
            return PANEL.getBounds(side);
        }

        @Override
        public long[] getCacheState(BlockPos origin, EnumFacing side) {
            return ArrayUtils.add((long[])super.getCacheState(origin, side), (long)Minecraft.func_71410_x().field_71439_g.func_174811_aO().ordinal());
        }
    }
    ,
    ROW{

        public Iterable<BlockPos> getCandidates(EntityPlayer player, BlockPos pos, EnumFacing side) {
            int facing = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            LinkedHashSet<BlockPos> ret = new LinkedHashSet<BlockPos>();
            for (int i = -1; i <= 1; ++i) {
                if (side != EnumFacing.DOWN && side != EnumFacing.UP) {
                    if (side == EnumFacing.EAST || side == EnumFacing.WEST) {
                        ret.add(pos.func_177970_e(i));
                        continue;
                    }
                    ret.add(pos.func_177965_g(i));
                    continue;
                }
                if (facing == 0 || facing == 2) {
                    ret.add(pos.func_177965_g(i));
                    continue;
                }
                ret.add(pos.func_177970_e(i));
            }
            return ChiselMode.filteredIterable(ret, player.field_70170_p, player.field_70170_p.func_180495_p(pos));
        }

        @Override
        public AxisAlignedBB getBounds(EnumFacing side) {
            return PANEL.getBounds(side);
        }

        @Override
        public long[] getCacheState(BlockPos origin, EnumFacing side) {
            return COLUMN.getCacheState(origin, side);
        }
    }
    ,
    CONTIGUOUS{

        @Override
        public Iterable<? extends BlockPos> getCandidates(EntityPlayer player, BlockPos pos, EnumFacing side) {
            return () -> ChiselMode.getContiguousIterator(pos, player.field_70170_p, EnumFacing.field_82609_l);
        }

        @Override
        public AxisAlignedBB getBounds(EnumFacing side) {
            int r = 10;
            return new AxisAlignedBB((double)(-r - 1), (double)(-r - 1), (double)(-r - 1), (double)(r + 2), (double)(r + 2), (double)(r + 2));
        }
    }
    ,
    CONTIGUOUS_2D{

        @Override
        public Iterable<? extends BlockPos> getCandidates(EntityPlayer player, BlockPos pos, EnumFacing side) {
            return () -> ChiselMode.getContiguousIterator(pos, player.field_70170_p, (EnumFacing[])ArrayUtils.removeElements((Object[])EnumFacing.field_82609_l, (Object[])new EnumFacing[]{side, side.func_176734_d()}));
        }

        @Override
        public AxisAlignedBB getBounds(EnumFacing side) {
            int r = 10;
            switch (side.func_176740_k()) {
                default: {
                    return new AxisAlignedBB(0.0, (double)(-r - 1), (double)(-r - 1), 1.0, (double)(r + 2), (double)(r + 2));
                }
                case Y: {
                    return new AxisAlignedBB((double)(-r - 1), 0.0, (double)(-r - 1), (double)(r + 2), 1.0, (double)(r + 2));
                }
                case Z: 
            }
            return new AxisAlignedBB((double)(-r - 1), (double)(-r - 1), 0.0, (double)(r + 2), (double)(r + 2), 1.0);
        }
    };

    public static final int CONTIGUOUS_RANGE = 10;

    private ChiselMode() {
        CarvingUtils.getModeRegistry().registerMode(this);
    }

    private static Iterator<BlockPos> getContiguousIterator(final BlockPos origin, final World world, final EnumFacing[] directionsToSearch) {
        final IBlockState state = world.func_180495_p(origin);
        return new Iterator<BlockPos>(){
            private Set<BlockPos> seen;
            private Queue<Node> search;
            {
                this.seen = Sets.newHashSet((Object[])new BlockPos[]{origin});
                this.search = new ArrayDeque<Node>();
                this.search.add(new Node(origin, 0));
            }

            @Override
            public boolean hasNext() {
                return !this.search.isEmpty();
            }

            @Override
            public BlockPos next() {
                Node ret = this.search.poll();
                if (ret.getDistance() < 10) {
                    for (EnumFacing face : directionsToSearch) {
                        BlockPos bp = ret.getPos().func_177972_a(face);
                        if (!this.seen.contains(bp) && world.func_180495_p(bp) == state) {
                            for (EnumFacing obscureCheck : EnumFacing.field_82609_l) {
                                BlockPos obscuringPos = bp.func_177972_a(obscureCheck);
                                IBlockState obscuringState = world.func_180495_p(obscuringPos);
                                if (obscuringState.isSideSolid((IBlockAccess)world, obscuringPos, obscureCheck.func_176734_d())) continue;
                                this.search.offer(new Node(bp, ret.getDistance() + 1));
                                break;
                            }
                        }
                        this.seen.add(bp);
                    }
                }
                return ret.getPos();
            }
        };
    }

    private static Iterable<BlockPos> filteredIterable(Collection<BlockPos> source, World world, IBlockState state) {
        return source.stream().filter(p -> world.func_180495_p(p) == state)::iterator;
    }

    @Override
    public Point2i getSpritePos() {
        return new Point2i(this.ordinal() % 10 * 24, this.ordinal() / 10 * 24);
    }

    private static final class Node {
        private final BlockPos pos;
        private final int distance;

        @ConstructorProperties(value={"pos", "distance"})
        public Node(BlockPos pos, int distance) {
            this.pos = pos;
            this.distance = distance;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public int getDistance() {
            return this.distance;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Node)) {
                return false;
            }
            Node other = (Node)o;
            BlockPos this$pos = this.getPos();
            BlockPos other$pos = other.getPos();
            if (this$pos == null ? other$pos != null : !this$pos.equals(other$pos)) {
                return false;
            }
            return this.getDistance() == other.getDistance();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BlockPos $pos = this.getPos();
            result = result * 59 + ($pos == null ? 43 : $pos.hashCode());
            result = result * 59 + this.getDistance();
            return result;
        }

        public String toString() {
            return "ChiselMode.Node(pos=" + this.getPos() + ", distance=" + this.getDistance() + ")";
        }
    }
}

