/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.text;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import me.lucko.luckperms.lib.text.AbstractBuildableComponent;
import me.lucko.luckperms.lib.text.Component;
import me.lucko.luckperms.lib.text.event.ClickEvent;
import me.lucko.luckperms.lib.text.event.HoverEvent;
import me.lucko.luckperms.lib.text.format.TextColor;
import me.lucko.luckperms.lib.text.format.TextDecoration;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TextComponent
extends AbstractBuildableComponent<TextComponent, Builder> {
    private final @NonNull String content;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(@NonNull String content) {
        return new Builder().content(content);
    }

    public static TextComponent of(@NonNull String content) {
        return TextComponent.builder(content).build();
    }

    public static TextComponent of(@NonNull String content, @Nullable TextColor color) {
        return TextComponent.of(content, color, Collections.emptySet());
    }

    public static TextComponent of(@NonNull String content, @Nullable TextColor color, @NonNull Set<TextDecoration> decorations) {
        return ((Builder)((Builder)TextComponent.builder(content).color(color)).decorations(decorations, true)).build();
    }

    public static TextComponent make(@NonNull Consumer<Builder> consumer) {
        Builder builder = TextComponent.builder();
        consumer.accept(builder);
        return builder.build();
    }

    public static TextComponent make(@NonNull String content, @NonNull Consumer<Builder> consumer) {
        Builder builder = TextComponent.builder(content);
        consumer.accept(builder);
        return builder.build();
    }

    protected TextComponent(@NonNull Builder builder) {
        super(builder);
        this.content = builder.content;
    }

    protected TextComponent(@NonNull List<Component> children, @Nullable TextColor color, @NonNull TextDecoration.State obfuscated, @NonNull TextDecoration.State bold, @NonNull TextDecoration.State strikethrough, @NonNull TextDecoration.State underlined, @NonNull TextDecoration.State italic, @Nullable ClickEvent clickEvent, @Nullable HoverEvent hoverEvent, @Nullable String insertion, @NonNull String content) {
        super(children, color, obfuscated, bold, strikethrough, underlined, italic, clickEvent, hoverEvent, insertion);
        this.content = content;
    }

    public @NonNull String content() {
        return this.content;
    }

    public @NonNull TextComponent content(@NonNull String content) {
        return new TextComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, (String)Preconditions.checkNotNull((Object)content, (Object)"content"));
    }

    @Override
    public @NonNull TextComponent append(@NonNull Component component) {
        this.detectCycle(component);
        ArrayList<Component> children = new ArrayList<Component>(this.children.size() + 1);
        children.addAll(this.children);
        children.add(component);
        return new TextComponent(children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.content);
    }

    @Override
    public @NonNull TextComponent color(@Nullable TextColor color) {
        return new TextComponent(this.children, color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.content);
    }

    @Override
    public @NonNull TextComponent decoration(@NonNull TextDecoration decoration, boolean flag) {
        return (TextComponent)super.decoration(decoration, flag);
    }

    @Override
    public @NonNull TextComponent decoration(@NonNull TextDecoration decoration, @NonNull TextDecoration.State state) {
        switch (decoration) {
            case BOLD: {
                return new TextComponent(this.children, this.color, this.obfuscated, (TextDecoration.State)((Object)Preconditions.checkNotNull((Object)((Object)state), (Object)"flag")), this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.content);
            }
            case ITALIC: {
                return new TextComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, (TextDecoration.State)((Object)Preconditions.checkNotNull((Object)((Object)state), (Object)"flag")), this.clickEvent, this.hoverEvent, this.insertion, this.content);
            }
            case UNDERLINE: {
                return new TextComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, (TextDecoration.State)((Object)Preconditions.checkNotNull((Object)((Object)state), (Object)"flag")), this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.content);
            }
            case STRIKETHROUGH: {
                return new TextComponent(this.children, this.color, this.obfuscated, this.bold, (TextDecoration.State)((Object)Preconditions.checkNotNull((Object)((Object)state), (Object)"flag")), this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.content);
            }
            case OBFUSCATED: {
                return new TextComponent(this.children, this.color, (TextDecoration.State)((Object)Preconditions.checkNotNull((Object)((Object)state), (Object)"flag")), this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.content);
            }
        }
        throw new IllegalArgumentException(String.format("unknown decoration '%s'", decoration));
    }

    @Override
    public @NonNull TextComponent clickEvent(@Nullable ClickEvent event) {
        return new TextComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, event, this.hoverEvent, this.insertion, this.content);
    }

    @Override
    public @NonNull TextComponent hoverEvent(@Nullable HoverEvent event) {
        if (event != null) {
            this.detectCycle(event.value());
        }
        return new TextComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, event, this.insertion, this.content);
    }

    @Override
    public @NonNull TextComponent insertion(@Nullable String insertion) {
        return new TextComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, insertion, this.content);
    }

    @Override
    public @NonNull TextComponent mergeStyle(@NonNull Component that) {
        return new TextComponent(this.children, that.color(), that.decoration(TextDecoration.OBFUSCATED), that.decoration(TextDecoration.BOLD), that.decoration(TextDecoration.STRIKETHROUGH), that.decoration(TextDecoration.UNDERLINE), that.decoration(TextDecoration.ITALIC), that.clickEvent(), that.hoverEvent(), that.insertion(), this.content);
    }

    @Override
    public @NonNull TextComponent mergeColor(@NonNull Component that) {
        return new TextComponent(this.children, that.color(), this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.content);
    }

    @Override
    public @NonNull TextComponent mergeDecorations(@NonNull Component that) {
        TextDecoration.State obfuscated = that.decoration(TextDecoration.OBFUSCATED) != TextDecoration.State.NOT_SET ? that.decoration(TextDecoration.OBFUSCATED) : this.obfuscated;
        TextDecoration.State bold = that.decoration(TextDecoration.BOLD) != TextDecoration.State.NOT_SET ? that.decoration(TextDecoration.BOLD) : this.bold;
        TextDecoration.State strikethrough = that.decoration(TextDecoration.STRIKETHROUGH) != TextDecoration.State.NOT_SET ? that.decoration(TextDecoration.STRIKETHROUGH) : this.strikethrough;
        TextDecoration.State underlined = that.decoration(TextDecoration.UNDERLINE) != TextDecoration.State.NOT_SET ? that.decoration(TextDecoration.UNDERLINE) : this.underlined;
        TextDecoration.State italic = that.decoration(TextDecoration.ITALIC) != TextDecoration.State.NOT_SET ? that.decoration(TextDecoration.ITALIC) : this.italic;
        return new TextComponent(this.children, this.color, obfuscated, bold, strikethrough, underlined, italic, this.clickEvent, this.hoverEvent, this.insertion, this.content);
    }

    @Override
    public @NonNull TextComponent mergeEvents(@NonNull Component that) {
        return new TextComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, that.clickEvent(), that.hoverEvent(), this.insertion, this.content);
    }

    @Override
    public @NonNull TextComponent resetStyle() {
        return new TextComponent(this.children, null, TextDecoration.State.NOT_SET, TextDecoration.State.NOT_SET, TextDecoration.State.NOT_SET, TextDecoration.State.NOT_SET, TextDecoration.State.NOT_SET, null, null, null, this.content);
    }

    @Override
    public @NonNull TextComponent copy() {
        return new TextComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.content);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof TextComponent)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        TextComponent component = (TextComponent)other;
        return Objects.equal((Object)this.content, (Object)component.content);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.content});
    }

    @Override
    protected void populateToString(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull Objects.ToStringHelper builder) {
        builder.add("content", (Object)this.content);
    }

    @Override
    public @NonNull Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder
    extends AbstractBuildableComponent.AbstractBuilder<TextComponent, Builder> {
        private @Nullable String content;

        Builder() {
        }

        Builder(@NonNull TextComponent component) {
            super(component);
            this.content = component.content();
        }

        public @NonNull Builder content(@NonNull String content) {
            this.content = content;
            return this;
        }

        @Override
        public @NonNull TextComponent build() {
            Preconditions.checkState((this.content != null ? 1 : 0) != 0, (Object)"content must be set");
            return new TextComponent(this);
        }
    }
}

