/*
 * Decompiled with CFR 0.152.
 */
package nc;

import nc.config.NCConfig;
import nc.enumm.IFissionStats;
import nc.enumm.IItemMeta;
import nc.enumm.MetaEnums;
import nc.multiblock.turbine.TurbineDynamoCoilType;
import nc.radiation.RadiationHelper;
import nc.util.CollectionHelper;
import nc.util.InfoHelper;
import nc.util.Lang;
import nc.util.NCMath;
import net.minecraft.util.IStringSerializable;

public class NCInfo {
    public static String moderatorPowerInfo = Lang.localise("info.moderator.power", NCMath.decimalPlaces(6.0 / NCConfig.fission_moderator_extra_power, 2));
    public static String moderatorHeatInfo = Lang.localise("info.moderator.heat", NCMath.decimalPlaces(6.0 / NCConfig.fission_moderator_extra_heat, 2));
    public static final String[] POLY_POWER = new String[]{"linearly", "quadratically", "cubicly", "quarticly", "quinticly", "sexticly", "septicly", "octicly", "nonicly", "decicly", "undecicly", "duodecicly", "tredecicly", "quattuordecicly", "quindecicly"};

    public static String[][] coolerInfo() {
        String[][] info = new String[MetaEnums.CoolerType.values().length][];
        info[0] = new String[0];
        for (int i = 1; i < MetaEnums.CoolerType.values().length; ++i) {
            info[i] = CollectionHelper.concatenate(new String[]{NCInfo.coolingRateString(i)}, InfoHelper.formattedInfo(NCInfo.coolerInfoString(i), new Object[0]));
        }
        return info;
    }

    private static String coolingRateString(int meta) {
        return Lang.localise("tile.nuclearcraft.cooler.cooling_rate") + " " + NCMath.decimalPlaces(MetaEnums.CoolerType.values()[meta].getCooling(), 2) + " H/t";
    }

    private static String coolerInfoString(int meta) {
        return Lang.localise("tile.nuclearcraft.cooler." + MetaEnums.CoolerType.values()[meta].name().toLowerCase() + ".desc");
    }

    public static <T extends Enum<T> & IItemMeta> String[][] fuelRodInfo(T[] values) {
        String[][] info = new String[values.length][];
        for (int i = 0; i < values.length; ++i) {
            info[i] = new String[]{Lang.localise("item.nuclearcraft.fission_fuel.base_time.desc", NCMath.decimalPlaces(((IFissionStats)values[i]).getBaseTime() / (1200.0 * NCConfig.fission_fuel_use), 2)), Lang.localise("item.nuclearcraft.fission_fuel.base_power.desc", NCMath.decimalPlaces(((IFissionStats)values[i]).getBasePower() * NCConfig.fission_power, 2)), Lang.localise("item.nuclearcraft.fission_fuel.base_heat.desc", NCMath.decimalPlaces(((IFissionStats)values[i]).getBaseHeat() * NCConfig.fission_heat_generation, 2))};
        }
        return info;
    }

    public static String[][] ingotBlockInfo() {
        String[][] info = new String[MetaEnums.IngotType.values().length][];
        for (int i = 0; i < MetaEnums.IngotType.values().length; ++i) {
            info[i] = InfoHelper.EMPTY_ARRAY;
        }
        info[8] = InfoHelper.formattedInfo(Lang.localise(NCInfo.ingotBlockInfoString(8), moderatorPowerInfo, moderatorHeatInfo), new Object[0]);
        info[9] = InfoHelper.formattedInfo(Lang.localise(NCInfo.ingotBlockInfoString(9), moderatorPowerInfo, moderatorHeatInfo), new Object[0]);
        return info;
    }

    private static String ingotBlockInfoString(int meta) {
        return "tile.nuclearcraft.ingot_block." + MetaEnums.IngotType.values()[meta].name().toLowerCase() + ".desc";
    }

    public static String[][] ingotBlockFixedInfo() {
        String[][] info = new String[MetaEnums.IngotType.values().length][];
        for (int i = 0; i < MetaEnums.IngotType.values().length; ++i) {
            info[i] = InfoHelper.EMPTY_ARRAY;
        }
        info[8] = new String[]{Lang.localise("info.moderator.desc")};
        info[9] = new String[]{Lang.localise("info.moderator.desc")};
        return info;
    }

    public static String[][] dynamoCoilInfo() {
        String[][] info = new String[TurbineDynamoCoilType.values().length][];
        info[0] = new String[0];
        for (int i = 0; i < TurbineDynamoCoilType.values().length; ++i) {
            info[i] = CollectionHelper.concatenate(new String[]{NCInfo.coilConductivityString(i)}, InfoHelper.formattedInfo(NCInfo.coiInfoString(i), new Object[0]));
        }
        return info;
    }

    private static String coilConductivityString(int meta) {
        return Lang.localise("tile.nuclearcraft.turbine_dynamo_coil.conductivity") + " " + NCMath.decimalPlaces(100.0 * TurbineDynamoCoilType.values()[meta].getConductivity(), 1) + "%";
    }

    private static String coiInfoString(int meta) {
        return Lang.localise("tile.nuclearcraft.turbine_dynamo_coil." + TurbineDynamoCoilType.values()[meta].name().toLowerCase() + ".desc");
    }

    public static String[][] upgradeInfo() {
        String[][] info = new String[MetaEnums.UpgradeType.values().length][];
        for (int i = 0; i < MetaEnums.UpgradeType.values().length; ++i) {
            info[i] = InfoHelper.EMPTY_ARRAY;
        }
        info[0] = InfoHelper.formattedInfo(Lang.localise("item.nuclearcraft.upgrade.speed_desc", NCInfo.powerString(NCConfig.speed_upgrade_power_laws[0]), NCInfo.powerString(NCConfig.speed_upgrade_power_laws[1])), new Object[0]);
        info[1] = InfoHelper.formattedInfo(Lang.localise("item.nuclearcraft.upgrade.energy_desc", NCInfo.powerString(NCConfig.energy_upgrade_power_laws[0])), new Object[0]);
        return info;
    }

    private static String powerString(double power) {
        return (power == (double)((int)power) ? "" : Lang.localise("info.nuclearcraft.approximately ")) + POLY_POWER[(int)Math.round(power) - 1];
    }

    public static <T extends Enum<T> & IItemMeta> String[][] oreDropInfo(String type, T[] values, int[] configIds, int[] metas) {
        int i;
        String[][] info = new String[values.length][];
        for (i = 0; i < values.length; ++i) {
            info[i] = null;
        }
        for (i = 0; i < configIds.length; ++i) {
            String unloc = "item.nuclearcraft." + type + "." + ((IStringSerializable)values[metas[i]]).func_176610_l() + ".desc";
            if (!Lang.canLocalise(unloc) || !NCConfig.ore_drops[configIds[i]]) continue;
            info[metas[i]] = InfoHelper.formattedInfo(Lang.localise(unloc), new Object[0]);
        }
        return info;
    }

    public static <T extends Enum<T> & IItemMeta> String[][] dustOreDropInfo() {
        return NCInfo.oreDropInfo((String)"dust", (Enum[])MetaEnums.DustType.values(), (int[])new int[]{1, 2}, (int[])new int[]{9, 10});
    }

    public static <T extends Enum<T> & IItemMeta> String[][] gemOreDropInfo() {
        return NCInfo.oreDropInfo((String)"gem", (Enum[])MetaEnums.GemType.values(), (int[])new int[]{0, 3, 5, 6}, (int[])new int[]{0, 2, 3, 4});
    }

    public static <T extends Enum<T> & IItemMeta> String[][] gemDustOreDropInfo() {
        return NCInfo.oreDropInfo((String)"gem_dust", (Enum[])MetaEnums.GemDustType.values(), (int[])new int[]{4}, (int[])new int[]{6});
    }

    public static String[][] radShieldingInfo() {
        String[][] info = new String[MetaEnums.RadShieldingType.values().length][];
        for (int i = 0; i < MetaEnums.RadShieldingType.values().length; ++i) {
            info[i] = InfoHelper.formattedInfo(Lang.localise("item.nuclearcraft.rad_shielding.desc" + (NCConfig.radiation_hardcore_containers > 0.0 ? "_hardcore" : ""), RadiationHelper.resistanceSigFigs(NCConfig.radiation_shielding_level[i])), new Object[0]);
        }
        return info;
    }
}

