/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.util.Collections;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiBoilerTab;
import mekanism.client.gui.element.GuiGraph;
import mekanism.client.gui.element.GuiHeatInfo;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.boiler.SynchronizedBoilerData;
import mekanism.common.inventory.container.ContainerNull;
import mekanism.common.tile.TileEntityBoilerCasing;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiBoilerStats
extends GuiMekanismTile<TileEntityBoilerCasing> {
    private final GuiGraph boilGraph;
    private final GuiGraph maxGraph;

    public GuiBoilerStats(InventoryPlayer inventory, TileEntityBoilerCasing tile) {
        super(tile, new ContainerNull(inventory.field_70458_d, tile));
        ResourceLocation resource = this.getGuiLocation();
        this.addGuiElement(new GuiBoilerTab(this, (TileEntityBoilerCasing)this.tileEntity, GuiBoilerTab.BoilerTab.MAIN, 6, resource));
        this.addGuiElement(new GuiHeatInfo(() -> {
            UnitDisplayUtils.TemperatureUnit unit = UnitDisplayUtils.TemperatureUnit.values()[MekanismConfig.current().general.tempUnit.val().ordinal()];
            String environment = UnitDisplayUtils.getDisplayShort(((SynchronizedBoilerData)((TileEntityBoilerCasing)this.tileEntity).structure).lastEnvironmentLoss * unit.intervalSize, false, unit);
            return Collections.singletonList(LangUtils.localize("gui.dissipated") + ": " + environment + "/t");
        }, (IGuiWrapper)this, resource));
        this.boilGraph = new GuiGraph(this, resource, 8, 83, 160, 36, data -> LangUtils.localize("gui.boilRate") + ": " + data + " mB/t");
        this.addGuiElement(this.boilGraph);
        this.maxGraph = new GuiGraph(this, resource, 8, 122, 160, 36, data -> LangUtils.localize("gui.maxBoil") + ": " + data + " mB/t");
        this.addGuiElement(this.maxGraph);
        this.maxGraph.enableFixedScale((int)((double)((SynchronizedBoilerData)((TileEntityBoilerCasing)this.tileEntity).structure).superheatingElements * MekanismConfig.current().general.superheatingHeatTransfer.val() / SynchronizedBoilerData.getHeatEnthalpy()));
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        String stats = LangUtils.localize("gui.boilerStats");
        this.field_146289_q.func_78276_b(stats, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(stats) / 2, 6, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.maxWater") + ": " + ((TileEntityBoilerCasing)this.tileEntity).clientWaterCapacity + " mB", 8, 26, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.maxSteam") + ": " + ((TileEntityBoilerCasing)this.tileEntity).clientSteamCapacity + " mB", 8, 35, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.heatTransfer"), 8, 49, 0x797979);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.superheaters") + ": " + ((SynchronizedBoilerData)((TileEntityBoilerCasing)this.tileEntity).structure).superheatingElements, 14, 58, 0x404040);
        int boilCapacity = (int)((double)((SynchronizedBoilerData)((TileEntityBoilerCasing)this.tileEntity).structure).superheatingElements * MekanismConfig.current().general.superheatingHeatTransfer.val() / SynchronizedBoilerData.getHeatEnthalpy());
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.boilCapacity") + ": " + boilCapacity + " mB/t", 8, 72, 0x404040);
        super.func_146979_b(mouseX, mouseY);
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.boilGraph.addData(((SynchronizedBoilerData)((TileEntityBoilerCasing)this.tileEntity).structure).lastBoilRate);
        this.maxGraph.addData(((SynchronizedBoilerData)((TileEntityBoilerCasing)this.tileEntity).structure).lastMaxBoil);
    }

    @Override
    protected void func_146976_a(float partialTick, int mouseX, int mouseY) {
        this.field_146297_k.field_71446_o.func_110577_a(this.getGuiLocation());
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int guiWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int guiHeight = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(guiWidth, guiHeight, 0, 0, this.field_146999_f, this.field_147000_g);
        super.func_146976_a(partialTick, mouseX, mouseY);
    }

    @Override
    protected ResourceLocation getGuiLocation() {
        return MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiBoilerStats.png");
    }
}

