/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.text.renderer;

import java.text.AttributedCharacterIterator;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.BiFunction;
import net.kyori.text.BuildableComponent;
import net.kyori.text.Component;
import net.kyori.text.ScoreComponent;
import net.kyori.text.SelectorComponent;
import net.kyori.text.TextComponent;
import net.kyori.text.TranslatableComponent;
import net.kyori.text.event.HoverEvent;
import net.kyori.text.renderer.ComponentRenderer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class FriendlyComponentRenderer<C extends ComponentRenderer.Context>
implements ComponentRenderer<C> {
    public static <C extends ComponentRenderer.Context> @NonNull FriendlyComponentRenderer<C> from(final @NonNull BiFunction<Locale, String, MessageFormat> translations) {
        return new FriendlyComponentRenderer<C>(){

            @Override
            protected @NonNull MessageFormat translation(@NonNull Locale locale, @NonNull String key) {
                return (MessageFormat)translations.apply(locale, key);
            }
        };
    }

    @Override
    public @NonNull Component render(@NonNull Component component, @NonNull C context) {
        if (component instanceof TranslatableComponent) {
            return this.render((TranslatableComponent)component, context);
        }
        if (component instanceof TextComponent) {
            TextComponent.Builder builder = TextComponent.builder(((TextComponent)component).content());
            return this.deepRender(component, builder, context).build();
        }
        if (component instanceof ScoreComponent) {
            ScoreComponent sc = (ScoreComponent)component;
            ScoreComponent.Builder builder = ScoreComponent.builder().name(sc.name()).objective(sc.objective()).value(sc.value());
            return this.deepRender(component, builder, context).build();
        }
        if (component instanceof SelectorComponent) {
            SelectorComponent.Builder builder = SelectorComponent.builder(((SelectorComponent)component).pattern());
            return this.deepRender(component, builder, context).build();
        }
        return component;
    }

    private <B extends BuildableComponent.Builder<?, ?>> B deepRender(Component component, B builder, C context) {
        this.mergeStyle(component, builder, context);
        component.children().forEach(child -> builder.append(this.render((Component)child, context)));
        return builder;
    }

    private <B extends BuildableComponent.Builder<?, ?>> void mergeStyle(Component component, B builder, C context) {
        builder.mergeColor(component);
        builder.mergeDecorations(component);
        builder.clickEvent(component.clickEvent());
        Optional.ofNullable(component.hoverEvent()).ifPresent(hoverEvent -> builder.hoverEvent(new HoverEvent(hoverEvent.action(), this.render(hoverEvent.value(), context))));
    }

    private Component render(TranslatableComponent component, C context) {
        MessageFormat format = this.translation(context.locale(), component.key());
        if (format == null) {
            return component;
        }
        List<Component> args = component.args();
        TextComponent.Builder builder = TextComponent.builder();
        this.mergeStyle(component, builder, context);
        if (args.isEmpty()) {
            return builder.content(format.format(null, new StringBuffer(), null).toString()).build();
        }
        Object[] nulls = new Object[args.size()];
        StringBuffer sb = format.format(nulls, new StringBuffer(), (FieldPosition)null);
        AttributedCharacterIterator it = format.formatToCharacterIterator(nulls);
        while (it.getIndex() < it.getEndIndex()) {
            int end = it.getRunLimit();
            Integer index = (Integer)it.getAttribute(MessageFormat.Field.ARGUMENT);
            if (index != null) {
                builder.append(this.render(args.get(index), context));
            } else {
                builder.append(TextComponent.of(sb.substring(it.getIndex(), end)));
            }
            it.setIndex(end);
        }
        return builder.content("").build();
    }

    protected abstract @Nullable MessageFormat translation(@NonNull Locale var1, @NonNull String var2);
}

