/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.okhttp3.internal.platform;

import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.List;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import me.lucko.luckperms.lib.okhttp3.Protocol;
import me.lucko.luckperms.lib.okhttp3.internal.platform.Platform;
import org.conscrypt.Conscrypt;
import org.conscrypt.OpenSSLProvider;

public class ConscryptPlatform
extends Platform {
    private ConscryptPlatform() {
    }

    private Provider getProvider() {
        return new OpenSSLProvider();
    }

    @Override
    public X509TrustManager trustManager(SSLSocketFactory sslSocketFactory) {
        if (!Conscrypt.isConscrypt((SSLSocketFactory)sslSocketFactory)) {
            return super.trustManager(sslSocketFactory);
        }
        try {
            Object sp = ConscryptPlatform.readFieldOrNull(sslSocketFactory, Object.class, "sslParameters");
            if (sp != null) {
                return ConscryptPlatform.readFieldOrNull(sp, X509TrustManager.class, "x509TrustManager");
            }
            return null;
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("clientBuilder.sslSocketFactory(SSLSocketFactory) not supported on Conscrypt", e);
        }
    }

    @Override
    public void configureTlsExtensions(SSLSocket sslSocket, String hostname, List<Protocol> protocols) {
        if (Conscrypt.isConscrypt((SSLSocket)sslSocket)) {
            if (hostname != null) {
                Conscrypt.setUseSessionTickets((SSLSocket)sslSocket, (boolean)true);
                Conscrypt.setHostname((SSLSocket)sslSocket, (String)hostname);
            }
            List<String> names = Platform.alpnProtocolNames(protocols);
            Conscrypt.setApplicationProtocols((SSLSocket)sslSocket, (String[])names.toArray(new String[0]));
        } else {
            super.configureTlsExtensions(sslSocket, hostname, protocols);
        }
    }

    @Override
    @Nullable
    public String getSelectedProtocol(SSLSocket sslSocket) {
        if (Conscrypt.isConscrypt((SSLSocket)sslSocket)) {
            return Conscrypt.getApplicationProtocol((SSLSocket)sslSocket);
        }
        return super.getSelectedProtocol(sslSocket);
    }

    @Override
    public SSLContext getSSLContext() {
        try {
            return SSLContext.getInstance("TLS", this.getProvider());
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("No TLS provider", e);
        }
    }

    public static Platform buildIfSupported() {
        try {
            Class.forName("org.conscrypt.ConscryptEngineSocket");
            if (!Conscrypt.isAvailable()) {
                return null;
            }
            return new ConscryptPlatform();
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Override
    public void configureSslSocketFactory(SSLSocketFactory socketFactory) {
        if (Conscrypt.isConscrypt((SSLSocketFactory)socketFactory)) {
            Conscrypt.setUseEngineSocket((SSLSocketFactory)socketFactory, (boolean)true);
        }
    }
}

