/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.mars.tile;

import java.util.ArrayList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.entity.IDockable;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntityAutoRocket;
import micdoodle8.mods.galacticraft.api.tile.IFuelDock;
import micdoodle8.mods.galacticraft.api.tile.ILandingPadAttachable;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockLandingPadFull;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlockWithInventory;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.tile.TileEntityLandingPad;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.core.world.ChunkLoadingCallback;
import micdoodle8.mods.galacticraft.core.world.IChunkLoader;
import micdoodle8.mods.galacticraft.planets.mars.ConfigManagerMars;
import micdoodle8.mods.galacticraft.planets.mars.blocks.BlockMachineMars;
import micdoodle8.mods.galacticraft.planets.mars.network.PacketSimpleMars;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.fml.relauncher.Side;

public class TileEntityLaunchController
extends TileBaseElectricBlockWithInventory
implements IChunkLoader,
ISidedInventory,
ILandingPadAttachable {
    public static final int WATTS_PER_TICK = 1;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean launchPadRemovalDisabled = true;
    private ForgeChunkManager.Ticket chunkLoadTicket;
    private List<BlockPos> connectedPads = new ArrayList<BlockPos>();
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int frequency = -1;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int destFrequency = -1;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public String ownerName = "";
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean frequencyValid;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean destFrequencyValid;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int launchDropdownSelection;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean launchSchedulingEnabled;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean controlEnabled;
    public boolean hideTargetDestination = true;
    public boolean requiresClientUpdate;
    public Object attachedDock = null;
    private boolean frequencyCheckNeeded = false;

    public TileEntityLaunchController() {
        super("container.launchcontroller.name");
        this.storage.setMaxExtract(6.0f);
        this.noRedstoneControl = true;
        this.inventory = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            boolean bl = this.controlEnabled = this.launchSchedulingEnabled && this.hasEnoughEnergyToRun && !this.getDisabled(0);
            if (this.frequencyCheckNeeded) {
                this.checkDestFrequencyValid();
                this.frequencyCheckNeeded = false;
            }
            if (this.requiresClientUpdate) {
                this.requiresClientUpdate = false;
            }
            if (this.ticks % 40 == 0) {
                this.setFrequency(this.frequency);
                this.setDestinationFrequency(this.destFrequency);
            }
            if (this.ticks % 20 == 0 && this.chunkLoadTicket != null) {
                for (int i = 0; i < this.connectedPads.size(); ++i) {
                    BlockPos coords = this.connectedPads.get(i);
                    Block block = this.field_145850_b.func_180495_p(coords).func_177230_c();
                    if (block == GCBlocks.landingPadFull) continue;
                    this.connectedPads.remove(i);
                    ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.chunkLoadTicket, (ChunkPos)new ChunkPos(coords.func_177958_n() >> 4, coords.func_177952_p() >> 4));
                }
            }
        } else if (this.frequency == -1 && this.destFrequency == -1) {
            GalacticraftCore.packetPipeline.sendToServer((IPacket)new PacketSimpleMars(PacketSimpleMars.EnumSimplePacketMars.S_UPDATE_ADVANCED_GUI, GCCoreUtil.getDimensionID((World)this.field_145850_b), new Object[]{5, this.func_174877_v(), 0}));
        }
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.chunkLoadTicket != null) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.chunkLoadTicket);
        }
    }

    public void onTicketLoaded(ForgeChunkManager.Ticket ticket, boolean placed) {
        if (!this.field_145850_b.field_72995_K && ConfigManagerMars.launchControllerChunkLoad) {
            if (ticket == null) {
                return;
            }
            if (this.chunkLoadTicket == null) {
                this.chunkLoadTicket = ticket;
            }
            NBTTagCompound nbt = this.chunkLoadTicket.getModData();
            nbt.func_74768_a("ChunkLoaderTileX", this.func_174877_v().func_177958_n());
            nbt.func_74768_a("ChunkLoaderTileY", this.func_174877_v().func_177956_o());
            nbt.func_74768_a("ChunkLoaderTileZ", this.func_174877_v().func_177952_p());
            for (int x = -2; x <= 2; ++x) {
                for (int z = -2; z <= 2; ++z) {
                    Block blockID = this.field_145850_b.func_180495_p(this.func_174877_v().func_177982_a(x, 0, z)).func_177230_c();
                    if (!(blockID instanceof BlockLandingPadFull) || this.func_174877_v().func_177958_n() + x >> 4 == this.func_174877_v().func_177958_n() >> 4 && this.func_174877_v().func_177952_p() + z >> 4 == this.func_174877_v().func_177952_p() >> 4) continue;
                    this.connectedPads.add(new BlockPos(this.func_174877_v().func_177958_n() + x, this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p() + z));
                    if (placed) {
                        ChunkLoadingCallback.forceChunk((ForgeChunkManager.Ticket)this.chunkLoadTicket, (World)this.field_145850_b, (int)(this.func_174877_v().func_177958_n() + x), (int)this.func_174877_v().func_177956_o(), (int)(this.func_174877_v().func_177952_p() + z), (String)this.getOwnerName());
                        continue;
                    }
                    ChunkLoadingCallback.addToList((World)this.field_145850_b, (int)this.func_174877_v().func_177958_n(), (int)this.func_174877_v().func_177956_o(), (int)this.func_174877_v().func_177952_p(), (String)this.getOwnerName());
                }
            }
            ChunkLoadingCallback.forceChunk((ForgeChunkManager.Ticket)this.chunkLoadTicket, (World)this.field_145850_b, (int)this.func_174877_v().func_177958_n(), (int)this.func_174877_v().func_177956_o(), (int)this.func_174877_v().func_177952_p(), (String)this.getOwnerName());
        }
    }

    public ForgeChunkManager.Ticket getTicket() {
        return this.chunkLoadTicket;
    }

    public BlockPos getCoords() {
        return new BlockPos(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p());
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.ownerName = nbt.func_74779_i("OwnerName");
        this.launchDropdownSelection = nbt.func_74762_e("LaunchSelection");
        this.frequency = nbt.func_74762_e("ControllerFrequency");
        this.destFrequency = nbt.func_74762_e("TargetFrequency");
        this.frequencyCheckNeeded = true;
        this.launchPadRemovalDisabled = nbt.func_74767_n("LaunchPadRemovalDisabled");
        this.launchSchedulingEnabled = nbt.func_74767_n("LaunchPadSchedulingEnabled");
        this.hideTargetDestination = nbt.func_74767_n("HideTargetDestination");
        this.requiresClientUpdate = GCCoreUtil.getEffectiveSide() == Side.SERVER;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74778_a("OwnerName", this.ownerName);
        nbt.func_74768_a("LaunchSelection", this.launchDropdownSelection);
        nbt.func_74768_a("ControllerFrequency", this.frequency);
        nbt.func_74768_a("TargetFrequency", this.destFrequency);
        nbt.func_74757_a("LaunchPadRemovalDisabled", this.launchPadRemovalDisabled);
        nbt.func_74757_a("LaunchPadSchedulingEnabled", this.launchSchedulingEnabled);
        nbt.func_74757_a("HideTargetDestination", this.hideTargetDestination);
        return nbt;
    }

    public boolean func_145818_k_() {
        return true;
    }

    public boolean func_94041_b(int slotID, ItemStack itemStack) {
        return slotID == 0 && ItemElectricBase.isElectricItem((Item)itemStack.func_77973_b());
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0};
    }

    public boolean func_180462_a(int slotID, ItemStack par2ItemStack, EnumFacing par3) {
        return this.func_94041_b(slotID, par2ItemStack);
    }

    public boolean func_180461_b(int slotID, ItemStack par2ItemStack, EnumFacing par3) {
        return slotID == 0;
    }

    public boolean shouldUseEnergy() {
        return !this.getDisabled(0);
    }

    public void setDisabled(int index, boolean disabled) {
        if (this.disableCooldown == 0) {
            switch (index) {
                case 0: {
                    this.disabled = disabled;
                    this.disableCooldown = 10;
                    break;
                }
                case 1: {
                    this.launchSchedulingEnabled = disabled;
                    break;
                }
                case 2: {
                    this.hideTargetDestination = disabled;
                    this.disableCooldown = 10;
                }
            }
        }
    }

    public boolean getDisabled(int index) {
        switch (index) {
            case 0: {
                return this.disabled;
            }
            case 1: {
                return this.launchSchedulingEnabled;
            }
            case 2: {
                return this.hideTargetDestination;
            }
        }
        return true;
    }

    public boolean canAttachToLandingPad(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        return tile instanceof TileEntityLandingPad;
    }

    public void setFrequency(int frequency) {
        block4: {
            this.frequency = frequency;
            if (this.frequency >= 0) {
                this.frequencyValid = true;
                WorldServer[] servers = GCCoreUtil.getWorldServerList((World)this.field_145850_b);
                for (int i = 0; i < servers.length; ++i) {
                    WorldServer world = servers[i];
                    for (TileEntity tile2 : new ArrayList(world.field_147482_g)) {
                        if (this == tile2 || (tile2 = world.func_175625_s(tile2.func_174877_v())) == null || !(tile2 instanceof TileEntityLaunchController)) continue;
                        TileEntityLaunchController launchController2 = (TileEntityLaunchController)tile2;
                        if (launchController2.frequency != this.frequency) continue;
                        GCLog.debug((String)("Launch Controller frequency conflict at " + tile2.func_174877_v() + " on dim: " + GCCoreUtil.getDimensionID((TileEntity)tile2)));
                        this.frequencyValid = false;
                        break block4;
                    }
                }
            } else {
                this.frequencyValid = false;
            }
        }
    }

    public void setDestinationFrequency(int frequency) {
        if (frequency != this.destFrequency) {
            this.destFrequency = frequency;
            this.checkDestFrequencyValid();
            this.updateRocketOnDockSettings();
        }
    }

    public void checkDestFrequencyValid() {
        if (!this.field_145850_b.field_72995_K) {
            this.destFrequencyValid = false;
            if (this.destFrequency >= 0) {
                WorldServer[] servers = GCCoreUtil.getWorldServerList((World)this.field_145850_b);
                for (int i = 0; i < servers.length; ++i) {
                    WorldServer world = servers[i];
                    for (TileEntity tile2 : new ArrayList(world.field_147482_g)) {
                        if (this == tile2 || (tile2 = world.func_175625_s(tile2.func_174877_v())) == null || !(tile2 instanceof TileEntityLaunchController)) continue;
                        TileEntityLaunchController launchController2 = (TileEntityLaunchController)tile2;
                        if (launchController2.frequency != this.destFrequency) continue;
                        this.destFrequencyValid = true;
                        return;
                    }
                }
            }
        }
    }

    public boolean validFrequency() {
        this.checkDestFrequencyValid();
        return !this.getDisabled(0) && this.hasEnoughEnergyToRun && this.frequencyValid && this.destFrequencyValid;
    }

    public void setLaunchDropdownSelection(int newvalue) {
        if (newvalue != this.launchDropdownSelection) {
            this.launchDropdownSelection = newvalue;
            this.checkDestFrequencyValid();
            this.updateRocketOnDockSettings();
        }
    }

    public void setLaunchSchedulingEnabled(boolean newvalue) {
        if (newvalue != this.launchSchedulingEnabled) {
            this.launchSchedulingEnabled = newvalue;
            this.checkDestFrequencyValid();
            this.updateRocketOnDockSettings();
        }
    }

    public void updateRocketOnDockSettings() {
        TileEntityLandingPad pad;
        IDockable rocket;
        if (this.attachedDock instanceof TileEntityLandingPad && (rocket = (pad = (TileEntityLandingPad)this.attachedDock).getDockedEntity()) instanceof EntityAutoRocket) {
            ((EntityAutoRocket)rocket).updateControllerSettings((IFuelDock)pad);
        }
    }

    public void setAttachedPad(IFuelDock pad) {
        this.attachedDock = pad;
    }

    public EnumFacing getFront() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c() instanceof BlockMachineMars) {
            return (EnumFacing)state.func_177229_b((IProperty)BlockMachineMars.FACING);
        }
        return EnumFacing.NORTH;
    }

    public EnumFacing getElectricInputDirection() {
        return this.getFront().func_176746_e();
    }
}

