/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.core;

import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.util.List;
import javax.annotation.Nonnull;
import org.squiddev.plethora.api.PlethoraAPI;
import org.squiddev.plethora.api.method.IMethod;
import org.squiddev.plethora.api.method.IMethodRegistry;
import org.squiddev.plethora.api.method.IUnbakedContext;
import org.squiddev.plethora.api.method.MethodResult;
import org.squiddev.plethora.core.PlethoraCore;
import org.squiddev.plethora.core.UnbakedContext;

public class MethodWrapper {
    private final List<IMethod<?>> methods;
    private final List<UnbakedContext<?>> contexts;
    private final String[] names;
    private static final IMethodRegistry registry = PlethoraAPI.instance().methodRegistry();

    public MethodWrapper(List<IMethod<?>> methods, List<UnbakedContext<?>> contexts) {
        this.contexts = contexts;
        this.methods = methods;
        this.names = new String[methods.size()];
        String[] names = this.names;
        for (int i = 0; i < names.length; ++i) {
            names[i] = methods.get(i).getName();
        }
    }

    @Nonnull
    public String[] getMethodNames() {
        return this.names;
    }

    public IMethod<?> getMethod(int i) {
        return this.methods.get(i);
    }

    public UnbakedContext<?> getContext(int i) {
        return this.contexts.get(i);
    }

    protected static Object[] getReferences(IComputerAccess access, ILuaContext context) {
        return new Object[]{access, context};
    }

    boolean equalMethods(MethodWrapper other) {
        if (this.methods.equals(other.methods)) {
            return true;
        }
        if (this.methods.size() != other.methods.size()) {
            return false;
        }
        for (IMethod<?> method : this.methods) {
            if (other.methods.contains(method)) continue;
            return false;
        }
        return true;
    }

    static MethodResult doCallMethod(IMethod method, IUnbakedContext<?> context, Object[] args) throws LuaException {
        try {
            double cost = registry.getBaseMethodCost(method);
            if (cost <= 0.0) {
                return method.apply(context, args);
            }
            return context.getCostHandler().await(cost, () -> method.apply(context, args));
        }
        catch (LuaException e) {
            throw e;
        }
        catch (Exception | LinkageError | VirtualMachineError e) {
            PlethoraCore.LOG.error("Unexpected error calling " + method.getName(), e);
            throw new LuaException("Java Exception Thrown: " + e);
        }
    }
}

